/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.present;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.present.Model;
import org.apache.linkis.cli.application.entity.present.Presenter;
import org.apache.linkis.cli.application.exception.PresenterException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.observer.event.LinkisClientEvent;
import org.apache.linkis.cli.application.observer.listener.LinkisClientListener;
import org.apache.linkis.cli.application.present.model.LinkisLogModel;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogPresenter
implements Presenter,
LinkisClientListener {
    private static Logger logger = LoggerFactory.getLogger(LogPresenter.class);

    @Override
    public void update(LinkisClientEvent event, Object msg) {
        LinkisLogModel model = new LinkisLogModel();
        model.buildModel(msg);
        this.present(model);
    }

    @Override
    public void present(Model model) {
        String incLog;
        if (!(model instanceof LinkisLogModel)) {
            throw new PresenterException("PST0001", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PresenterErr, "Input model for \"LinkisLogPresenter\" is not instance of \"LinkisJobIncLogModel\"");
        }
        LinkisLogModel logModel = (LinkisLogModel)model;
        while (!logModel.logFinReceived()) {
            incLog = logModel.consumeLog();
            if (StringUtils.isNotEmpty((CharSequence)incLog)) {
                LoggerManager.getPlaintTextLogger().info(incLog);
            }
            CliUtils.doSleepQuietly(500L);
        }
        incLog = logModel.consumeLog();
        if (StringUtils.isNotEmpty((CharSequence)incLog)) {
            LoggerManager.getPlaintTextLogger().info(incLog);
        }
    }
}

