/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.acessible.executor.log;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineconn.acessible.executor.conf.AccessibleExecutorConfiguration;
import org.apache.linkis.engineconn.acessible.executor.log.AbstractLogCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountLogCache
extends AbstractLogCache {
    private static final Logger logger = LoggerFactory.getLogger(MountLogCache.class);
    private CircularQueue logs;

    public MountLogCache(int loopMax) {
        this.logs = new CircularQueue(loopMax);
    }

    @Override
    public void cacheLog(String log) {
        this.logs.enqueue(log);
    }

    @Override
    public List<String> getLog(int num) {
        return this.logs.dequeue(num);
    }

    @Override
    public synchronized List<String> getRemain() {
        return this.logs.getRemain();
    }

    @Override
    public int size() {
        return this.logs.size();
    }

    class CircularQueue {
        private int max;
        private String[] elements;
        private int front;
        private int rear;
        private int count;

        CircularQueue() {
            this((Integer)AccessibleExecutorConfiguration.ENGINECONN_LOG_CACHE_NUM().getValue());
        }

        CircularQueue(int max) {
            this.max = max;
            this.elements = new String[max];
        }

        public boolean isEmpty() {
            return this.count == 0;
        }

        public synchronized void enqueue(String value) {
            if (this.count == this.max) {
                logger.debug("Queue is full, log: {} needs to be dropped", (Object)value);
            } else {
                this.rear = (this.rear + 1) % this.max;
                this.elements[this.rear] = value;
                ++this.count;
            }
        }

        public String dequeue() {
            if (this.count == 0) {
                logger.debug("Queue is empty, nothing to get");
                return null;
            }
            this.front = (this.front + 1) % this.max;
            --this.count;
            return this.elements[this.front];
        }

        public List<String> dequeue(int num) {
            ArrayList<String> list = new ArrayList<String>();
            for (int index = 0; index < num; ++index) {
                String tempLog = this.dequeue();
                if (StringUtils.isNotEmpty((CharSequence)tempLog)) {
                    list.add(tempLog);
                    continue;
                }
                if (tempLog == null) break;
            }
            return list;
        }

        public synchronized List<String> getRemain() {
            ArrayList<String> list = new ArrayList<String>();
            while (!this.isEmpty()) {
                list.add(this.dequeue());
            }
            return list;
        }

        public int size() {
            return this.count;
        }
    }
}

