/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.TerseException;

public class FeatureCommand {
    public static void main(String ... args) {
        Exit.exit((int)FeatureCommand.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            FeatureCommand.execute(args);
            return 0;
        }
        catch (HelpScreenException e) {
            return 0;
        }
        catch (ArgumentParserException e) {
            System.err.printf("Command line error: " + e.getMessage() + ". Type --help for help.", new Object[0]);
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return 1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void execute(String ... args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-features").defaultHelp(true).description("This tool manages feature flags in Kafka.");
        MutuallyExclusiveGroup bootstrapGroup = parser.addMutuallyExclusiveGroup().required(true);
        bootstrapGroup.addArgument(new String[]{"--bootstrap-server"}).help("A comma-separated list of host:port pairs to use for establishing the connection to the Kafka cluster.");
        bootstrapGroup.addArgument(new String[]{"--bootstrap-controller"}).help("A comma-separated list of host:port pairs to use for establishing the connection to the KRaft quorum.");
        parser.addArgument(new String[]{"--command-config"}).type((ArgumentType)Arguments.fileType()).help("Property file containing configs to be passed to Admin Client.");
        Subparsers subparsers = parser.addSubparsers().dest("command");
        FeatureCommand.addDescribeParser(subparsers);
        FeatureCommand.addUpgradeParser(subparsers);
        FeatureCommand.addDowngradeParser(subparsers);
        FeatureCommand.addDisableParser(subparsers);
        FeatureCommand.addVersionMappingParser(subparsers);
        FeatureCommand.addFeatureDependenciesParser(subparsers);
        Namespace namespace = parser.parseArgsOrFail(args);
        String command = namespace.getString("command");
        String configPath = namespace.getString("command_config");
        Properties properties = configPath == null ? new Properties() : Utils.loadProps((String)configPath);
        CommandLineUtils.initializeBootstrapProperties((Properties)properties, Optional.ofNullable(namespace.getString("bootstrap_server")), Optional.ofNullable(namespace.getString("bootstrap_controller")));
        try (Admin adminClient = Admin.create((Properties)properties);){
            switch (command) {
                case "describe": {
                    FeatureCommand.handleDescribe(namespace, adminClient);
                    return;
                }
                case "upgrade": {
                    FeatureCommand.handleUpgrade(namespace, adminClient);
                    return;
                }
                case "downgrade": {
                    FeatureCommand.handleDowngrade(namespace, adminClient);
                    return;
                }
                case "disable": {
                    FeatureCommand.handleDisable(namespace, adminClient);
                    return;
                }
                case "version-mapping": {
                    FeatureCommand.handleVersionMapping(namespace, Feature.PRODUCTION_FEATURES);
                    return;
                }
                case "feature-dependencies": {
                    FeatureCommand.handleFeatureDependencies(namespace, Feature.PRODUCTION_FEATURES);
                    return;
                }
                default: {
                    throw new TerseException("Unknown command " + command);
                }
            }
        }
    }

    private static void addDescribeParser(Subparsers subparsers) {
        Subparser describeParser = subparsers.addParser("describe").help("Describes the current active feature flags.");
        describeParser.addArgument(new String[]{"--node-id"}).type(Integer.class).help("The node id to which the requests should be sent. If not specified, the requests will be sent to an arbitrary controller/broker.").action((ArgumentAction)Arguments.store());
    }

    private static void addUpgradeParser(Subparsers subparsers) {
        Subparser upgradeParser = subparsers.addParser("upgrade").help("Upgrade one or more feature flags.");
        upgradeParser.addArgument(new String[]{"--metadata"}).help("DEPRECATED -- The level to which we should upgrade the metadata. For example, 3.3-IV3.").action((ArgumentAction)Arguments.store());
        upgradeParser.addArgument(new String[]{"--release-version"}).help("The release version to update all features to. For example, 3.9-IV0 will set metadata.version=21 and kraft.version=1. Use the version-mapping command to learn which features will be set for any given version.").action((ArgumentAction)Arguments.store());
        upgradeParser.addArgument(new String[]{"--feature"}).help("A feature upgrade we should perform, in feature=level format. For example: `metadata.version=5`.").action((ArgumentAction)Arguments.append());
        upgradeParser.addArgument(new String[]{"--dry-run"}).help("Validate this upgrade, but do not perform it.").action((ArgumentAction)Arguments.storeTrue());
    }

    private static void addDowngradeParser(Subparsers subparsers) {
        Subparser downgradeParser = subparsers.addParser("downgrade").help("Downgrade one or more feature flags.");
        downgradeParser.addArgument(new String[]{"--metadata"}).help("DEPRECATED -- The level to which we should downgrade the metadata. For example, 3.3-IV0.").action((ArgumentAction)Arguments.store());
        downgradeParser.addArgument(new String[]{"--release-version"}).help("The release version to downgrade all features to. For example, 3.9-IV0 will set metadata.version=21 and kraft.version=1. Use the version-mapping command to learn which features will be set for any given version.").action((ArgumentAction)Arguments.store());
        downgradeParser.addArgument(new String[]{"--feature"}).help("A feature downgrade we should perform, in feature=level format. For example: `metadata.version=5`.").action((ArgumentAction)Arguments.append());
        downgradeParser.addArgument(new String[]{"--unsafe"}).help("Perform this downgrade even if it may irreversibly destroy metadata.").action((ArgumentAction)Arguments.storeTrue());
        downgradeParser.addArgument(new String[]{"--dry-run"}).help("Validate this downgrade, but do not perform it.").action((ArgumentAction)Arguments.storeTrue());
    }

    private static void addDisableParser(Subparsers subparsers) {
        Subparser downgradeParser = subparsers.addParser("disable").help("Disable one or more feature flags. This is the same as downgrading the version to zero.");
        downgradeParser.addArgument(new String[]{"--feature"}).help("A feature flag to disable.").action((ArgumentAction)Arguments.append());
        downgradeParser.addArgument(new String[]{"--unsafe"}).help("Disable this feature flag even if it may irreversibly destroy metadata.").action((ArgumentAction)Arguments.storeTrue());
        downgradeParser.addArgument(new String[]{"--dry-run"}).help("Perform a dry-run of this disable operation.").action((ArgumentAction)Arguments.storeTrue());
    }

    private static void addVersionMappingParser(Subparsers subparsers) {
        Subparser versionMappingParser = subparsers.addParser("version-mapping").help("Look up the corresponding features for a given metadata version. Using the command with no --release-version  argument will return the mapping for the latest stable metadata version");
        versionMappingParser.addArgument(new String[]{"--release-version"}).help("The release version to use for the corresponding feature mapping. The minimum is " + String.valueOf(MetadataVersion.MINIMUM_VERSION) + "; the default is " + String.valueOf(MetadataVersion.LATEST_PRODUCTION)).action((ArgumentAction)Arguments.store());
    }

    private static void addFeatureDependenciesParser(Subparsers subparsers) {
        Subparser featureDependenciesParser = subparsers.addParser("feature-dependencies").help("Look up dependencies for a given feature version. If the feature is not known or the version not yet defined, an error is thrown. Multiple features can be specified.");
        featureDependenciesParser.addArgument(new String[]{"--feature"}).help("The feature and version to look up dependencies for, in feature=version format. For example: `metadata.version=5`.").required(true).action((ArgumentAction)Arguments.append());
    }

    static String levelToString(String feature, short level) {
        if (feature.equals("metadata.version")) {
            try {
                return MetadataVersion.fromFeatureLevel((short)level).version();
            }
            catch (Throwable e) {
                return "UNKNOWN " + level;
            }
        }
        return String.valueOf(level);
    }

    static void handleDescribe(Namespace namespace, Admin adminClient) throws ExecutionException, InterruptedException {
        DescribeFeaturesOptions describeFeaturesOptions = new DescribeFeaturesOptions();
        if (namespace.getInt("node_id") != null) {
            int nodeId = namespace.getInt("node_id");
            if (nodeId < 0) {
                throw new IllegalArgumentException("Invalid node id " + nodeId + ": must be non-negative.");
            }
            describeFeaturesOptions = describeFeaturesOptions.nodeId(namespace.getInt("node_id").intValue());
        }
        FeatureMetadata featureMetadata = (FeatureMetadata)adminClient.describeFeatures(describeFeaturesOptions).featureMetadata().get();
        featureMetadata.supportedFeatures().keySet().stream().sorted().forEach(feature -> {
            short finalizedLevel = featureMetadata.finalizedFeatures().get(feature) == null ? (short)0 : ((FinalizedVersionRange)featureMetadata.finalizedFeatures().get(feature)).maxVersionLevel();
            SupportedVersionRange range = (SupportedVersionRange)featureMetadata.supportedFeatures().get(feature);
            System.out.printf("Feature: %s\tSupportedMinVersion: %s\tSupportedMaxVersion: %s\tFinalizedVersionLevel: %s\tEpoch: %s%n", feature, FeatureCommand.levelToString(feature, range.minVersion()), FeatureCommand.levelToString(feature, range.maxVersion()), FeatureCommand.levelToString(feature, finalizedLevel), featureMetadata.finalizedFeaturesEpoch().isPresent() ? ((Long)featureMetadata.finalizedFeaturesEpoch().get()).toString() : "-");
        });
    }

    static void handleUpgrade(Namespace namespace, Admin adminClient) throws TerseException {
        FeatureCommand.handleUpgradeOrDowngrade("upgrade", namespace, adminClient, FeatureUpdate.UpgradeType.UPGRADE);
    }

    static FeatureUpdate.UpgradeType downgradeType(Namespace namespace) {
        Boolean unsafe = namespace.getBoolean("unsafe");
        if (unsafe == null || !unsafe.booleanValue()) {
            return FeatureUpdate.UpgradeType.SAFE_DOWNGRADE;
        }
        return FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE;
    }

    static void handleDowngrade(Namespace namespace, Admin adminClient) throws TerseException {
        FeatureCommand.handleUpgradeOrDowngrade("downgrade", namespace, adminClient, FeatureCommand.downgradeType(namespace));
    }

    static String[] parseNameAndLevel(String input) {
        int equalsIndex = input.indexOf("=");
        if (equalsIndex < 0) {
            throw new RuntimeException("Can't parse feature=level string " + input + ": equals sign not found.");
        }
        String name = input.substring(0, equalsIndex).trim();
        String levelString = input.substring(equalsIndex + 1).trim();
        try {
            Short.parseShort(levelString);
        }
        catch (Throwable t) {
            throw new RuntimeException("Can't parse feature=level string " + input + ": unable to parse " + levelString + " as a short.");
        }
        return new String[]{name, levelString};
    }

    private static void handleUpgradeOrDowngrade(String op, Namespace namespace, Admin admin, FeatureUpdate.UpgradeType upgradeType) throws TerseException {
        String metadata = namespace.getString("metadata");
        List features = namespace.getList("feature");
        String releaseVersion = namespace.getString("release_version");
        if (releaseVersion != null && (metadata != null || features != null)) {
            throw new TerseException("Can not specify `release-version` with other feature flags.");
        }
        HashMap<String, FeatureUpdate> updates = new HashMap<String, FeatureUpdate>();
        if (releaseVersion != null) {
            MetadataVersion metadataVersion;
            try {
                metadataVersion = MetadataVersion.fromVersionString((String)releaseVersion, (boolean)true);
                updates.put(metadataVersion.featureName(), new FeatureUpdate(metadataVersion.featureLevel(), upgradeType));
            }
            catch (Throwable e) {
                throw new TerseException(e.getMessage());
            }
            try {
                for (Feature feature2 : Feature.PRODUCTION_FEATURES) {
                    short featureLevel = feature2.defaultLevel(metadataVersion);
                    if (upgradeType == FeatureUpdate.UpgradeType.UPGRADE && featureLevel <= 0) continue;
                    updates.put(feature2.featureName(), new FeatureUpdate(featureLevel, upgradeType));
                }
            }
            catch (Throwable e) {
                throw new TerseException(upgradeType.name() + " for release version " + releaseVersion + " failed because at least one feature had the following error: " + e.getMessage());
            }
        }
        if (metadata != null) {
            MetadataVersion metadataVersion;
            System.out.println(" `metadata` flag is deprecated and may be removed in a future release.");
            try {
                metadataVersion = MetadataVersion.fromVersionString((String)metadata, (boolean)true);
            }
            catch (Throwable e) {
                throw new TerseException(e.getMessage());
            }
            updates.put("metadata.version", new FeatureUpdate(metadataVersion.featureLevel(), upgradeType));
        }
        if (features != null) {
            features.forEach(feature -> {
                String[] nameAndLevel = FeatureCommand.parseNameAndLevel(feature);
                if (updates.put(nameAndLevel[0], new FeatureUpdate(Short.parseShort(nameAndLevel[1]), upgradeType)) != null) {
                    throw new RuntimeException("Feature " + nameAndLevel[0] + " was specified more than once.");
                }
            });
        }
        FeatureCommand.update(op, admin, updates, namespace.getBoolean("dry_run"));
    }

    static void handleDisable(Namespace namespace, Admin adminClient) throws TerseException {
        FeatureUpdate.UpgradeType upgradeType = FeatureCommand.downgradeType(namespace);
        HashMap<String, FeatureUpdate> updates = new HashMap<String, FeatureUpdate>();
        List features = namespace.getList("feature");
        if (features != null) {
            features.forEach(feature -> {
                if (updates.put((String)feature, new FeatureUpdate(0, upgradeType)) != null) {
                    throw new RuntimeException("Feature " + feature + " was specified more than once.");
                }
            });
        }
        FeatureCommand.update("disable", adminClient, updates, namespace.getBoolean("dry_run"));
    }

    static void handleVersionMapping(Namespace namespace, List<Feature> validFeatures) throws TerseException {
        String releaseVersion = Optional.ofNullable(namespace.getString("release_version")).orElseGet(() -> MetadataVersion.latestProduction().version());
        try {
            MetadataVersion version = MetadataVersion.fromVersionString((String)releaseVersion, (boolean)true);
            short metadataVersionLevel = version.featureLevel();
            System.out.printf("metadata.version=%d (%s)%n", metadataVersionLevel, releaseVersion);
            for (Feature feature : validFeatures) {
                short featureLevel = feature.defaultLevel(version);
                System.out.printf("%s=%d%n", feature.featureName(), featureLevel);
            }
        }
        catch (IllegalArgumentException e) {
            throw new TerseException(e.getMessage());
        }
    }

    static void handleFeatureDependencies(Namespace namespace, List<Feature> validFeatures) throws TerseException {
        List featureArgs = namespace.getList("feature");
        if (featureArgs != null) {
            for (String feature : featureArgs) {
                String[] nameAndLevel = FeatureCommand.parseNameAndLevel(feature);
                String featureName = nameAndLevel[0];
                short featureLevel = Short.parseShort(nameAndLevel[1]);
                if (featureName.equals("metadata.version")) {
                    MetadataVersion metadataVersion;
                    try {
                        metadataVersion = MetadataVersion.fromFeatureLevel((short)featureLevel);
                    }
                    catch (IllegalArgumentException e) {
                        throw new TerseException("Unknown metadata.version " + featureLevel);
                    }
                    System.out.printf("%s=%d (%s) has no dependencies.%n", featureName, featureLevel, metadataVersion.version());
                    continue;
                }
                Feature featureEnum = validFeatures.stream().filter(f -> f.featureName().equals(featureName)).findFirst().orElseThrow(() -> new TerseException("Unknown feature: " + featureName));
                FeatureVersion featureVersion = featureEnum.fromFeatureLevel(featureLevel, true);
                Map dependencies = featureVersion.dependencies();
                if (dependencies.isEmpty()) {
                    System.out.printf("%s=%d has no dependencies.%n", featureName, featureLevel);
                    continue;
                }
                System.out.printf("%s=%d requires:%n", featureName, featureLevel);
                dependencies.forEach((depFeature, depLevel) -> {
                    if (depFeature.equals("metadata.version")) {
                        MetadataVersion depMetadataVersion = MetadataVersion.fromFeatureLevel((short)depLevel);
                        System.out.printf("    %s=%d (%s)%n", depFeature, depLevel, depMetadataVersion.version());
                    } else {
                        System.out.printf("    %s=%d%n", depFeature, depLevel);
                    }
                });
            }
        }
    }

    private static void update(String op, Admin admin, Map<String, FeatureUpdate> updates, Boolean dryRun) throws TerseException {
        if (updates.isEmpty()) {
            throw new TerseException("You must specify at least one feature to " + op);
        }
        UpdateFeaturesResult result = admin.updateFeatures(updates, new UpdateFeaturesOptions().validateOnly(dryRun.booleanValue()));
        TreeMap errors = new TreeMap();
        result.values().forEach((feature, future) -> {
            try {
                future.get();
                errors.put(feature, null);
            }
            catch (ExecutionException e) {
                errors.put(feature, Optional.ofNullable(e.getCause()));
            }
            catch (Throwable t) {
                errors.put(feature, Optional.of(t));
            }
        });
        int numFailures = 0;
        for (Map.Entry feature2 : errors.entrySet()) {
            short level = updates.get(feature2.getKey()).maxVersionLevel();
            Optional maybeThrowable = (Optional)feature2.getValue();
            if (maybeThrowable != null && maybeThrowable.isPresent()) {
                String helper = dryRun != false ? "Can not " : "Could not ";
                String suffix = op.equals("disable") ? "disable " + (String)feature2.getKey() : op + " " + (String)feature2.getKey() + " to " + level;
                System.out.println(helper + suffix + ". " + ((Throwable)maybeThrowable.get()).getMessage());
                ++numFailures;
                continue;
            }
            String verb = dryRun != false ? " can be " : " was ";
            String obj = op.equals("disable") ? "disabled." : op + "d to " + level + ".";
            System.out.println((String)feature2.getKey() + verb + obj);
        }
        if (numFailures > 0) {
            throw new TerseException(numFailures + " out of " + updates.size() + " operation(s) failed.");
        }
    }
}

