/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.TerseException;

public class EndToEndLatency {
    private static final long POLL_TIMEOUT_MS = 60000L;
    private static final short DEFAULT_REPLICATION_FACTOR = 1;
    private static final int DEFAULT_NUM_PARTITIONS = 1;

    public static void main(String ... args) {
        Exit.exit((int)EndToEndLatency.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            EndToEndLatency.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    static void execute(String[] args) throws Exception {
        String[] processedArgs = EndToEndLatency.convertLegacyArgsIfNeeded(args);
        EndToEndLatencyCommandOptions opts = new EndToEndLatencyCommandOptions(processedArgs);
        String brokers = (String)opts.options.valueOf(opts.bootstrapServerOpt);
        String topic = (String)opts.options.valueOf(opts.topicOpt);
        int numRecords = (Integer)opts.options.valueOf(opts.numRecordsOpt);
        String acks = (String)opts.options.valueOf(opts.acksOpt);
        int recordValueSize = (Integer)opts.options.valueOf(opts.recordSizeOpt);
        Optional<String> propertiesFile = Optional.ofNullable((String)opts.options.valueOf(opts.commandConfigOpt));
        int recordKeySize = (Integer)opts.options.valueOf(opts.recordKeySizeOpt);
        int numHeaders = (Integer)opts.options.valueOf(opts.numHeadersOpt);
        int headerKeySize = (Integer)opts.options.valueOf(opts.recordHeaderKeySizeOpt);
        int headerValueSize = (Integer)opts.options.valueOf(opts.recordHeaderValueSizeOpt);
        try (KafkaConsumer<byte[], byte[]> consumer = EndToEndLatency.createKafkaConsumer(propertiesFile, brokers);
             KafkaProducer<byte[], byte[]> producer = EndToEndLatency.createKafkaProducer(propertiesFile, brokers, acks);){
            if (!consumer.listTopics().containsKey(topic)) {
                EndToEndLatency.createTopic(propertiesFile, brokers, topic);
            }
            EndToEndLatency.setupConsumer(topic, consumer);
            double totalTime = 0.0;
            long[] latencies = new long[numRecords];
            Random random = new Random(0L);
            for (int i = 0; i < numRecords; ++i) {
                byte[] recordKey = EndToEndLatency.randomBytesOfLen(random, recordKeySize);
                byte[] recordValue = EndToEndLatency.randomBytesOfLen(random, recordValueSize);
                List<Header> headers = EndToEndLatency.generateHeadersWithSeparateSizes(random, numHeaders, headerKeySize, headerValueSize);
                long begin = System.nanoTime();
                producer.send(new ProducerRecord(topic, null, (Object)recordKey, (Object)recordValue, headers)).get();
                ConsumerRecords records = consumer.poll(Duration.ofMillis(60000L));
                long elapsed = System.nanoTime() - begin;
                EndToEndLatency.validate(consumer, recordValue, (ConsumerRecords<byte[], byte[]>)records, recordKey, headers);
                if (i % 1000 == 0) {
                    System.out.println(i + "\t" + (double)elapsed / 1000.0 / 1000.0);
                }
                totalTime += (double)elapsed;
                latencies[i] = elapsed / 1000L / 1000L;
            }
            EndToEndLatency.printResults(numRecords, totalTime, latencies);
            consumer.commitSync();
        }
    }

    static void validate(KafkaConsumer<byte[], byte[]> consumer, byte[] sentRecordValue, ConsumerRecords<byte[], byte[]> records, byte[] sentRecordKey, Iterable<Header> sentHeaders) {
        if (records.isEmpty()) {
            EndToEndLatency.commitAndThrow(consumer, "poll() timed out before finding a result (timeout:[60000ms])");
        }
        ConsumerRecord record = (ConsumerRecord)records.iterator().next();
        String sent = new String(sentRecordValue, StandardCharsets.UTF_8);
        String read = new String((byte[])record.value(), StandardCharsets.UTF_8);
        if (!read.equals(sent)) {
            EndToEndLatency.commitAndThrow(consumer, "The message value read [" + read + "] did not match the message value sent [" + sent + "]");
        }
        if (sentRecordKey != null) {
            if (record.key() == null) {
                EndToEndLatency.commitAndThrow(consumer, "Expected message key but received null");
            }
            String sentKey = new String(sentRecordKey, StandardCharsets.UTF_8);
            String readKey = new String((byte[])record.key(), StandardCharsets.UTF_8);
            if (!readKey.equals(sentKey)) {
                EndToEndLatency.commitAndThrow(consumer, "The message key read [" + readKey + "] did not match the message key sent [" + sentKey + "]");
            }
        } else if (record.key() != null) {
            EndToEndLatency.commitAndThrow(consumer, "Expected null message key but received [" + new String((byte[])record.key(), StandardCharsets.UTF_8) + "]");
        }
        EndToEndLatency.validateHeaders(consumer, sentHeaders, (ConsumerRecord<byte[], byte[]>)record);
        if (records.count() != 1) {
            int count = records.count();
            EndToEndLatency.commitAndThrow(consumer, "Only one result was expected during this test. We found [" + count + "]");
        }
    }

    private static void commitAndThrow(KafkaConsumer<byte[], byte[]> consumer, String message) {
        consumer.commitSync();
        throw new RuntimeException(message);
    }

    private static void validateHeaders(KafkaConsumer<byte[], byte[]> consumer, Iterable<Header> sentHeaders, ConsumerRecord<byte[], byte[]> record) {
        if (sentHeaders != null && sentHeaders.iterator().hasNext()) {
            if (!record.headers().iterator().hasNext()) {
                EndToEndLatency.commitAndThrow(consumer, "Expected message headers but received none");
            }
            Iterator<Header> sentIterator = sentHeaders.iterator();
            Iterator receivedIterator = record.headers().iterator();
            while (sentIterator.hasNext() && receivedIterator.hasNext()) {
                Header sentHeader = sentIterator.next();
                Header receivedHeader = (Header)receivedIterator.next();
                if (receivedHeader.key().equals(sentHeader.key()) && Arrays.equals(receivedHeader.value(), sentHeader.value())) continue;
                String receivedValueStr = receivedHeader.value() == null ? "null" : Arrays.toString(receivedHeader.value());
                String sentValueStr = sentHeader.value() == null ? "null" : Arrays.toString(sentHeader.value());
                EndToEndLatency.commitAndThrow(consumer, "The message header read [" + receivedHeader.key() + ":" + receivedValueStr + "] did not match the message header sent [" + sentHeader.key() + ":" + sentValueStr + "]");
            }
            if (sentIterator.hasNext() || receivedIterator.hasNext()) {
                EndToEndLatency.commitAndThrow(consumer, "Header count mismatch between sent and received messages");
            }
        }
    }

    private static List<Header> generateHeadersWithSeparateSizes(Random random, int numHeaders, int keySize, int valueSize) {
        ArrayList<Header> headers = new ArrayList<Header>();
        for (int i = 0; i < numHeaders; ++i) {
            final String headerKey = new String(EndToEndLatency.randomBytesOfLen(random, keySize), StandardCharsets.UTF_8);
            final byte[] headerValue = valueSize == -1 ? null : EndToEndLatency.randomBytesOfLen(random, valueSize);
            headers.add(new Header(){

                public String key() {
                    return headerKey;
                }

                public byte[] value() {
                    return headerValue;
                }
            });
        }
        return headers;
    }

    private static void setupConsumer(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        List topicPartitions = consumer.partitionsFor(topic).stream().map(p -> new TopicPartition(p.topic(), p.partition())).collect(Collectors.toList());
        consumer.assign(topicPartitions);
        consumer.seekToEnd(topicPartitions);
        consumer.assignment().forEach(arg_0 -> consumer.position(arg_0));
    }

    private static void printResults(int numRecords, double totalTime, long[] latencies) {
        System.out.printf("Avg latency: %.4f ms%n", totalTime / (double)numRecords / 1000.0 / 1000.0);
        Arrays.sort(latencies);
        int p50 = (int)latencies[(int)((double)latencies.length * 0.5)];
        int p99 = (int)latencies[(int)((double)latencies.length * 0.99)];
        int p999 = (int)latencies[(int)((double)latencies.length * 0.999)];
        System.out.printf("Percentiles: 50th = %d, 99th = %d, 99.9th = %d%n", p50, p99, p999);
    }

    private static byte[] randomBytesOfLen(Random random, int length) {
        byte[] randomBytes = new byte[length];
        Arrays.fill(randomBytes, Integer.valueOf(random.nextInt(26) + 65).byteValue());
        return randomBytes;
    }

    private static void createTopic(Optional<String> propertiesFile, String brokers, String topic) throws IOException {
        System.out.printf("Topic \"%s\" does not exist. Will create topic with %d partition(s) and replication factor = %d%n", topic, 1, (short)1);
        Properties adminProps = EndToEndLatency.loadPropsWithBootstrapServers(propertiesFile, brokers);
        Admin adminClient = Admin.create((Properties)adminProps);
        NewTopic newTopic = new NewTopic(topic, 1, 1);
        try {
            adminClient.createTopics(Set.of(newTopic)).all().get();
        }
        catch (InterruptedException | ExecutionException e) {
            System.out.printf("Creation of topic %s failed%n", topic);
            throw new RuntimeException(e);
        }
        finally {
            Utils.closeQuietly((AutoCloseable)adminClient, (String)"AdminClient");
        }
    }

    private static Properties loadPropsWithBootstrapServers(Optional<String> propertiesFile, String brokers) throws IOException {
        Properties properties = propertiesFile.isPresent() ? Utils.loadProps((String)propertiesFile.get()) : new Properties();
        properties.put("bootstrap.servers", brokers);
        return properties;
    }

    private static KafkaConsumer<byte[], byte[]> createKafkaConsumer(Optional<String> propsFile, String brokers) throws IOException {
        Properties consumerProps = EndToEndLatency.loadPropsWithBootstrapServers(propsFile, brokers);
        consumerProps.put("group.id", "test-group-" + System.currentTimeMillis());
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("auto.offset.reset", "latest");
        consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        consumerProps.put("fetch.max.wait.ms", "0");
        return new KafkaConsumer(consumerProps);
    }

    private static KafkaProducer<byte[], byte[]> createKafkaProducer(Optional<String> propsFile, String brokers, String acks) throws IOException {
        Properties producerProps = EndToEndLatency.loadPropsWithBootstrapServers(propsFile, brokers);
        producerProps.put("linger.ms", "0");
        producerProps.put("max.block.ms", (Object)Long.MAX_VALUE);
        producerProps.put("acks", acks);
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        return new KafkaProducer(producerProps);
    }

    @Deprecated(since="4.2", forRemoval=true)
    static String[] convertLegacyArgsIfNeeded(String[] args) throws Exception {
        if (args.length == 0) {
            return args;
        }
        boolean hasRequiredNamedArgs = Arrays.stream(args).anyMatch(arg -> arg.equals("--bootstrap-server") || arg.equals("--topic") || arg.equals("--num-records") || arg.equals("--producer-acks") || arg.equals("--record-size"));
        if (hasRequiredNamedArgs) {
            return args;
        }
        if (args.length != 5 && args.length != 6) {
            throw new TerseException("Invalid number of arguments. Expected 5 or 6 positional arguments, but got " + args.length + ". Usage: bootstrap-server topic num-records producer-acks record-size [optional] command-config");
        }
        return EndToEndLatency.convertLegacyArgs(args);
    }

    private static String[] convertLegacyArgs(String[] legacyArgs) {
        ArrayList<String> newArgs = new ArrayList<String>();
        newArgs.add("--bootstrap-server");
        newArgs.add(legacyArgs[0]);
        newArgs.add("--topic");
        newArgs.add(legacyArgs[1]);
        newArgs.add("--num-records");
        newArgs.add(legacyArgs[2]);
        newArgs.add("--producer-acks");
        newArgs.add(legacyArgs[3]);
        newArgs.add("--record-size");
        newArgs.add(legacyArgs[4]);
        if (legacyArgs.length == 6) {
            newArgs.add("--command-config");
            newArgs.add(legacyArgs[5]);
        }
        System.out.println("WARNING: Positional argument usage is deprecated and will be removed in Apache Kafka 5.0. Please use named arguments instead: --bootstrap-server, --topic, --num-records, --producer-acks, --record-size, --command-config");
        return newArgs.toArray(new String[0]);
    }

    public static final class EndToEndLatencyCommandOptions
    extends CommandDefaultOptions {
        final OptionSpec<String> bootstrapServerOpt;
        final OptionSpec<String> topicOpt;
        final OptionSpec<Integer> numRecordsOpt;
        final OptionSpec<String> acksOpt;
        final OptionSpec<Integer> recordSizeOpt;
        final OptionSpec<String> commandConfigOpt;
        final OptionSpec<Integer> recordKeySizeOpt;
        final OptionSpec<Integer> recordHeaderValueSizeOpt;
        final OptionSpec<Integer> recordHeaderKeySizeOpt;
        final OptionSpec<Integer> numHeadersOpt;

        public EndToEndLatencyCommandOptions(String[] args) {
            super(args);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED: The Kafka broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("bootstrap-server").ofType(String.class);
            this.topicOpt = this.parser.accepts("topic", "REQUIRED: The topic to use for the test.").withRequiredArg().describedAs("topic-name").ofType(String.class);
            this.numRecordsOpt = this.parser.accepts("num-records", "REQUIRED: The number of messages to send.").withRequiredArg().describedAs("count").ofType(Integer.class);
            this.acksOpt = this.parser.accepts("producer-acks", "REQUIRED: Producer acknowledgements. Must be '1' or 'all'.").withRequiredArg().describedAs("producer-acks").ofType(String.class);
            this.recordSizeOpt = this.parser.accepts("record-size", "REQUIRED: The size of each message payload in bytes.").withRequiredArg().describedAs("bytes").ofType(Integer.class);
            this.recordKeySizeOpt = this.parser.accepts("record-key-size", "Optional: The size of the message key in bytes. If not set, messages are sent without a key.").withOptionalArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
            this.recordHeaderKeySizeOpt = this.parser.accepts("record-header-key-size", "Optional: The size of the message header key in bytes. Used together with record-header-size.").withOptionalArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
            this.recordHeaderValueSizeOpt = this.parser.accepts("record-header-size", "Optional: The size of message header value in bytes. Use -1 for null header value.").withOptionalArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
            this.numHeadersOpt = this.parser.accepts("num-headers", "Optional: The number of headers to include in each message.").withOptionalArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
            this.commandConfigOpt = this.parser.accepts("command-config", "Optional: A property file for Kafka producer/consumer/admin client configuration.").withOptionalArg().describedAs("config-file").ofType(String.class);
            try {
                this.options = this.parser.parse(args);
            }
            catch (OptionException e) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)e.getMessage());
            }
            this.checkArgs();
        }

        void checkArgs() {
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool measures end-to-end latency in Kafka by sending messages and timing their reception.");
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt, this.topicOpt, this.numRecordsOpt, this.acksOpt, this.recordSizeOpt});
            String acksValue = (String)this.options.valueOf(this.acksOpt);
            if (!List.of("1", "all").contains(acksValue)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Invalid value for --producer-acks. Latency testing requires synchronous acknowledgement. Please use '1' or 'all'.");
            }
            if ((Integer)this.options.valueOf(this.numRecordsOpt) <= 0) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Value for --num-records must be a positive integer.");
            }
            if ((Integer)this.options.valueOf(this.recordSizeOpt) < 0) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Value for --record-size must be a non-negative integer.");
            }
            if ((Integer)this.options.valueOf(this.recordKeySizeOpt) < 0) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Value for --record-key-size must be a non-negative integer.");
            }
            if ((Integer)this.options.valueOf(this.recordHeaderKeySizeOpt) < 0) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Value for --record-header-key-size must be a non-negative integer.");
            }
            if ((Integer)this.options.valueOf(this.recordHeaderValueSizeOpt) < -1) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Value for --record-header-size must be a non-negative integer or -1 for null header value.");
            }
            if ((Integer)this.options.valueOf(this.numHeadersOpt) < 0) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Value for --num-headers must be a non-negative integer.");
            }
        }
    }
}

