/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.errors.internals;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.errors.ErrorHandlerContext;

public class ExceptionHandlerUtils {
    public static final String HEADER_ERRORS_EXCEPTION_NAME = "__streams.errors.exception";
    public static final String HEADER_ERRORS_STACKTRACE_NAME = "__streams.errors.stacktrace";
    public static final String HEADER_ERRORS_EXCEPTION_MESSAGE_NAME = "__streams.errors.message";
    public static final String HEADER_ERRORS_TOPIC_NAME = "__streams.errors.topic";
    public static final String HEADER_ERRORS_PARTITION_NAME = "__streams.errors.partition";
    public static final String HEADER_ERRORS_OFFSET_NAME = "__streams.errors.offset";

    public static boolean shouldBuildDeadLetterQueueRecord(String deadLetterQueueTopicName) {
        return deadLetterQueueTopicName != null;
    }

    public static List<ProducerRecord<byte[], byte[]>> maybeBuildDeadLetterQueueRecords(String deadLetterQueueTopicName, byte[] key, byte[] value, ErrorHandlerContext context, Exception exception) {
        if (!ExceptionHandlerUtils.shouldBuildDeadLetterQueueRecord(deadLetterQueueTopicName)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ExceptionHandlerUtils.buildDeadLetterQueueRecord(deadLetterQueueTopicName, key, value, context, exception));
    }

    public static ProducerRecord<byte[], byte[]> buildDeadLetterQueueRecord(String deadLetterQueueTopicName, byte[] key, byte[] value, ErrorHandlerContext context, Exception e) {
        if (deadLetterQueueTopicName == null) {
            throw new InvalidConfigurationException(String.format("%s cannot be null while building dead letter queue record", "errors.dead.letter.queue.topic.name"));
        }
        ProducerRecord producerRecord = new ProducerRecord(deadLetterQueueTopicName, null, Long.valueOf(context.timestamp()), (Object)key, (Object)value);
        if (context.headers() != null) {
            for (Header header : context.headers()) {
                producerRecord.headers().add(header);
            }
        }
        StringWriter stackTraceStringWriter = new StringWriter();
        PrintWriter stackTracePrintWriter = new PrintWriter(stackTraceStringWriter);
        e.printStackTrace(stackTracePrintWriter);
        try (StringSerializer stringSerializer = new StringSerializer();){
            producerRecord.headers().add(HEADER_ERRORS_EXCEPTION_NAME, stringSerializer.serialize(null, e.getClass().getName()));
            producerRecord.headers().add(HEADER_ERRORS_EXCEPTION_MESSAGE_NAME, stringSerializer.serialize(null, e.getMessage()));
            producerRecord.headers().add(HEADER_ERRORS_STACKTRACE_NAME, stringSerializer.serialize(null, stackTraceStringWriter.toString()));
            producerRecord.headers().add(HEADER_ERRORS_TOPIC_NAME, stringSerializer.serialize(null, context.topic()));
            producerRecord.headers().add(HEADER_ERRORS_PARTITION_NAME, stringSerializer.serialize(null, String.valueOf(context.partition())));
            producerRecord.headers().add(HEADER_ERRORS_OFFSET_NAME, stringSerializer.serialize(null, String.valueOf(context.offset())));
        }
        return producerRecord;
    }
}

