/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.kafka.clients.consumer.internals.ShareInFlightBatchException;
import org.apache.kafka.common.TopicIdPartition;

public class ShareInFlightBatch<K, V> {
    private final int nodeId;
    private final TopicIdPartition partition;
    private final Map<Long, ConsumerRecord<K, V>> inFlightRecords;
    private Map<Long, ConsumerRecord<K, V>> renewingRecords;
    private Map<Long, ConsumerRecord<K, V>> renewedRecords;
    private final Set<Long> acknowledgedRecords;
    private Acknowledgements acknowledgements;
    private final Optional<Integer> acquisitionLockTimeoutMs;
    private ShareInFlightBatchException exception;
    private boolean hasCachedException = false;
    private boolean checkForRenewAcknowledgements = false;

    public ShareInFlightBatch(int nodeId, TopicIdPartition partition, Optional<Integer> acquisitionLockTimeoutMs) {
        this.nodeId = nodeId;
        this.partition = partition;
        this.inFlightRecords = new TreeMap<Long, ConsumerRecord<K, V>>();
        this.acknowledgedRecords = new TreeSet<Long>();
        this.acknowledgements = Acknowledgements.empty();
        this.acquisitionLockTimeoutMs = acquisitionLockTimeoutMs;
    }

    public void addAcknowledgement(long offset, AcknowledgeType type) {
        this.acknowledgements.add(offset, type);
        if (type == AcknowledgeType.RENEW) {
            this.checkForRenewAcknowledgements = true;
        }
    }

    public void acknowledge(ConsumerRecord<K, V> record, AcknowledgeType type) {
        if (this.inFlightRecords.get(record.offset()) != null) {
            this.acknowledgements.add(record.offset(), type);
            this.acknowledgedRecords.add(record.offset());
            if (type == AcknowledgeType.RENEW) {
                this.checkForRenewAcknowledgements = true;
            }
            return;
        }
        throw new IllegalStateException("The record cannot be acknowledged.");
    }

    public void acknowledgeAll(AcknowledgeType type) {
        for (Map.Entry<Long, ConsumerRecord<K, V>> entry : this.inFlightRecords.entrySet()) {
            if (!this.acknowledgements.addIfAbsent(entry.getKey(), type)) continue;
            this.acknowledgedRecords.add(entry.getKey());
        }
        if (type == AcknowledgeType.RENEW) {
            this.checkForRenewAcknowledgements = true;
        }
    }

    public boolean checkAllInFlightAreAcknowledged() {
        return this.inFlightRecords.size() == this.acknowledgedRecords.size();
    }

    public void addRecord(ConsumerRecord<K, V> record) {
        this.inFlightRecords.put(record.offset(), record);
    }

    public void addGap(long offset) {
        this.acknowledgements.addGap(offset);
    }

    public void merge(ShareInFlightBatch<K, V> other) {
        this.inFlightRecords.putAll(other.inFlightRecords);
        if (other.checkForRenewAcknowledgements) {
            this.checkForRenewAcknowledgements = true;
        }
    }

    List<ConsumerRecord<K, V>> getInFlightRecords() {
        return new ArrayList<ConsumerRecord<K, V>>(this.inFlightRecords.values());
    }

    int numRecords() {
        return this.inFlightRecords.size();
    }

    int nodeId() {
        return this.nodeId;
    }

    Acknowledgements takeAcknowledgedRecords() {
        if (this.checkForRenewAcknowledgements) {
            if (this.renewingRecords == null) {
                this.renewingRecords = new HashMap<Long, ConsumerRecord<K, V>>();
            }
            if (this.renewedRecords == null) {
                this.renewedRecords = new HashMap<Long, ConsumerRecord<K, V>>();
            }
            Map<Long, AcknowledgeType> ackTypeMap = this.acknowledgements.getAcknowledgementsTypeMap();
            this.acknowledgedRecords.forEach(offset -> {
                if (ackTypeMap.get(offset) == AcknowledgeType.RENEW) {
                    this.renewingRecords.put((Long)offset, (ConsumerRecord<Long, ConsumerRecord<K, V>>)this.inFlightRecords.get(offset));
                }
            });
        }
        if (this.acknowledgedRecords.size() == this.inFlightRecords.size()) {
            this.inFlightRecords.clear();
        } else {
            this.acknowledgedRecords.forEach(this.inFlightRecords::remove);
        }
        this.acknowledgedRecords.clear();
        this.exception = null;
        Acknowledgements currentAcknowledgements = this.acknowledgements;
        this.acknowledgements = Acknowledgements.empty();
        this.checkForRenewAcknowledgements = false;
        return currentAcknowledgements;
    }

    int renew(Acknowledgements acknowledgements) {
        int recordsRenewed = 0;
        boolean isCompletedExceptionally = acknowledgements.isCompletedExceptionally();
        if (acknowledgements.isCompleted()) {
            if (this.renewingRecords != null) {
                Map<Long, AcknowledgeType> ackTypeMap = acknowledgements.getAcknowledgementsTypeMap();
                for (Map.Entry<Long, AcknowledgeType> ackTypeEntry : ackTypeMap.entrySet()) {
                    long offset = ackTypeEntry.getKey();
                    AcknowledgeType ackType = ackTypeEntry.getValue();
                    ConsumerRecord<K, V> record = this.renewingRecords.remove(offset);
                    if (ackType != AcknowledgeType.RENEW || record == null || isCompletedExceptionally) continue;
                    this.renewedRecords.put(offset, record);
                    ++recordsRenewed;
                }
            }
        } else {
            throw new IllegalStateException("Renewing with uncompleted acknowledgements");
        }
        return recordsRenewed;
    }

    boolean hasRenewals() {
        if (this.renewingRecords == null) {
            return false;
        }
        return !this.renewingRecords.isEmpty() || !this.renewedRecords.isEmpty();
    }

    void takeRenewals() {
        if (this.renewedRecords != null) {
            this.inFlightRecords.putAll(this.renewedRecords);
            this.renewedRecords.clear();
        }
    }

    Acknowledgements getAcknowledgements() {
        return this.acknowledgements;
    }

    Optional<Integer> getAcquisitionLockTimeoutMs() {
        return this.acquisitionLockTimeoutMs;
    }

    public boolean isEmpty() {
        return this.inFlightRecords.isEmpty() && this.acknowledgements.isEmpty();
    }

    public void setException(ShareInFlightBatchException exception) {
        this.exception = exception;
    }

    public ShareInFlightBatchException getException() {
        return this.exception;
    }

    public void setHasCachedException(boolean hasCachedException) {
        this.hasCachedException = hasCachedException;
    }

    public boolean hasCachedException() {
        return this.hasCachedException;
    }
}

