/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.FencedMemberEpochException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.InconsistentGroupProtocolException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedAssignorException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.ConsumerGroupMigrationPolicy;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.ShareGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.assignor.SimpleAssignor;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.ModernGroup;
import org.apache.kafka.coordinator.group.modern.TargetAssignmentBuilder;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.CurrentAssignmentBuilder;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupAssignmentBuilder;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.apache.kafka.coordinator.group.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.group.runtime.CoordinatorTimer;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineHashSet;
import org.slf4j.Logger;

public class GroupMetadataManager {
    private final LogContext logContext;
    private final Logger log;
    private final SnapshotRegistry snapshotRegistry;
    private final Time time;
    private final CoordinatorTimer<Void, CoordinatorRecord> timer;
    private final GroupCoordinatorMetricsShard metrics;
    private final Map<String, ConsumerGroupPartitionAssignor> consumerGroupAssignors;
    private final ConsumerGroupPartitionAssignor defaultConsumerGroupAssignor;
    private final TimelineHashMap<String, Group> groups;
    private final TimelineHashMap<String, TimelineHashSet<String>> groupsByTopics;
    private final int consumerGroupMaxSize;
    private final int consumerGroupHeartbeatIntervalMs;
    private final int consumerGroupSessionTimeoutMs;
    private final int consumerGroupMetadataRefreshIntervalMs;
    private MetadataImage metadataImage;
    static final CoordinatorResult<Void, CoordinatorRecord> EMPTY_RESULT = new CoordinatorResult(Collections.emptyList(), CompletableFuture.completedFuture(null), false);
    private final int classicGroupMaxSize;
    private final int classicGroupInitialRebalanceDelayMs;
    private final int classicGroupNewMemberJoinTimeoutMs;
    private final int classicGroupMinSessionTimeoutMs;
    private final int classicGroupMaxSessionTimeoutMs;
    private final ShareGroupPartitionAssignor shareGroupAssignor;
    private final int shareGroupMaxSize;
    private final int shareGroupHeartbeatIntervalMs;
    private final int shareGroupSessionTimeoutMs;
    private final int shareGroupMetadataRefreshIntervalMs;
    private final ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy;

    private GroupMetadataManager(SnapshotRegistry snapshotRegistry, LogContext logContext, Time time, CoordinatorTimer<Void, CoordinatorRecord> timer, GroupCoordinatorMetricsShard metrics, List<ConsumerGroupPartitionAssignor> consumerGroupAssignors, MetadataImage metadataImage, int consumerGroupMaxSize, int consumerGroupSessionTimeoutMs, int consumerGroupHeartbeatIntervalMs, int consumerGroupMetadataRefreshIntervalMs, int classicGroupMaxSize, int classicGroupInitialRebalanceDelayMs, int classicGroupNewMemberJoinTimeoutMs, int classicGroupMinSessionTimeoutMs, int classicGroupMaxSessionTimeoutMs, ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy, ShareGroupPartitionAssignor shareGroupAssignor, int shareGroupMaxSize, int shareGroupSessionTimeoutMs, int shareGroupHeartbeatIntervalMs, int shareGroupMetadataRefreshIntervalMs) {
        this.logContext = logContext;
        this.log = logContext.logger(GroupMetadataManager.class);
        this.snapshotRegistry = snapshotRegistry;
        this.time = time;
        this.timer = timer;
        this.metrics = metrics;
        this.metadataImage = metadataImage;
        this.consumerGroupAssignors = consumerGroupAssignors.stream().collect(Collectors.toMap(PartitionAssignor::name, Function.identity()));
        this.defaultConsumerGroupAssignor = consumerGroupAssignors.get(0);
        this.groups = new TimelineHashMap(snapshotRegistry, 0);
        this.groupsByTopics = new TimelineHashMap(snapshotRegistry, 0);
        this.consumerGroupMaxSize = consumerGroupMaxSize;
        this.consumerGroupSessionTimeoutMs = consumerGroupSessionTimeoutMs;
        this.consumerGroupHeartbeatIntervalMs = consumerGroupHeartbeatIntervalMs;
        this.consumerGroupMetadataRefreshIntervalMs = consumerGroupMetadataRefreshIntervalMs;
        this.classicGroupMaxSize = classicGroupMaxSize;
        this.classicGroupInitialRebalanceDelayMs = classicGroupInitialRebalanceDelayMs;
        this.classicGroupNewMemberJoinTimeoutMs = classicGroupNewMemberJoinTimeoutMs;
        this.classicGroupMinSessionTimeoutMs = classicGroupMinSessionTimeoutMs;
        this.classicGroupMaxSessionTimeoutMs = classicGroupMaxSessionTimeoutMs;
        this.consumerGroupMigrationPolicy = consumerGroupMigrationPolicy;
        this.shareGroupAssignor = shareGroupAssignor;
        this.shareGroupMaxSize = shareGroupMaxSize;
        this.shareGroupSessionTimeoutMs = shareGroupSessionTimeoutMs;
        this.shareGroupHeartbeatIntervalMs = shareGroupHeartbeatIntervalMs;
        this.shareGroupMetadataRefreshIntervalMs = shareGroupMetadataRefreshIntervalMs;
    }

    public MetadataImage image() {
        return this.metadataImage;
    }

    public Group group(String groupId) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId, Long.MAX_VALUE);
        if (group == null) {
            throw new GroupIdNotFoundException(String.format("Group %s not found.", groupId));
        }
        return group;
    }

    public Group group(String groupId, long committedOffset) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId, committedOffset);
        if (group == null) {
            throw new GroupIdNotFoundException(String.format("Group %s not found.", groupId));
        }
        return group;
    }

    public List<ListGroupsResponseData.ListedGroup> listGroups(Set<String> statesFilter, Set<String> typesFilter, long committedOffset) {
        Set caseInsensitiveFilterSet = statesFilter.stream().map(String::toLowerCase).map(String::trim).collect(Collectors.toSet());
        Set enumTypesFilter = typesFilter.stream().map(Group.GroupType::parse).collect(Collectors.toSet());
        Predicate<Group> combinedFilter = group -> {
            boolean stateCheck = statesFilter.isEmpty() || group.isInStates(caseInsensitiveFilterSet, committedOffset);
            boolean typeCheck = enumTypesFilter.isEmpty() || enumTypesFilter.contains((Object)group.type());
            return stateCheck && typeCheck;
        };
        Stream groupStream = this.groups.values(committedOffset).stream();
        return groupStream.filter(combinedFilter).map(group -> group.asListedGroup(committedOffset)).collect(Collectors.toList());
    }

    public List<ConsumerGroupDescribeResponseData.DescribedGroup> consumerGroupDescribe(List<String> groupIds, long committedOffset) {
        ArrayList<ConsumerGroupDescribeResponseData.DescribedGroup> describedGroups = new ArrayList<ConsumerGroupDescribeResponseData.DescribedGroup>();
        groupIds.forEach(groupId -> {
            try {
                describedGroups.add(this.consumerGroup((String)groupId, committedOffset).asDescribedGroup(committedOffset, this.defaultConsumerGroupAssignor.name(), this.metadataImage.topics()));
            }
            catch (GroupIdNotFoundException exception) {
                describedGroups.add(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()));
            }
        });
        return describedGroups;
    }

    public List<DescribeGroupsResponseData.DescribedGroup> describeGroups(List<String> groupIds, long committedOffset) {
        ArrayList<DescribeGroupsResponseData.DescribedGroup> describedGroups = new ArrayList<DescribeGroupsResponseData.DescribedGroup>();
        groupIds.forEach(groupId -> {
            try {
                ClassicGroup group = this.classicGroup((String)groupId, committedOffset);
                if (group.isInState(ClassicGroupState.STABLE)) {
                    if (!group.protocolName().isPresent()) {
                        throw new IllegalStateException("Invalid null group protocol for stable group");
                    }
                    describedGroups.add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState(group.stateAsString()).setProtocolType(group.protocolType().orElse("")).setProtocolData(group.protocolName().get()).setMembers(group.allMembers().stream().map(member -> member.describe(group.protocolName().get())).collect(Collectors.toList())));
                } else {
                    describedGroups.add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState(group.stateAsString()).setProtocolType(group.protocolType().orElse("")).setMembers(group.allMembers().stream().map(member -> member.describeNoMetadata()).collect(Collectors.toList())));
                }
            }
            catch (GroupIdNotFoundException exception) {
                describedGroups.add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState(ClassicGroupState.DEAD.toString()));
            }
        });
        return describedGroups;
    }

    ConsumerGroup getOrMaybeCreateConsumerGroup(String groupId, boolean createIfNotExists, List<CoordinatorRecord> records) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group == null && !createIfNotExists) {
            throw new GroupIdNotFoundException(String.format("Consumer group %s not found.", groupId));
        }
        if (group == null || createIfNotExists && this.maybeDeleteEmptyClassicGroup(group, records)) {
            return new ConsumerGroup(this.snapshotRegistry, groupId, this.metrics);
        }
        if (group.type() == Group.GroupType.CONSUMER) {
            return (ConsumerGroup)group;
        }
        if (createIfNotExists && this.validateOnlineUpgrade((ClassicGroup)group)) {
            return this.convertToConsumerGroup((ClassicGroup)group, records);
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a consumer group.", groupId));
    }

    public ConsumerGroup consumerGroup(String groupId, long committedOffset) throws GroupIdNotFoundException {
        Group group = this.group(groupId, committedOffset);
        if (group.type() == Group.GroupType.CONSUMER) {
            return (ConsumerGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a consumer group.", groupId));
    }

    ConsumerGroup consumerGroup(String groupId) throws GroupIdNotFoundException {
        return this.consumerGroup(groupId, Long.MAX_VALUE);
    }

    ConsumerGroup getOrMaybeCreatePersistedConsumerGroup(String groupId, boolean createIfNotExists) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group == null && !createIfNotExists) {
            throw new IllegalStateException(String.format("Consumer group %s not found.", groupId));
        }
        if (group == null) {
            ConsumerGroup consumerGroup = new ConsumerGroup(this.snapshotRegistry, groupId, this.metrics);
            this.groups.put((Object)groupId, (Object)consumerGroup);
            this.metrics.onConsumerGroupStateTransition(null, consumerGroup.state());
            return consumerGroup;
        }
        if (group.type() == Group.GroupType.CONSUMER) {
            return (ConsumerGroup)group;
        }
        throw new IllegalStateException(String.format("Group %s is not a consumer group.", groupId));
    }

    ClassicGroup getOrMaybeCreateClassicGroup(String groupId, boolean createIfNotExists) throws UnknownMemberIdException, GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group == null && !createIfNotExists) {
            throw new UnknownMemberIdException(String.format("Classic group %s not found.", groupId));
        }
        if (group == null) {
            ClassicGroup classicGroup = new ClassicGroup(this.logContext, groupId, ClassicGroupState.EMPTY, this.time, this.metrics);
            this.groups.put((Object)groupId, (Object)classicGroup);
            this.metrics.onClassicGroupStateTransition(null, classicGroup.currentState());
            return classicGroup;
        }
        if (group.type() == Group.GroupType.CLASSIC) {
            return (ClassicGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a classic group.", groupId));
    }

    public ClassicGroup classicGroup(String groupId, long committedOffset) throws GroupIdNotFoundException {
        Group group = this.group(groupId, committedOffset);
        if (group.type() == Group.GroupType.CLASSIC) {
            return (ClassicGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a classic group.", groupId));
    }

    private ShareGroup getOrMaybeCreateShareGroup(String groupId, boolean createIfNotExists) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group == null && !createIfNotExists) {
            throw new GroupIdNotFoundException(String.format("Share group %s not found.", groupId));
        }
        if (group == null) {
            return new ShareGroup(this.snapshotRegistry, groupId);
        }
        if (group.type() != Group.GroupType.SHARE) {
            throw new GroupIdNotFoundException(String.format("Group %s is not a share group.", groupId));
        }
        return (ShareGroup)group;
    }

    ShareGroup getOrMaybeCreatePersistedShareGroup(String groupId, boolean createIfNotExists) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group == null && !createIfNotExists) {
            throw new IllegalStateException(String.format("Share group %s not found.", groupId));
        }
        if (group == null) {
            ShareGroup shareGroup = new ShareGroup(this.snapshotRegistry, groupId);
            this.groups.put((Object)groupId, (Object)shareGroup);
            return shareGroup;
        }
        if (group.type() != Group.GroupType.SHARE) {
            throw new GroupIdNotFoundException(String.format("Group %s is not a share group.", groupId));
        }
        return (ShareGroup)group;
    }

    public ShareGroup shareGroup(String groupId, long committedOffset) throws GroupIdNotFoundException {
        Group group = this.group(groupId, committedOffset);
        if (group.type() == Group.GroupType.SHARE) {
            return (ShareGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a share group.", groupId));
    }

    ShareGroup shareGroup(String groupId) throws GroupIdNotFoundException {
        return this.shareGroup(groupId, Long.MAX_VALUE);
    }

    ModernGroup<?> getOrMaybeCreatePersistedGroup(String groupId, boolean createIfNotExists, Group.GroupType groupType) throws GroupIdNotFoundException {
        if (groupType == Group.GroupType.CONSUMER) {
            return this.getOrMaybeCreatePersistedConsumerGroup(groupId, createIfNotExists);
        }
        if (groupType == Group.GroupType.SHARE) {
            return this.getOrMaybeCreatePersistedShareGroup(groupId, createIfNotExists);
        }
        throw new IllegalArgumentException("Invalid group type: " + (Object)((Object)groupType));
    }

    private boolean validateOnlineDowngrade(ConsumerGroup consumerGroup, String memberId) {
        if (!consumerGroup.allMembersUseClassicProtocolExcept(memberId)) {
            return false;
        }
        if (consumerGroup.numMembers() <= 1) {
            this.log.debug("Skip downgrading the consumer group {} to classic group because it's empty.", (Object)consumerGroup.groupId());
            return false;
        }
        if (!this.consumerGroupMigrationPolicy.isDowngradeEnabled()) {
            this.log.info("Cannot downgrade consumer group {} to classic group because the online downgrade is disabled.", (Object)consumerGroup.groupId());
            return false;
        }
        if (consumerGroup.numMembers() - 1 > this.classicGroupMaxSize) {
            this.log.info("Cannot downgrade consumer group {} to classic group because its group size is greater than classic group max size.", (Object)consumerGroup.groupId());
            return false;
        }
        return true;
    }

    private <T> CoordinatorResult<T, CoordinatorRecord> convertToClassicGroup(ConsumerGroup consumerGroup, String leavingMemberId, T response) {
        ClassicGroup classicGroup;
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        consumerGroup.createGroupTombstoneRecords(records);
        try {
            classicGroup = ClassicGroup.fromConsumerGroup(consumerGroup, leavingMemberId, this.logContext, this.time, this.metrics, this.metadataImage);
        }
        catch (SchemaException e) {
            this.log.warn("Cannot downgrade the consumer group " + consumerGroup.groupId() + ": fail to parse the Consumer Protocol " + "consumer" + ".", (Throwable)e);
            throw new GroupIdNotFoundException(String.format("Cannot downgrade the classic group %s: %s.", consumerGroup.groupId(), e.getMessage()));
        }
        classicGroup.createClassicGroupRecords(this.metadataImage.features().metadataVersion(), records);
        this.removeGroup(consumerGroup.groupId());
        this.groups.put((Object)consumerGroup.groupId(), (Object)classicGroup);
        this.metrics.onClassicGroupStateTransition(null, classicGroup.currentState());
        classicGroup.allMembers().forEach(member -> this.rescheduleClassicGroupMemberHeartbeat(classicGroup, (ClassicGroupMember)member));
        this.prepareRebalance(classicGroup, String.format("Downgrade group %s from consumer to classic.", classicGroup.groupId()));
        CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
        appendFuture.exceptionally(__ -> {
            this.metrics.onClassicGroupStateTransition(classicGroup.currentState(), null);
            return null;
        });
        return new CoordinatorResult<T, CoordinatorRecord>(records, response, appendFuture, false);
    }

    private boolean validateOnlineUpgrade(ClassicGroup classicGroup) {
        if (!this.consumerGroupMigrationPolicy.isUpgradeEnabled()) {
            this.log.info("Cannot upgrade classic group {} to consumer group because the online upgrade is disabled.", (Object)classicGroup.groupId());
            return false;
        }
        if (!classicGroup.usesConsumerGroupProtocol()) {
            this.log.info("Cannot upgrade classic group {} to consumer group because the group does not use the consumer embedded protocol.", (Object)classicGroup.groupId());
            return false;
        }
        if (classicGroup.numMembers() > this.consumerGroupMaxSize) {
            this.log.info("Cannot upgrade classic group {} to consumer group because the group size exceeds the consumer group maximum size.", (Object)classicGroup.groupId());
            return false;
        }
        return true;
    }

    ConsumerGroup convertToConsumerGroup(ClassicGroup classicGroup, List<CoordinatorRecord> records) {
        ConsumerGroup consumerGroup;
        classicGroup.completeAllJoinFutures(Errors.REBALANCE_IN_PROGRESS);
        classicGroup.completeAllSyncFutures(Errors.REBALANCE_IN_PROGRESS);
        classicGroup.createGroupTombstoneRecords(records);
        try {
            consumerGroup = ConsumerGroup.fromClassicGroup(this.snapshotRegistry, this.metrics, classicGroup, this.metadataImage.topics());
        }
        catch (SchemaException e) {
            this.log.warn("Cannot upgrade the classic group " + classicGroup.groupId() + " to consumer group because the embedded consumer protocol is malformed: " + e.getMessage() + ".", (Throwable)e);
            throw new GroupIdNotFoundException("Cannot upgrade the classic group " + classicGroup.groupId() + " to consumer group because the embedded consumer protocol is malformed.");
        }
        consumerGroup.createConsumerGroupRecords(records);
        consumerGroup.members().forEach((memberId, member) -> this.scheduleConsumerGroupSessionTimeout(consumerGroup.groupId(), (String)memberId, member.classicProtocolSessionTimeout().get()));
        return consumerGroup;
    }

    private void removeGroup(String groupId) {
        Group group = (Group)this.groups.remove((Object)groupId);
        if (group != null) {
            switch (group.type()) {
                case CONSUMER: {
                    ConsumerGroup consumerGroup = (ConsumerGroup)group;
                    this.metrics.onConsumerGroupStateTransition(consumerGroup.state(), null);
                    break;
                }
                case CLASSIC: {
                    ClassicGroup classicGroup = (ClassicGroup)group;
                    this.metrics.onClassicGroupStateTransition(classicGroup.currentState(), null);
                    break;
                }
                case SHARE: {
                    break;
                }
                default: {
                    this.log.warn("Removed group {} with an unknown group type {}.", (Object)groupId, (Object)group.type());
                }
            }
        }
    }

    private void throwIfEmptyString(String value, String error) throws InvalidRequestException {
        if (value != null && value.trim().isEmpty()) {
            throw new InvalidRequestException(error);
        }
    }

    private void throwIfNotNull(Object value, String error) throws InvalidRequestException {
        if (value != null) {
            throw new InvalidRequestException(error);
        }
    }

    private void throwIfNull(Object value, String error) throws InvalidRequestException {
        if (value == null) {
            throw new InvalidRequestException(error);
        }
    }

    private void throwIfConsumerGroupHeartbeatRequestIsInvalid(ConsumerGroupHeartbeatRequestData request) throws InvalidRequestException, UnsupportedAssignorException {
        this.throwIfEmptyString(request.groupId(), "GroupId can't be empty.");
        this.throwIfEmptyString(request.instanceId(), "InstanceId can't be empty.");
        this.throwIfEmptyString(request.rackId(), "RackId can't be empty.");
        if (request.memberEpoch() > 0 || request.memberEpoch() == -1) {
            this.throwIfEmptyString(request.memberId(), "MemberId can't be empty.");
        } else if (request.memberEpoch() == 0) {
            if (request.rebalanceTimeoutMs() == -1) {
                throw new InvalidRequestException("RebalanceTimeoutMs must be provided in first request.");
            }
            if (request.topicPartitions() == null || !request.topicPartitions().isEmpty()) {
                throw new InvalidRequestException("TopicPartitions must be empty when (re-)joining.");
            }
            if (request.subscribedTopicNames() == null || request.subscribedTopicNames().isEmpty()) {
                throw new InvalidRequestException("SubscribedTopicNames must be set in first request.");
            }
        } else if (request.memberEpoch() == -2) {
            this.throwIfEmptyString(request.memberId(), "MemberId can't be empty.");
            this.throwIfNull(request.instanceId(), "InstanceId can't be null.");
        } else {
            throw new InvalidRequestException("MemberEpoch is invalid.");
        }
        if (request.serverAssignor() != null && !this.consumerGroupAssignors.containsKey(request.serverAssignor())) {
            throw new UnsupportedAssignorException("ServerAssignor " + request.serverAssignor() + " is not supported. Supported assignors: " + String.join((CharSequence)", ", this.consumerGroupAssignors.keySet()) + ".");
        }
    }

    private void throwIfShareGroupHeartbeatRequestIsInvalid(ShareGroupHeartbeatRequestData request) throws InvalidRequestException, UnsupportedAssignorException {
        this.throwIfEmptyString(request.groupId(), "GroupId can't be empty.");
        this.throwIfEmptyString(request.rackId(), "RackId can't be empty.");
        if (request.memberEpoch() > 0 || request.memberEpoch() == -1) {
            this.throwIfEmptyString(request.memberId(), "MemberId can't be empty.");
        } else if (request.memberEpoch() == 0) {
            if (request.subscribedTopicNames() == null || request.subscribedTopicNames().isEmpty()) {
                throw new InvalidRequestException("SubscribedTopicNames must be set in first request.");
            }
        } else {
            throw new InvalidRequestException("MemberEpoch is invalid.");
        }
    }

    private boolean isSubset(List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions, Map<Uuid, Set<Integer>> target) {
        if (ownedTopicPartitions == null) {
            return false;
        }
        for (ConsumerGroupHeartbeatRequestData.TopicPartitions topicPartitions : ownedTopicPartitions) {
            Set<Integer> partitions = target.get(topicPartitions.topicId());
            if (partitions == null) {
                return false;
            }
            for (Integer partitionId : topicPartitions.partitions()) {
                if (partitions.contains(partitionId)) continue;
                return false;
            }
        }
        return true;
    }

    private void throwIfConsumerGroupIsFull(ConsumerGroup group, String memberId) throws GroupMaxSizeReachedException {
        if (group.numMembers() >= this.consumerGroupMaxSize && (memberId.isEmpty() || !group.hasMember(memberId))) {
            throw new GroupMaxSizeReachedException("The consumer group has reached its maximum capacity of " + this.consumerGroupMaxSize + " members.");
        }
    }

    private void throwIfShareGroupIsFull(ShareGroup group, String memberId) throws GroupMaxSizeReachedException {
        if (group.numMembers() >= this.shareGroupMaxSize && (memberId.isEmpty() || !group.hasMember(memberId))) {
            throw new GroupMaxSizeReachedException("The share group has reached its maximum capacity of " + this.shareGroupMaxSize + " members.");
        }
    }

    private void throwIfConsumerGroupMemberEpochIsInvalid(ConsumerGroupMember member, int receivedMemberEpoch, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) {
        if (receivedMemberEpoch > member.memberEpoch()) {
            throw new FencedMemberEpochException("The consumer group member has a greater member epoch (" + receivedMemberEpoch + ") than the one known by the group coordinator (" + member.memberEpoch() + "). The member must abandon all its partitions and rejoin.");
        }
        if (!(receivedMemberEpoch >= member.memberEpoch() || receivedMemberEpoch == member.previousMemberEpoch() && this.isSubset(ownedTopicPartitions, member.assignedPartitions()))) {
            throw new FencedMemberEpochException("The consumer group member has a smaller member epoch (" + receivedMemberEpoch + ") than the one known by the group coordinator (" + member.memberEpoch() + "). The member must abandon all its partitions and rejoin.");
        }
    }

    private void throwIfShareGroupMemberEpochIsInvalid(ShareGroupMember member, int receivedMemberEpoch) {
        if (receivedMemberEpoch > member.memberEpoch()) {
            throw new FencedMemberEpochException("The share group member has a greater member epoch (" + receivedMemberEpoch + ") than the one known by the group coordinator (" + member.memberEpoch() + "). The member must abandon all its partitions and rejoin.");
        }
    }

    private void throwIfInstanceIdIsUnreleased(ConsumerGroupMember member, String groupId, String receivedMemberId, String receivedInstanceId) {
        if (member.memberEpoch() != -2) {
            this.log.info("[GroupId {}] Static member {} with instance id {} cannot join the group because the instance id is is owned by member {}.", new Object[]{groupId, receivedMemberId, receivedInstanceId, member.memberId()});
            throw Errors.UNRELEASED_INSTANCE_ID.exception("Static member " + receivedMemberId + " with instance id " + receivedInstanceId + " cannot join the group because the instance id is owned by " + member.memberId() + " member.");
        }
    }

    private void throwIfInstanceIdIsFenced(ConsumerGroupMember member, String groupId, String receivedMemberId, String receivedInstanceId) {
        if (!member.memberId().equals(receivedMemberId)) {
            this.log.info("[GroupId {}] Static member {} with instance id {} is fenced by existing member {}.", new Object[]{groupId, receivedMemberId, receivedInstanceId, member.memberId()});
            throw Errors.FENCED_INSTANCE_ID.exception("Static member " + receivedMemberId + " with instance id " + receivedInstanceId + " was fenced by member " + member.memberId() + ".");
        }
    }

    private void throwIfStaticMemberIsUnknown(ConsumerGroupMember staticMember, String receivedInstanceId) {
        if (staticMember == null) {
            throw Errors.UNKNOWN_MEMBER_ID.exception("Instance id " + receivedInstanceId + " is unknown.");
        }
    }

    private void throwIfClassicProtocolIsNotSupported(ConsumerGroup group, String memberId, String protocolType, JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols) {
        if (!group.supportsClassicProtocols(protocolType, ClassicGroupMember.plainProtocolSet(protocols))) {
            throw Errors.INCONSISTENT_GROUP_PROTOCOL.exception("Member " + memberId + "'s protocols are not supported.");
        }
    }

    private void throwIfMemberDoesNotUseClassicProtocol(ConsumerGroupMember member) {
        if (!member.useClassicProtocol()) {
            throw new UnknownMemberIdException(String.format("Member %s does not use the classic protocol.", member.memberId()));
        }
    }

    private void throwIfGenerationIdUnmatched(String memberId, int memberEpoch, int requestGenerationId) {
        if (memberEpoch != requestGenerationId) {
            throw Errors.ILLEGAL_GENERATION.exception(String.format("The request generation id %s is not equal to the member epoch %d of member %s.", requestGenerationId, memberEpoch, memberId));
        }
    }

    private void throwIfClassicProtocolUnmatched(ConsumerGroupMember member, String requestProtocolType, String requestProtocolName) {
        String protocolName = member.supportedClassicProtocols().get().iterator().next().name();
        if (requestProtocolType != null && !"consumer".equals(requestProtocolType)) {
            throw Errors.INCONSISTENT_GROUP_PROTOCOL.exception(String.format("The protocol type %s from member %s request is not equal to the group protocol type %s.", requestProtocolType, member.memberId(), "consumer"));
        }
        if (requestProtocolName != null && !protocolName.equals(requestProtocolName)) {
            throw Errors.INCONSISTENT_GROUP_PROTOCOL.exception(String.format("The protocol name %s from member %s request is not equal to the protocol name %s returned in the join response.", requestProtocolName, member.memberId(), protocolName));
        }
    }

    private void throwIfRebalanceInProgress(ConsumerGroup group, ConsumerGroupMember member) {
        if (group.groupEpoch() > member.memberEpoch() && !member.state().equals((Object)MemberState.UNREVOKED_PARTITIONS)) {
            this.scheduleConsumerGroupJoinTimeoutIfAbsent(group.groupId(), member.memberId(), member.rebalanceTimeoutMs());
            throw Errors.REBALANCE_IN_PROGRESS.exception(String.format("A new rebalance is triggered in group %s and member %s should rejoin to catch up.", group.groupId(), member.memberId()));
        }
    }

    private static ConsumerProtocolSubscription deserializeSubscription(JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols) {
        try {
            return ConsumerProtocol.deserializeConsumerProtocolSubscription((ByteBuffer)ByteBuffer.wrap(((JoinGroupRequestData.JoinGroupRequestProtocol)protocols.iterator().next()).metadata()));
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Malformed embedded consumer protocol in subscription deserialization.");
        }
    }

    private ConsumerGroupHeartbeatResponseData.Assignment createConsumerGroupResponseAssignment(ConsumerGroupMember member) {
        return new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(this.fromAssignmentMap(member.assignedPartitions()));
    }

    private ShareGroupHeartbeatResponseData.Assignment createShareGroupResponseAssignment(ShareGroupMember member) {
        return new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(this.fromShareGroupAssignmentMap(member.assignedPartitions()));
    }

    private List<ConsumerGroupHeartbeatResponseData.TopicPartitions> fromAssignmentMap(Map<Uuid, Set<Integer>> assignment) {
        return assignment.entrySet().stream().map(keyValue -> new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId((Uuid)keyValue.getKey()).setPartitions(new ArrayList((Collection)keyValue.getValue()))).collect(Collectors.toList());
    }

    private List<ShareGroupHeartbeatResponseData.TopicPartitions> fromShareGroupAssignmentMap(Map<Uuid, Set<Integer>> assignment) {
        return assignment.entrySet().stream().map(keyValue -> new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId((Uuid)keyValue.getKey()).setPartitions(new ArrayList((Collection)keyValue.getValue()))).collect(Collectors.toList());
    }

    private CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> consumerGroupHeartbeat(String groupId, String memberId, int memberEpoch, String instanceId, String rackId, int rebalanceTimeoutMs, String clientId, String clientHost, List<String> subscribedTopicNames, String assignorName, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) throws ApiException {
        boolean isFullRequest;
        int targetAssignmentEpoch;
        Assignment targetAssignment;
        long currentTimeMs = this.time.milliseconds();
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        boolean createIfNotExists = memberEpoch == 0;
        ConsumerGroup group = this.getOrMaybeCreateConsumerGroup(groupId, createIfNotExists, records);
        this.throwIfConsumerGroupIsFull(group, memberId);
        if (memberId.isEmpty()) {
            memberId = Uuid.randomUuid().toString();
        }
        ConsumerGroupMember member = instanceId == null ? this.getOrMaybeSubscribeDynamicConsumerGroupMember(group, memberId, memberEpoch, ownedTopicPartitions, createIfNotExists, false) : this.getOrMaybeSubscribeStaticConsumerGroupMember(group, memberId, memberEpoch, instanceId, ownedTopicPartitions, createIfNotExists, false, records);
        ConsumerGroupMember updatedMember = new ConsumerGroupMember.Builder(member).maybeUpdateInstanceId(Optional.ofNullable(instanceId)).maybeUpdateRackId(Optional.ofNullable(rackId)).maybeUpdateRebalanceTimeoutMs(Utils.ofSentinel(rebalanceTimeoutMs)).maybeUpdateServerAssignorName(Optional.ofNullable(assignorName)).maybeUpdateSubscribedTopicNames(Optional.ofNullable(subscribedTopicNames)).setClientId(clientId).setClientHost(clientHost).setClassicMemberMetadata(null).build();
        boolean bumpGroupEpoch = this.hasMemberSubscriptionChanged(groupId, member, updatedMember, records);
        int groupEpoch = group.groupEpoch();
        Map<String, TopicMetadata> subscriptionMetadata = group.subscriptionMetadata();
        Map<String, Integer> subscribedTopicNamesMap = group.subscribedTopicNames();
        SubscriptionType subscriptionType = group.subscriptionType();
        if (bumpGroupEpoch || group.hasMetadataExpired(currentTimeMs)) {
            subscribedTopicNamesMap = group.computeSubscribedTopicNames(member, updatedMember);
            subscriptionMetadata = group.computeSubscriptionMetadata(subscribedTopicNamesMap, this.metadataImage.topics(), this.metadataImage.cluster());
            int numMembers = group.numMembers();
            if (!group.hasMember(updatedMember.memberId()) && !group.hasStaticMember(updatedMember.instanceId())) {
                ++numMembers;
            }
            subscriptionType = ConsumerGroup.subscriptionType(subscribedTopicNamesMap, numMembers);
            if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
                this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)groupId, subscriptionMetadata);
                bumpGroupEpoch = true;
                records.add(CoordinatorRecordHelpers.newGroupSubscriptionMetadataRecord(groupId, subscriptionMetadata));
            }
            if (bumpGroupEpoch) {
                records.add(CoordinatorRecordHelpers.newGroupEpochRecord(groupId, ++groupEpoch));
                this.log.info("[GroupId {}] Bumped group epoch to {}.", (Object)groupId, (Object)groupEpoch);
                this.metrics.record("ConsumerGroupRebalances");
            }
            group.setMetadataRefreshDeadline(currentTimeMs + (long)this.consumerGroupMetadataRefreshIntervalMs, groupEpoch);
        }
        if (groupEpoch > group.assignmentEpoch()) {
            targetAssignment = this.updateTargetAssignment(group, groupEpoch, member, updatedMember, subscriptionMetadata, subscriptionType, records);
            targetAssignmentEpoch = groupEpoch;
        } else {
            targetAssignmentEpoch = group.assignmentEpoch();
            targetAssignment = group.targetAssignment(updatedMember.memberId(), updatedMember.instanceId());
        }
        updatedMember = this.maybeReconcile(groupId, updatedMember, group::currentPartitionEpoch, targetAssignmentEpoch, targetAssignment, ownedTopicPartitions, records);
        this.scheduleConsumerGroupSessionTimeout(groupId, memberId);
        ConsumerGroupHeartbeatResponseData response = new ConsumerGroupHeartbeatResponseData().setMemberId(updatedMember.memberId()).setMemberEpoch(updatedMember.memberEpoch()).setHeartbeatIntervalMs(this.consumerGroupHeartbeatIntervalMs);
        boolean bl = isFullRequest = memberEpoch == 0 || rebalanceTimeoutMs != -1 && subscribedTopicNames != null && ownedTopicPartitions != null;
        if (isFullRequest || ConsumerGroupMember.hasAssignedPartitionsChanged(member, updatedMember)) {
            response.setAssignment(this.createConsumerGroupResponseAssignment(updatedMember));
        }
        return new CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord>(records, response);
    }

    private CoordinatorResult<Void, CoordinatorRecord> classicGroupJoinToConsumerGroup(ConsumerGroup group, RequestContext context, JoinGroupRequestData request, CompletableFuture<JoinGroupResponseData> responseFuture) throws ApiException {
        int targetAssignmentEpoch;
        Assignment targetAssignment;
        long currentTimeMs = this.time.milliseconds();
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        String groupId = request.groupId();
        String instanceId = request.groupInstanceId();
        int sessionTimeoutMs = request.sessionTimeoutMs();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = request.protocols();
        String memberId = request.memberId();
        boolean isUnknownMember = memberId.equals("");
        if (isUnknownMember) {
            memberId = Uuid.randomUuid().toString();
        }
        this.throwIfConsumerGroupIsFull(group, memberId);
        this.throwIfClassicProtocolIsNotSupported(group, memberId, request.protocolType(), protocols);
        if (JoinGroupRequest.requiresKnownMemberId((JoinGroupRequestData)request, (short)context.apiVersion())) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.MEMBER_ID_REQUIRED.code()));
            this.log.info("[GroupId {}] Dynamic member with unknown member id joins the consumer group. Created a new member id {} and requesting the member to rejoin with this id.", (Object)groupId, (Object)memberId);
            return EMPTY_RESULT;
        }
        ConsumerGroupMember member = instanceId == null ? this.getOrMaybeSubscribeDynamicConsumerGroupMember(group, memberId, -1, Collections.emptyList(), true, true) : this.getOrMaybeSubscribeStaticConsumerGroupMember(group, memberId, -1, instanceId, Collections.emptyList(), isUnknownMember, true, records);
        int groupEpoch = group.groupEpoch();
        Map<String, TopicMetadata> subscriptionMetadata = group.subscriptionMetadata();
        Map<String, Integer> subscribedTopicNamesMap = group.subscribedTopicNames();
        SubscriptionType subscriptionType = group.subscriptionType();
        ConsumerProtocolSubscription subscription = GroupMetadataManager.deserializeSubscription(protocols);
        ConsumerGroupMember updatedMember = new ConsumerGroupMember.Builder(member).maybeUpdateInstanceId(Optional.ofNullable(instanceId)).maybeUpdateRackId(Utils.toOptional(subscription.rackId())).maybeUpdateRebalanceTimeoutMs(Utils.ofSentinel(request.rebalanceTimeoutMs())).maybeUpdateServerAssignorName(Optional.empty()).maybeUpdateSubscribedTopicNames(Optional.ofNullable(subscription.topics())).setClientId(context.clientId()).setClientHost(context.clientAddress.toString()).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(sessionTimeoutMs).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection(protocols))).build();
        boolean bumpGroupEpoch = this.hasMemberSubscriptionChanged(groupId, member, updatedMember, records);
        if (bumpGroupEpoch || group.hasMetadataExpired(currentTimeMs)) {
            subscribedTopicNamesMap = group.computeSubscribedTopicNames(member, updatedMember);
            subscriptionMetadata = group.computeSubscriptionMetadata(subscribedTopicNamesMap, this.metadataImage.topics(), this.metadataImage.cluster());
            int numMembers = group.numMembers();
            if (!group.hasMember(updatedMember.memberId()) && !group.hasStaticMember(updatedMember.instanceId())) {
                ++numMembers;
            }
            subscriptionType = ConsumerGroup.subscriptionType(subscribedTopicNamesMap, numMembers);
            if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
                this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)groupId, subscriptionMetadata);
                bumpGroupEpoch = true;
                records.add(CoordinatorRecordHelpers.newGroupSubscriptionMetadataRecord(groupId, subscriptionMetadata));
            }
            if (bumpGroupEpoch) {
                records.add(CoordinatorRecordHelpers.newGroupEpochRecord(groupId, ++groupEpoch));
                this.log.info("[GroupId {}] Bumped group epoch to {}.", (Object)groupId, (Object)groupEpoch);
                this.metrics.record("ConsumerGroupRebalances");
            }
            group.setMetadataRefreshDeadline(currentTimeMs + (long)this.consumerGroupMetadataRefreshIntervalMs, groupEpoch);
        }
        if (groupEpoch > group.assignmentEpoch()) {
            targetAssignment = this.updateTargetAssignment(group, groupEpoch, member, updatedMember, subscriptionMetadata, subscriptionType, records);
            targetAssignmentEpoch = groupEpoch;
        } else {
            targetAssignmentEpoch = group.assignmentEpoch();
            targetAssignment = group.targetAssignment(updatedMember.memberId(), updatedMember.instanceId());
        }
        updatedMember = this.maybeReconcile(groupId, updatedMember, group::currentPartitionEpoch, targetAssignmentEpoch, targetAssignment, Utils.toTopicPartitions(subscription.ownedPartitions(), this.metadataImage.topics()), records);
        JoinGroupResponseData response = new JoinGroupResponseData().setMemberId(updatedMember.memberId()).setGenerationId(updatedMember.memberEpoch()).setProtocolType("consumer").setProtocolName(updatedMember.supportedClassicProtocols().get().iterator().next().name());
        CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
        appendFuture.whenComplete((__, t) -> {
            if (t == null) {
                this.cancelConsumerGroupJoinTimeout(groupId, response.memberId());
                this.scheduleConsumerGroupSessionTimeout(groupId, response.memberId(), sessionTimeoutMs);
                this.scheduleConsumerGroupSyncTimeout(groupId, response.memberId(), request.rebalanceTimeoutMs());
                responseFuture.complete(response);
            }
        });
        return new CoordinatorResult<Object, CoordinatorRecord>(records, null, appendFuture, true);
    }

    private CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord> shareGroupHeartbeat(String groupId, String memberId, int memberEpoch, String rackId, String clientId, String clientHost, List<String> subscribedTopicNames) throws ApiException {
        int targetAssignmentEpoch;
        Assignment targetAssignment;
        long currentTimeMs = this.time.milliseconds();
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        ArrayList<CoordinatorRecord> replayRecords = new ArrayList<CoordinatorRecord>();
        boolean createIfNotExists = memberEpoch == 0;
        ShareGroup group = this.getOrMaybeCreatePersistedShareGroup(groupId, createIfNotExists);
        this.throwIfShareGroupIsFull(group, memberId);
        if (memberId.isEmpty()) {
            memberId = Uuid.randomUuid().toString();
        }
        ShareGroupMember member = this.getOrMaybeSubscribeShareGroupMember(group, memberId, memberEpoch, createIfNotExists);
        ShareGroupMember.Builder updatedMemberBuilder = new ShareGroupMember.Builder(member);
        ShareGroupMember updatedMember = updatedMemberBuilder.maybeUpdateRackId(Optional.ofNullable(rackId)).maybeUpdateSubscribedTopicNames(Optional.ofNullable(subscribedTopicNames)).setClientId(clientId).setClientHost(clientHost).build();
        boolean bumpGroupEpoch = this.hasMemberSubscriptionChanged(groupId, member, updatedMember, records);
        int groupEpoch = group.groupEpoch();
        Map<String, TopicMetadata> subscriptionMetadata = group.subscriptionMetadata();
        SubscriptionType subscriptionType = group.subscriptionType();
        if (bumpGroupEpoch || group.hasMetadataExpired(currentTimeMs)) {
            Map<String, Integer> subscribedTopicNamesMap = group.computeSubscribedTopicNames(member, updatedMember);
            subscriptionMetadata = group.computeSubscriptionMetadata(subscribedTopicNamesMap, this.metadataImage.topics(), this.metadataImage.cluster());
            int numMembers = group.numMembers();
            if (!group.hasMember(updatedMember.memberId())) {
                ++numMembers;
            }
            subscriptionType = ModernGroup.subscriptionType(subscribedTopicNamesMap, numMembers);
            if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
                this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)groupId, subscriptionMetadata);
                bumpGroupEpoch = true;
                replayRecords.add(CoordinatorRecordHelpers.newGroupSubscriptionMetadataRecord(groupId, subscriptionMetadata));
            }
            if (bumpGroupEpoch) {
                records.add(CoordinatorRecordHelpers.newGroupEpochRecord(groupId, ++groupEpoch, Group.GroupType.SHARE));
                this.log.info("[GroupId {}] Bumped group epoch to {}.", (Object)groupId, (Object)groupEpoch);
            }
            group.setMetadataRefreshDeadline(currentTimeMs + (long)this.shareGroupMetadataRefreshIntervalMs, groupEpoch);
        }
        if (groupEpoch > group.assignmentEpoch()) {
            targetAssignment = this.updateTargetAssignment(group, groupEpoch, updatedMember, subscriptionMetadata, subscriptionType, replayRecords);
            targetAssignmentEpoch = groupEpoch;
        } else {
            targetAssignmentEpoch = group.assignmentEpoch();
            targetAssignment = group.targetAssignment(updatedMember.memberId());
        }
        updatedMember = this.maybeReconcile(groupId, updatedMember, targetAssignmentEpoch, targetAssignment, replayRecords);
        this.scheduleShareGroupSessionTimeout(groupId, memberId);
        ShareGroupHeartbeatResponseData response = new ShareGroupHeartbeatResponseData().setMemberId(updatedMember.memberId()).setMemberEpoch(updatedMember.memberEpoch()).setHeartbeatIntervalMs(this.shareGroupHeartbeatIntervalMs);
        if (memberEpoch == 0 || ConsumerGroupMember.hasAssignedPartitionsChanged(member, updatedMember)) {
            response.setAssignment(this.createShareGroupResponseAssignment(updatedMember));
        }
        replayRecords.forEach(this::replay);
        return new CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord>(records, response);
    }

    private ConsumerGroupMember getOrMaybeSubscribeDynamicConsumerGroupMember(ConsumerGroup group, String memberId, int memberEpoch, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions, boolean createIfNotExists, boolean useClassicProtocol) {
        ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, createIfNotExists);
        if (!useClassicProtocol) {
            this.throwIfConsumerGroupMemberEpochIsInvalid(member, memberEpoch, ownedTopicPartitions);
        }
        if (createIfNotExists) {
            this.log.info("[GroupId {}] Member {} joins the consumer group using the {} protocol.", new Object[]{group.groupId(), memberId, useClassicProtocol ? "classic" : "consumer"});
        }
        return member;
    }

    private ConsumerGroupMember getOrMaybeSubscribeStaticConsumerGroupMember(ConsumerGroup group, String memberId, int memberEpoch, String instanceId, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions, boolean createIfNotExists, boolean useClassicProtocol, List<CoordinatorRecord> records) {
        ConsumerGroupMember existingStaticMemberOrNull = group.staticMember(instanceId);
        if (createIfNotExists) {
            if (existingStaticMemberOrNull == null) {
                ConsumerGroupMember newMember = group.getOrMaybeCreateMember(memberId, true);
                this.log.info("[GroupId {}] Static member {} with instance id {} joins the consumer group using the {} protocol.", new Object[]{group.groupId(), memberId, instanceId, useClassicProtocol ? "classic" : "consumer"});
                return newMember;
            }
            if (!useClassicProtocol) {
                this.throwIfInstanceIdIsUnreleased(existingStaticMemberOrNull, group.groupId(), memberId, instanceId);
            }
            ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(existingStaticMemberOrNull, memberId).setMemberEpoch(0).setPreviousMemberEpoch(0).build();
            this.replaceMember(records, group, existingStaticMemberOrNull, newMember);
            this.log.info("[GroupId {}] Static member with instance id {} re-joins the consumer group using the {} protocol. Created a new member {} to replace the existing member {}.", new Object[]{group.groupId(), instanceId, useClassicProtocol ? "classic" : "consumer", memberId, existingStaticMemberOrNull.memberId()});
            return newMember;
        }
        this.throwIfStaticMemberIsUnknown(existingStaticMemberOrNull, instanceId);
        this.throwIfInstanceIdIsFenced(existingStaticMemberOrNull, group.groupId(), memberId, instanceId);
        if (!useClassicProtocol) {
            this.throwIfConsumerGroupMemberEpochIsInvalid(existingStaticMemberOrNull, memberEpoch, ownedTopicPartitions);
        }
        return existingStaticMemberOrNull;
    }

    private ShareGroupMember getOrMaybeSubscribeShareGroupMember(ShareGroup group, String memberId, int memberEpoch, boolean createIfNotExists) {
        ShareGroupMember member = group.getOrMaybeCreateMember(memberId, createIfNotExists);
        this.throwIfShareGroupMemberEpochIsInvalid(member, memberEpoch);
        if (createIfNotExists) {
            this.log.info("[GroupId {}] Member {} joins the share group using the share protocol.", (Object)group.groupId(), (Object)memberId);
        }
        return member;
    }

    private boolean hasMemberSubscriptionChanged(String groupId, ConsumerGroupMember member, ConsumerGroupMember updatedMember, List<CoordinatorRecord> records) {
        String memberId = updatedMember.memberId();
        if (!updatedMember.equals(member)) {
            records.add(CoordinatorRecordHelpers.newMemberSubscriptionRecord(groupId, updatedMember));
            if (!updatedMember.subscribedTopicNames().equals(member.subscribedTopicNames())) {
                this.log.info("[GroupId {}] Member {} updated its subscribed topics to: {}.", new Object[]{groupId, memberId, updatedMember.subscribedTopicNames()});
                return true;
            }
            if (!updatedMember.subscribedTopicRegex().equals(member.subscribedTopicRegex())) {
                this.log.info("[GroupId {}] Member {} updated its subscribed regex to: {}.", new Object[]{groupId, memberId, updatedMember.subscribedTopicRegex()});
                return true;
            }
        }
        return false;
    }

    private boolean hasMemberSubscriptionChanged(String groupId, ShareGroupMember member, ShareGroupMember updatedMember, List<CoordinatorRecord> records) {
        String memberId = updatedMember.memberId();
        if (!updatedMember.equals(member)) {
            records.add(CoordinatorRecordHelpers.newShareGroupMemberSubscriptionRecord(groupId, updatedMember));
            if (!updatedMember.subscribedTopicNames().equals(member.subscribedTopicNames())) {
                this.log.info("[GroupId {}] Member {} updated its subscribed topics to: {}.", new Object[]{groupId, memberId, updatedMember.subscribedTopicNames()});
                return true;
            }
        }
        return false;
    }

    private ConsumerGroupMember maybeReconcile(String groupId, ConsumerGroupMember member, BiFunction<Uuid, Integer, Integer> currentPartitionEpoch, int targetAssignmentEpoch, Assignment targetAssignment, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions, List<CoordinatorRecord> records) {
        if (member.isReconciledTo(targetAssignmentEpoch)) {
            return member;
        }
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(targetAssignmentEpoch, targetAssignment).withCurrentPartitionEpoch(currentPartitionEpoch).withOwnedTopicPartitions(ownedTopicPartitions).build();
        if (!updatedMember.equals(member)) {
            records.add(CoordinatorRecordHelpers.newCurrentAssignmentRecord(groupId, updatedMember));
            this.log.info("[GroupId {}] Member {} new assignment state: epoch={}, previousEpoch={}, state={}, assignedPartitions={} and revokedPartitions={}.", new Object[]{groupId, updatedMember.memberId(), updatedMember.memberEpoch(), updatedMember.previousMemberEpoch(), updatedMember.state(), Utils.assignmentToString(updatedMember.assignedPartitions()), Utils.assignmentToString(updatedMember.partitionsPendingRevocation())});
            if (!updatedMember.useClassicProtocol()) {
                if (updatedMember.state() == MemberState.UNREVOKED_PARTITIONS) {
                    this.scheduleConsumerGroupRebalanceTimeout(groupId, updatedMember.memberId(), updatedMember.memberEpoch(), updatedMember.rebalanceTimeoutMs());
                } else {
                    this.cancelConsumerGroupRebalanceTimeout(groupId, updatedMember.memberId());
                }
            }
        }
        return updatedMember;
    }

    private ShareGroupMember maybeReconcile(String groupId, ShareGroupMember member, int targetAssignmentEpoch, Assignment targetAssignment, List<CoordinatorRecord> records) {
        if (member.isReconciledTo(targetAssignmentEpoch)) {
            return member;
        }
        ShareGroupMember updatedMember = new ShareGroupAssignmentBuilder(member).withTargetAssignment(targetAssignmentEpoch, targetAssignment).build();
        if (!updatedMember.equals(member)) {
            records.add(CoordinatorRecordHelpers.newCurrentAssignmentRecord(groupId, updatedMember));
            this.log.info("[GroupId {}] Member {} new assignment state: epoch={}, previousEpoch={}, state={}, assignedPartitions={}.", new Object[]{groupId, updatedMember.memberId(), updatedMember.memberEpoch(), updatedMember.previousMemberEpoch(), updatedMember.state(), Utils.assignmentToString(updatedMember.assignedPartitions())});
        }
        return updatedMember;
    }

    private Assignment updateTargetAssignment(ConsumerGroup group, int groupEpoch, ConsumerGroupMember member, ConsumerGroupMember updatedMember, Map<String, TopicMetadata> subscriptionMetadata, SubscriptionType subscriptionType, List<CoordinatorRecord> records) {
        String preferredServerAssignor = group.computePreferredServerAssignor(member, updatedMember).orElse(this.defaultConsumerGroupAssignor.name());
        try {
            TargetAssignmentBuilder<ConsumerGroupMember> assignmentResultBuilder = new TargetAssignmentBuilder(group.groupId(), groupEpoch, (PartitionAssignor)this.consumerGroupAssignors.get(preferredServerAssignor)).withMembers(group.members()).withStaticMembers(group.staticMembers()).withSubscriptionMetadata(subscriptionMetadata).withSubscriptionType(subscriptionType).withTargetAssignment(group.targetAssignment()).withInvertedTargetAssignment(group.invertedTargetAssignment()).withTopicsImage(this.metadataImage.topics()).addOrUpdateMember(updatedMember.memberId(), updatedMember);
            String previousMemberId = group.staticMemberId(updatedMember.instanceId());
            if (previousMemberId != null && !updatedMember.memberId().equals(previousMemberId)) {
                assignmentResultBuilder.removeMember(previousMemberId);
            }
            long startTimeMs = this.time.milliseconds();
            TargetAssignmentBuilder.TargetAssignmentResult assignmentResult = assignmentResultBuilder.build();
            long assignorTimeMs = this.time.milliseconds() - startTimeMs;
            this.log.info("[GroupId {}] Computed a new target assignment for epoch {} with '{}' assignor in {}ms: {}.", new Object[]{group.groupId(), groupEpoch, preferredServerAssignor, assignorTimeMs, assignmentResult.targetAssignment()});
            records.addAll(assignmentResult.records());
            MemberAssignment newMemberAssignment = assignmentResult.targetAssignment().get(updatedMember.memberId());
            if (newMemberAssignment != null) {
                return new Assignment(newMemberAssignment.partitions());
            }
            return Assignment.EMPTY;
        }
        catch (PartitionAssignorException ex) {
            String msg = String.format("Failed to compute a new target assignment for epoch %d: %s", groupEpoch, ex.getMessage());
            this.log.error("[GroupId {}] {}.", (Object)group.groupId(), (Object)msg);
            throw new UnknownServerException(msg, (Throwable)ex);
        }
    }

    private Assignment updateTargetAssignment(ShareGroup group, int groupEpoch, ShareGroupMember updatedMember, Map<String, TopicMetadata> subscriptionMetadata, SubscriptionType subscriptionType, List<CoordinatorRecord> records) {
        try {
            TargetAssignmentBuilder<ShareGroupMember> assignmentResultBuilder = new TargetAssignmentBuilder(group.groupId(), groupEpoch, (PartitionAssignor)this.shareGroupAssignor).withMembers(group.members()).withSubscriptionMetadata(subscriptionMetadata).withSubscriptionType(subscriptionType).withTargetAssignment(group.targetAssignment()).withInvertedTargetAssignment(group.invertedTargetAssignment()).withTopicsImage(this.metadataImage.topics()).addOrUpdateMember(updatedMember.memberId(), updatedMember);
            long startTimeMs = this.time.milliseconds();
            TargetAssignmentBuilder.TargetAssignmentResult assignmentResult = assignmentResultBuilder.build();
            long assignorTimeMs = this.time.milliseconds() - startTimeMs;
            this.log.info("[GroupId {}] Computed a new target assignment for epoch {} with '{}' assignor in {}ms: {}.", new Object[]{group.groupId(), groupEpoch, this.shareGroupAssignor, assignorTimeMs, assignmentResult.targetAssignment()});
            records.addAll(assignmentResult.records());
            MemberAssignment newMemberAssignment = assignmentResult.targetAssignment().get(updatedMember.memberId());
            if (newMemberAssignment != null) {
                return new Assignment(newMemberAssignment.partitions());
            }
            return Assignment.EMPTY;
        }
        catch (PartitionAssignorException ex) {
            String msg = String.format("Failed to compute a new target assignment for epoch %d: %s", groupEpoch, ex.getMessage());
            this.log.error("[GroupId {}] {}.", (Object)group.groupId(), (Object)msg);
            throw new UnknownServerException(msg, (Throwable)ex);
        }
    }

    private CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> consumerGroupLeave(String groupId, String instanceId, String memberId, int memberEpoch) throws ApiException {
        ConsumerGroup group = this.consumerGroup(groupId);
        ConsumerGroupHeartbeatResponseData response = new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(memberEpoch);
        if (instanceId == null) {
            ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, false);
            this.log.info("[GroupId {}] Member {} left the consumer group.", (Object)groupId, (Object)memberId);
            return this.consumerGroupFenceMember(group, member, response);
        }
        ConsumerGroupMember member = group.staticMember(instanceId);
        this.throwIfStaticMemberIsUnknown(member, instanceId);
        this.throwIfInstanceIdIsFenced(member, groupId, memberId, instanceId);
        if (memberEpoch == -2) {
            this.log.info("[GroupId {}] Static Member {} with instance id {} temporarily left the consumer group.", new Object[]{group.groupId(), memberId, instanceId});
            return this.consumerGroupStaticMemberGroupLeave(group, member);
        }
        this.log.info("[GroupId {}] Static Member {} with instance id {} left the consumer group.", new Object[]{group.groupId(), memberId, instanceId});
        return this.consumerGroupFenceMember(group, member, response);
    }

    private CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> consumerGroupStaticMemberGroupLeave(ConsumerGroup group, ConsumerGroupMember member) {
        ConsumerGroupMember leavingStaticMember = new ConsumerGroupMember.Builder(member).setMemberEpoch(-2).setPartitionsPendingRevocation(Collections.emptyMap()).build();
        return new CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord>(Collections.singletonList(CoordinatorRecordHelpers.newCurrentAssignmentRecord(group.groupId(), leavingStaticMember)), new ConsumerGroupHeartbeatResponseData().setMemberId(member.memberId()).setMemberEpoch(-2));
    }

    private CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord> shareGroupLeave(String groupId, String memberId, int memberEpoch) throws ApiException {
        ShareGroup group = this.shareGroup(groupId);
        ShareGroupHeartbeatResponseData response = new ShareGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(memberEpoch);
        ShareGroupMember member = group.getOrMaybeCreateMember(memberId, false);
        this.log.info("[GroupId {}] Member {} left the share group.", (Object)groupId, (Object)memberId);
        return this.shareGroupFenceMember(group, member, response);
    }

    private <T> CoordinatorResult<T, CoordinatorRecord> consumerGroupFenceMember(ConsumerGroup group, ConsumerGroupMember member, T response) {
        if (this.validateOnlineDowngrade(group, member.memberId())) {
            return this.convertToClassicGroup(group, member.memberId(), response);
        }
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        this.removeMember(records, group.groupId(), member.memberId());
        Map<String, TopicMetadata> subscriptionMetadata = group.computeSubscriptionMetadata(group.computeSubscribedTopicNames(member, null), this.metadataImage.topics(), this.metadataImage.cluster());
        if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
            this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)group.groupId(), subscriptionMetadata);
            records.add(CoordinatorRecordHelpers.newGroupSubscriptionMetadataRecord(group.groupId(), subscriptionMetadata));
        }
        int groupEpoch = group.groupEpoch() + 1;
        records.add(CoordinatorRecordHelpers.newGroupEpochRecord(group.groupId(), groupEpoch));
        this.cancelTimers(group.groupId(), member.memberId());
        return new CoordinatorResult<T, CoordinatorRecord>(records, response);
    }

    private <T> CoordinatorResult<T, CoordinatorRecord> shareGroupFenceMember(ShareGroup group, ShareGroupMember member, T response) {
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        ArrayList<CoordinatorRecord> replayRecords = new ArrayList<CoordinatorRecord>();
        replayRecords.add(CoordinatorRecordHelpers.newCurrentAssignmentTombstoneRecord(group.groupId(), member.memberId()));
        replayRecords.add(CoordinatorRecordHelpers.newTargetAssignmentTombstoneRecord(group.groupId(), member.memberId()));
        records.add(CoordinatorRecordHelpers.newShareGroupMemberSubscriptionTombstoneRecord(group.groupId(), member.memberId()));
        Map<String, TopicMetadata> subscriptionMetadata = group.computeSubscriptionMetadata(group.computeSubscribedTopicNames(member, null), this.metadataImage.topics(), this.metadataImage.cluster());
        if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
            this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)group.groupId(), subscriptionMetadata);
            replayRecords.add(CoordinatorRecordHelpers.newGroupSubscriptionMetadataRecord(group.groupId(), subscriptionMetadata));
        }
        int groupEpoch = group.groupEpoch() + 1;
        records.add(CoordinatorRecordHelpers.newGroupEpochRecord(group.groupId(), groupEpoch, Group.GroupType.SHARE));
        this.cancelGroupSessionTimeout(group.groupId(), member.memberId());
        replayRecords.forEach(this::replay);
        return new CoordinatorResult(records, response);
    }

    private void replaceMember(List<CoordinatorRecord> records, ConsumerGroup group, ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        String groupId = group.groupId();
        this.removeMember(records, groupId, oldMember.memberId());
        records.add(CoordinatorRecordHelpers.newMemberSubscriptionRecord(groupId, newMember));
        records.add(CoordinatorRecordHelpers.newTargetAssignmentRecord(groupId, newMember.memberId(), group.targetAssignment(oldMember.memberId()).partitions()));
        records.add(CoordinatorRecordHelpers.newCurrentAssignmentRecord(groupId, newMember));
    }

    private void removeMember(List<CoordinatorRecord> records, String groupId, String memberId) {
        records.add(CoordinatorRecordHelpers.newCurrentAssignmentTombstoneRecord(groupId, memberId));
        records.add(CoordinatorRecordHelpers.newTargetAssignmentTombstoneRecord(groupId, memberId));
        records.add(CoordinatorRecordHelpers.newMemberSubscriptionTombstoneRecord(groupId, memberId));
    }

    private void cancelTimers(String groupId, String memberId) {
        this.cancelGroupSessionTimeout(groupId, memberId);
        this.cancelConsumerGroupRebalanceTimeout(groupId, memberId);
        this.cancelConsumerGroupJoinTimeout(groupId, memberId);
        this.cancelConsumerGroupSyncTimeout(groupId, memberId);
    }

    private void scheduleConsumerGroupSessionTimeout(String groupId, String memberId) {
        this.scheduleConsumerGroupSessionTimeout(groupId, memberId, this.consumerGroupSessionTimeoutMs);
    }

    private void scheduleShareGroupSessionTimeout(String groupId, String memberId) {
        this.scheduleShareGroupSessionTimeout(groupId, memberId, this.shareGroupSessionTimeoutMs);
    }

    private <T> CoordinatorResult<T, CoordinatorRecord> consumerGroupFenceMemberOperation(String groupId, String memberId, String reason) {
        try {
            ConsumerGroup group = this.consumerGroup(groupId);
            ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, false);
            this.log.info("[GroupId {}] Member {} fenced from the group because {}.", new Object[]{groupId, memberId, reason});
            return this.consumerGroupFenceMember(group, member, null);
        }
        catch (GroupIdNotFoundException ex) {
            this.log.debug("[GroupId {}] Could not fence {} because the group does not exist.", (Object)groupId, (Object)memberId);
        }
        catch (UnknownMemberIdException ex) {
            this.log.debug("[GroupId {}] Could not fence {} because the member does not exist.", (Object)groupId, (Object)memberId);
        }
        return new CoordinatorResult(Collections.emptyList());
    }

    private <T> CoordinatorResult<T, CoordinatorRecord> shareGroupFenceMemberOperation(String groupId, String memberId, String reason) {
        try {
            ShareGroup group = this.shareGroup(groupId);
            ShareGroupMember member = group.getOrMaybeCreateMember(memberId, false);
            this.log.info("[GroupId {}] Member {} fenced from the group because {}.", new Object[]{groupId, memberId, reason});
            return this.shareGroupFenceMember(group, member, null);
        }
        catch (GroupIdNotFoundException ex) {
            this.log.debug("[GroupId {}] Could not fence {} because the group does not exist.", (Object)groupId, (Object)memberId);
        }
        catch (UnknownMemberIdException ex) {
            this.log.debug("[GroupId {}] Could not fence {} because the member does not exist.", (Object)groupId, (Object)memberId);
        }
        return new CoordinatorResult(Collections.emptyList());
    }

    private void scheduleConsumerGroupSessionTimeout(String groupId, String memberId, int sessionTimeoutMs) {
        this.timer.schedule(GroupMetadataManager.groupSessionTimeoutKey(groupId, memberId), sessionTimeoutMs, TimeUnit.MILLISECONDS, true, () -> this.consumerGroupFenceMemberOperation(groupId, memberId, "the member session expired."));
    }

    private void scheduleShareGroupSessionTimeout(String groupId, String memberId, int sessionTimeoutMs) {
        this.timer.schedule(GroupMetadataManager.groupSessionTimeoutKey(groupId, memberId), sessionTimeoutMs, TimeUnit.MILLISECONDS, true, () -> this.shareGroupFenceMemberOperation(groupId, memberId, "the member session expired."));
    }

    private void cancelGroupSessionTimeout(String groupId, String memberId) {
        this.timer.cancel(GroupMetadataManager.groupSessionTimeoutKey(groupId, memberId));
    }

    private void scheduleConsumerGroupRebalanceTimeout(String groupId, String memberId, int memberEpoch, int rebalanceTimeoutMs) {
        String key = GroupMetadataManager.consumerGroupRebalanceTimeoutKey(groupId, memberId);
        this.timer.schedule(key, rebalanceTimeoutMs, TimeUnit.MILLISECONDS, true, () -> {
            try {
                ConsumerGroup group = this.consumerGroup(groupId);
                ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, false);
                if (member.memberEpoch() == memberEpoch) {
                    this.log.info("[GroupId {}] Member {} fenced from the group because it failed to transition from epoch {} within {}ms.", new Object[]{groupId, memberId, memberEpoch, rebalanceTimeoutMs});
                    return this.consumerGroupFenceMember(group, member, null);
                }
                this.log.debug("[GroupId {}] Ignoring rebalance timeout for {} because the member left the epoch {}.", new Object[]{groupId, memberId, memberEpoch});
                return new CoordinatorResult(Collections.emptyList());
            }
            catch (GroupIdNotFoundException ex) {
                this.log.debug("[GroupId {}] Could not fence {}} because the group does not exist.", (Object)groupId, (Object)memberId);
            }
            catch (UnknownMemberIdException ex) {
                this.log.debug("[GroupId {}] Could not fence {} because the member does not exist.", (Object)groupId, (Object)memberId);
            }
            return new CoordinatorResult(Collections.emptyList());
        });
    }

    private void cancelConsumerGroupRebalanceTimeout(String groupId, String memberId) {
        this.timer.cancel(GroupMetadataManager.consumerGroupRebalanceTimeoutKey(groupId, memberId));
    }

    private void scheduleConsumerGroupJoinTimeoutIfAbsent(String groupId, String memberId, int rebalanceTimeoutMs) {
        this.timer.scheduleIfAbsent(GroupMetadataManager.consumerGroupJoinKey(groupId, memberId), rebalanceTimeoutMs, TimeUnit.MILLISECONDS, true, () -> this.consumerGroupFenceMemberOperation(groupId, memberId, "the classic member failed to join within the rebalance timeout."));
    }

    private void cancelConsumerGroupJoinTimeout(String groupId, String memberId) {
        this.timer.cancel(GroupMetadataManager.consumerGroupJoinKey(groupId, memberId));
    }

    private void scheduleConsumerGroupSyncTimeout(String groupId, String memberId, int rebalanceTimeoutMs) {
        this.timer.schedule(GroupMetadataManager.consumerGroupSyncKey(groupId, memberId), rebalanceTimeoutMs, TimeUnit.MILLISECONDS, true, () -> this.consumerGroupFenceMemberOperation(groupId, memberId, "the member failed to sync within timeout."));
    }

    private void cancelConsumerGroupSyncTimeout(String groupId, String memberId) {
        this.timer.cancel(GroupMetadataManager.consumerGroupSyncKey(groupId, memberId));
    }

    public CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) throws ApiException {
        this.throwIfConsumerGroupHeartbeatRequestIsInvalid(request);
        if (request.memberEpoch() == -1 || request.memberEpoch() == -2) {
            return this.consumerGroupLeave(request.groupId(), request.instanceId(), request.memberId(), request.memberEpoch());
        }
        return this.consumerGroupHeartbeat(request.groupId(), request.memberId(), request.memberEpoch(), request.instanceId(), request.rackId(), request.rebalanceTimeoutMs(), context.clientId(), context.clientAddress.toString(), request.subscribedTopicNames(), request.serverAssignor(), request.topicPartitions());
    }

    public CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord> shareGroupHeartbeat(RequestContext context, ShareGroupHeartbeatRequestData request) throws ApiException {
        this.throwIfShareGroupHeartbeatRequestIsInvalid(request);
        if (request.memberEpoch() == -1) {
            return this.shareGroupLeave(request.groupId(), request.memberId(), request.memberEpoch());
        }
        return this.shareGroupHeartbeat(request.groupId(), request.memberId(), request.memberEpoch(), request.rackId(), context.clientId(), context.clientAddress.toString(), request.subscribedTopicNames());
    }

    private void replay(CoordinatorRecord record) {
        ApiMessageAndVersion key = record.key();
        ApiMessageAndVersion value = record.value();
        switch (key.version()) {
            case 4: {
                this.replay((ConsumerGroupPartitionMetadataKey)key.message(), (ConsumerGroupPartitionMetadataValue)Utils.messageOrNull(value), Group.GroupType.SHARE);
                break;
            }
            case 6: {
                this.replay((ConsumerGroupTargetAssignmentMetadataKey)key.message(), (ConsumerGroupTargetAssignmentMetadataValue)Utils.messageOrNull(value), Group.GroupType.SHARE);
                break;
            }
            case 7: {
                this.replay((ConsumerGroupTargetAssignmentMemberKey)key.message(), (ConsumerGroupTargetAssignmentMemberValue)Utils.messageOrNull(value), Group.GroupType.SHARE);
                break;
            }
            case 8: {
                this.replay((ConsumerGroupCurrentMemberAssignmentKey)key.message(), (ConsumerGroupCurrentMemberAssignmentValue)Utils.messageOrNull(value), Group.GroupType.SHARE);
                break;
            }
            default: {
                throw new IllegalStateException("Received an unknown record type " + key.version() + " in " + record);
            }
        }
    }

    public void replay(ConsumerGroupMemberMetadataKey key, ConsumerGroupMemberMetadataValue value) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreatePersistedConsumerGroup(groupId, value != null);
        HashSet<String> oldSubscribedTopicNames = new HashSet<String>(consumerGroup.subscribedTopicNames().keySet());
        if (value != null) {
            ConsumerGroupMember oldMember = consumerGroup.getOrMaybeCreateMember(memberId, true);
            consumerGroup.updateMember(new ConsumerGroupMember.Builder(oldMember).updateWith(value).build());
        } else {
            ConsumerGroupMember oldMember = consumerGroup.getOrMaybeCreateMember(memberId, false);
            if (oldMember.memberEpoch() != -1) {
                throw new IllegalStateException("Received a tombstone record to delete member " + memberId + " but did not receive ConsumerGroupCurrentMemberAssignmentValue tombstone.");
            }
            if (consumerGroup.targetAssignment().containsKey(memberId)) {
                throw new IllegalStateException("Received a tombstone record to delete member " + memberId + " but did not receive ConsumerGroupTargetAssignmentMetadataValue tombstone.");
            }
            consumerGroup.removeMember(memberId);
        }
        this.updateGroupsByTopics(groupId, oldSubscribedTopicNames, consumerGroup.subscribedTopicNames().keySet());
    }

    public Set<String> groupsSubscribedToTopic(String topicName) {
        Set<String> groups = (Set<String>)this.groupsByTopics.get((Object)topicName);
        return groups != null ? groups : Collections.emptySet();
    }

    private void subscribeGroupToTopic(String groupId, String topicName) {
        ((TimelineHashSet)this.groupsByTopics.computeIfAbsent((Object)topicName, __ -> new TimelineHashSet(this.snapshotRegistry, 1))).add((Object)groupId);
    }

    private void unsubscribeGroupFromTopic(String groupId, String topicName) {
        this.groupsByTopics.computeIfPresent((Object)topicName, (__, groupIds) -> {
            groupIds.remove((Object)groupId);
            return groupIds.isEmpty() ? null : groupIds;
        });
    }

    private void updateGroupsByTopics(String groupId, Set<String> oldSubscribedTopics, Set<String> newSubscribedTopics) {
        if (oldSubscribedTopics.isEmpty()) {
            newSubscribedTopics.forEach(topicName -> this.subscribeGroupToTopic(groupId, (String)topicName));
        } else if (newSubscribedTopics.isEmpty()) {
            oldSubscribedTopics.forEach(topicName -> this.unsubscribeGroupFromTopic(groupId, (String)topicName));
        } else {
            oldSubscribedTopics.forEach(topicName -> {
                if (!newSubscribedTopics.contains(topicName)) {
                    this.unsubscribeGroupFromTopic(groupId, (String)topicName);
                }
            });
            newSubscribedTopics.forEach(topicName -> {
                if (!oldSubscribedTopics.contains(topicName)) {
                    this.subscribeGroupToTopic(groupId, (String)topicName);
                }
            });
        }
    }

    public void replay(ConsumerGroupMetadataKey key, ConsumerGroupMetadataValue value) {
        String groupId = key.groupId();
        if (value != null) {
            ConsumerGroup consumerGroup = this.getOrMaybeCreatePersistedConsumerGroup(groupId, true);
            consumerGroup.setGroupEpoch(value.epoch());
        } else {
            ConsumerGroup consumerGroup = this.getOrMaybeCreatePersistedConsumerGroup(groupId, false);
            if (!consumerGroup.members().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but the group still has " + consumerGroup.members().size() + " members.");
            }
            if (!consumerGroup.targetAssignment().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but the target assignment still has " + consumerGroup.targetAssignment().size() + " members.");
            }
            if (consumerGroup.assignmentEpoch() != -1) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but did not receive ConsumerGroupTargetAssignmentMetadataValue tombstone.");
            }
            this.removeGroup(groupId);
        }
    }

    public void replay(ConsumerGroupPartitionMetadataKey key, ConsumerGroupPartitionMetadataValue value) {
        this.replay(key, value, Group.GroupType.CONSUMER);
    }

    public void replay(ConsumerGroupPartitionMetadataKey key, ConsumerGroupPartitionMetadataValue value, Group.GroupType groupType) {
        String groupId = key.groupId();
        ModernGroup<?> group = this.getOrMaybeCreatePersistedGroup(groupId, false, groupType);
        if (value != null) {
            HashMap<String, TopicMetadata> subscriptionMetadata = new HashMap<String, TopicMetadata>();
            value.topics().forEach(topicMetadata -> subscriptionMetadata.put(topicMetadata.topicName(), TopicMetadata.fromRecord(topicMetadata)));
            group.setSubscriptionMetadata(subscriptionMetadata);
        } else {
            group.setSubscriptionMetadata(Collections.emptyMap());
        }
    }

    public void replay(ConsumerGroupTargetAssignmentMemberKey key, ConsumerGroupTargetAssignmentMemberValue value) {
        this.replay(key, value, Group.GroupType.CONSUMER);
    }

    public void replay(ConsumerGroupTargetAssignmentMemberKey key, ConsumerGroupTargetAssignmentMemberValue value, Group.GroupType groupType) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        ModernGroup<?> group = this.getOrMaybeCreatePersistedGroup(groupId, false, groupType);
        if (value != null) {
            group.updateTargetAssignment(memberId, Assignment.fromRecord(value));
        } else {
            group.removeTargetAssignment(memberId);
        }
    }

    public void replay(ConsumerGroupTargetAssignmentMetadataKey key, ConsumerGroupTargetAssignmentMetadataValue value) {
        this.replay(key, value, Group.GroupType.CONSUMER);
    }

    public void replay(ConsumerGroupTargetAssignmentMetadataKey key, ConsumerGroupTargetAssignmentMetadataValue value, Group.GroupType groupType) {
        String groupId = key.groupId();
        ModernGroup<?> group = this.getOrMaybeCreatePersistedGroup(groupId, false, groupType);
        if (value != null) {
            group.setTargetAssignmentEpoch(value.assignmentEpoch());
        } else {
            if (!group.targetAssignment().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete target assignment of " + groupId + " but the assignment still has " + group.targetAssignment().size() + " members.");
            }
            group.setTargetAssignmentEpoch(-1);
        }
    }

    public void replay(ConsumerGroupCurrentMemberAssignmentKey key, ConsumerGroupCurrentMemberAssignmentValue value) {
        this.replay(key, value, Group.GroupType.CONSUMER);
    }

    public void replay(ConsumerGroupCurrentMemberAssignmentKey key, ConsumerGroupCurrentMemberAssignmentValue value, Group.GroupType groupType) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        if (groupType == Group.GroupType.CONSUMER) {
            ConsumerGroup group = this.getOrMaybeCreatePersistedConsumerGroup(groupId, false);
            ConsumerGroupMember oldMember = group.getOrMaybeCreateMember(memberId, false);
            if (value != null) {
                ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(oldMember).updateWith(value).build();
                group.updateMember(newMember);
            } else {
                ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(oldMember).setMemberEpoch(-1).setPreviousMemberEpoch(-1).setAssignedPartitions(Collections.emptyMap()).setPartitionsPendingRevocation(Collections.emptyMap()).build();
                group.updateMember(newMember);
            }
        } else if (groupType == Group.GroupType.SHARE) {
            ShareGroup group = this.getOrMaybeCreatePersistedShareGroup(groupId, false);
            ShareGroupMember oldMember = group.getOrMaybeCreateMember(memberId, false);
            if (value != null) {
                ShareGroupMember newMember = new ShareGroupMember.Builder(oldMember).updateWith(value).build();
                group.updateMember(newMember);
            } else {
                ShareGroupMember newMember = new ShareGroupMember.Builder(oldMember).setMemberEpoch(-1).setPreviousMemberEpoch(-1).setAssignedPartitions(Collections.emptyMap()).build();
                group.updateMember(newMember);
            }
        } else {
            throw new IllegalStateException("Received a ConsumerGroupCurrentMemberAssignmentKey/Value record for an unknown group type: " + (Object)((Object)groupType));
        }
    }

    public void replay(ShareGroupMemberMetadataKey key, ShareGroupMemberMetadataValue value) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        ShareGroup shareGroup = this.getOrMaybeCreatePersistedShareGroup(groupId, value != null);
        HashSet<String> oldSubscribedTopicNames = new HashSet<String>(shareGroup.subscribedTopicNames().keySet());
        if (value != null) {
            ShareGroupMember oldMember = shareGroup.getOrMaybeCreateMember(memberId, true);
            shareGroup.updateMember(new ShareGroupMember.Builder(oldMember).updateWith(value).build());
        } else {
            ShareGroupMember oldMember = shareGroup.getOrMaybeCreateMember(memberId, false);
            if (oldMember.memberEpoch() != -1) {
                throw new IllegalStateException("Received a tombstone record to delete member " + memberId + " with invalid leave group epoch.");
            }
            if (shareGroup.targetAssignment().containsKey(memberId)) {
                throw new IllegalStateException("Received a tombstone record to delete member " + memberId + " but member exists in target assignment.");
            }
            shareGroup.removeMember(memberId);
        }
        this.updateGroupsByTopics(groupId, oldSubscribedTopicNames, shareGroup.subscribedTopicNames().keySet());
    }

    public void replay(ShareGroupMetadataKey key, ShareGroupMetadataValue value) {
        String groupId = key.groupId();
        if (value != null) {
            ShareGroup shareGroup = this.getOrMaybeCreatePersistedShareGroup(groupId, true);
            shareGroup.setGroupEpoch(value.epoch());
        } else {
            ShareGroup shareGroup = this.getOrMaybeCreatePersistedShareGroup(groupId, false);
            if (!shareGroup.members().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but the group still has " + shareGroup.members().size() + " members.");
            }
            if (!shareGroup.targetAssignment().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but the target assignment still has " + shareGroup.targetAssignment().size() + " members.");
            }
            if (shareGroup.assignmentEpoch() != -1) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but target assignment epoch in invalid.");
            }
            this.removeGroup(groupId);
        }
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.metadataImage = newImage;
        Optional.ofNullable(delta.topicsDelta()).ifPresent(topicsDelta -> {
            HashSet allGroupIds = new HashSet();
            topicsDelta.changedTopics().forEach((topicId, topicDelta) -> {
                String topicName = topicDelta.name();
                allGroupIds.addAll(this.groupsSubscribedToTopic(topicName));
            });
            topicsDelta.deletedTopicIds().forEach(topicId -> {
                TopicImage topicImage = delta.image().topics().getTopic(topicId);
                allGroupIds.addAll(this.groupsSubscribedToTopic(topicImage.name()));
            });
            allGroupIds.forEach(groupId -> {
                Group group = (Group)this.groups.get(groupId);
                if (group != null && (group.type() == Group.GroupType.CONSUMER || group.type() == Group.GroupType.SHARE)) {
                    ((ModernGroup)group).requestMetadataRefresh();
                }
            });
        });
    }

    public void onLoaded() {
        this.groups.forEach((groupId, group) -> {
            switch (group.type()) {
                case CONSUMER: {
                    ConsumerGroup consumerGroup = (ConsumerGroup)group;
                    this.log.info("Loaded consumer group {} with {} members.", groupId, (Object)consumerGroup.members().size());
                    consumerGroup.members().forEach((memberId, member) -> {
                        this.log.debug("Loaded member {} in consumer group {}.", memberId, groupId);
                        this.scheduleConsumerGroupSessionTimeout((String)groupId, (String)memberId);
                        if (member.state() == MemberState.UNREVOKED_PARTITIONS) {
                            this.scheduleConsumerGroupRebalanceTimeout((String)groupId, member.memberId(), member.memberEpoch(), member.rebalanceTimeoutMs());
                        }
                    });
                    break;
                }
                case CLASSIC: {
                    ClassicGroup classicGroup = (ClassicGroup)group;
                    this.log.info("Loaded classic group {} with {} members.", groupId, (Object)classicGroup.allMembers().size());
                    classicGroup.allMembers().forEach(member -> {
                        this.log.debug("Loaded member {} in classic group {}.", (Object)member.memberId(), groupId);
                        this.rescheduleClassicGroupMemberHeartbeat(classicGroup, (ClassicGroupMember)member);
                    });
                    if (classicGroup.numMembers() <= this.classicGroupMaxSize) break;
                    this.prepareRebalance(classicGroup, "Freshly-loaded group " + groupId + " (size " + classicGroup.numMembers() + ") is over capacity " + this.classicGroupMaxSize + ". Rebalancing in order to give a chance for consumers to commit offsets");
                    break;
                }
                case SHARE: {
                    break;
                }
                default: {
                    this.log.warn("Loaded group {} with an unknown group type {}.", groupId, (Object)group.type());
                }
            }
        });
    }

    public void onUnloaded() {
        this.groups.values().forEach(group -> {
            switch (group.type()) {
                case CONSUMER: {
                    ConsumerGroup consumerGroup = (ConsumerGroup)group;
                    this.log.info("[GroupId={}] Unloaded group metadata for group epoch {}.", (Object)consumerGroup.groupId(), (Object)consumerGroup.groupEpoch());
                    break;
                }
                case CLASSIC: {
                    ClassicGroup classicGroup = (ClassicGroup)group;
                    this.log.info("[GroupId={}] Unloading group metadata for generation {}.", (Object)classicGroup.groupId(), (Object)classicGroup.generationId());
                    classicGroup.transitionTo(ClassicGroupState.DEAD);
                    switch (classicGroup.previousState()) {
                        case EMPTY: 
                        case DEAD: {
                            break;
                        }
                        case PREPARING_REBALANCE: {
                            classicGroup.allMembers().forEach(member -> classicGroup.completeJoinFuture((ClassicGroupMember)member, new JoinGroupResponseData().setMemberId(member.memberId()).setErrorCode(Errors.NOT_COORDINATOR.code())));
                            break;
                        }
                        case COMPLETING_REBALANCE: 
                        case STABLE: {
                            classicGroup.allMembers().forEach(member -> classicGroup.completeSyncFuture((ClassicGroupMember)member, new SyncGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())));
                        }
                    }
                    break;
                }
                case SHARE: {
                    ShareGroup shareGroup = (ShareGroup)group;
                    this.log.info("[GroupId={}] Unloaded group metadata for group epoch {}.", (Object)shareGroup.groupId(), (Object)shareGroup.groupEpoch());
                    break;
                }
                default: {
                    this.log.warn("onUnloaded group with an unknown group type {}.", (Object)group.type());
                }
            }
        });
    }

    public static String groupSessionTimeoutKey(String groupId, String memberId) {
        return "session-timeout-" + groupId + "-" + memberId;
    }

    public static String consumerGroupRebalanceTimeoutKey(String groupId, String memberId) {
        return "rebalance-timeout-" + groupId + "-" + memberId;
    }

    public void replay(GroupMetadataKey key, GroupMetadataValue value) {
        String groupId = key.group();
        if (value == null) {
            this.removeGroup(groupId);
        } else {
            ArrayList<ClassicGroupMember> loadedMembers = new ArrayList<ClassicGroupMember>();
            for (GroupMetadataValue.MemberMetadata member2 : value.members()) {
                int rebalanceTimeout = member2.rebalanceTimeout() == -1 ? member2.sessionTimeout() : member2.rebalanceTimeout();
                JoinGroupRequestData.JoinGroupRequestProtocolCollection supportedProtocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
                supportedProtocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName(value.protocol()).setMetadata(member2.subscription()));
                ClassicGroupMember loadedMember = new ClassicGroupMember(member2.memberId(), Optional.ofNullable(member2.groupInstanceId()), member2.clientId(), member2.clientHost(), rebalanceTimeout, member2.sessionTimeout(), value.protocolType(), supportedProtocols, member2.assignment());
                loadedMembers.add(loadedMember);
            }
            String protocolType = value.protocolType();
            ClassicGroup classicGroup = new ClassicGroup(this.logContext, groupId, loadedMembers.isEmpty() ? ClassicGroupState.EMPTY : ClassicGroupState.STABLE, this.time, this.metrics, value.generation(), protocolType == null || protocolType.isEmpty() ? Optional.empty() : Optional.of(protocolType), Optional.ofNullable(value.protocol()), Optional.ofNullable(value.leader()), value.currentStateTimestamp() == -1L ? Optional.empty() : Optional.of(value.currentStateTimestamp()));
            loadedMembers.forEach(member -> classicGroup.add((ClassicGroupMember)member, null));
            Group prevGroup = (Group)this.groups.put((Object)groupId, (Object)classicGroup);
            if (prevGroup == null) {
                this.metrics.onClassicGroupStateTransition(null, classicGroup.currentState());
            }
            classicGroup.setSubscribedTopics(classicGroup.computeSubscribedTopics());
        }
    }

    public CoordinatorResult<Void, CoordinatorRecord> classicGroupJoin(RequestContext context, JoinGroupRequestData request, CompletableFuture<JoinGroupResponseData> responseFuture) {
        Group group = (Group)this.groups.get((Object)request.groupId(), Long.MAX_VALUE);
        if (group != null && group.type() == Group.GroupType.CONSUMER && !group.isEmpty()) {
            return this.classicGroupJoinToConsumerGroup((ConsumerGroup)group, context, request, responseFuture);
        }
        return this.classicGroupJoinToClassicGroup(context, request, responseFuture);
    }

    CoordinatorResult<Void, CoordinatorRecord> classicGroupJoinToClassicGroup(RequestContext context, JoinGroupRequestData request, CompletableFuture<JoinGroupResponseData> responseFuture) {
        ClassicGroup group;
        CoordinatorResult<Void, CoordinatorRecord> result = EMPTY_RESULT;
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        String groupId = request.groupId();
        String memberId = request.memberId();
        boolean isUnknownMember = memberId.equals("");
        this.maybeDeleteEmptyConsumerGroup(groupId, records);
        boolean isNewGroup = !this.groups.containsKey((Object)groupId);
        try {
            group = this.getOrMaybeCreateClassicGroup(groupId, isUnknownMember);
        }
        catch (Throwable t2) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.forException((Throwable)t2).code()));
            return EMPTY_RESULT;
        }
        if (!this.acceptJoiningMember(group, memberId)) {
            group.remove(memberId);
            responseFuture.complete(new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.GROUP_MAX_SIZE_REACHED.code()));
        } else {
            result = isUnknownMember ? this.classicGroupJoinNewMember(context, request, group, responseFuture) : this.classicGroupJoinExistingMember(context, request, group, responseFuture);
        }
        if (isNewGroup && result == EMPTY_RESULT) {
            CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
            appendFuture.whenComplete((__, t) -> {
                if (t != null) {
                    this.log.warn("Failed to write empty metadata for group {}: {}", (Object)group.groupId(), (Object)t.getMessage());
                    responseFuture.complete(new JoinGroupResponseData().setErrorCode(GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t)).code()));
                }
            });
            records.add(CoordinatorRecordHelpers.newEmptyGroupMetadataRecord(group, this.metadataImage.features().metadataVersion()));
            return new CoordinatorResult<Void, CoordinatorRecord>(records, appendFuture, false);
        }
        return result;
    }

    private CoordinatorResult<Void, CoordinatorRecord> maybeCompleteJoinPhase(ClassicGroup group) {
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE) && group.hasAllMembersJoined() && group.previousState() != ClassicGroupState.EMPTY) {
            return this.completeClassicGroupJoin(group);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, CoordinatorRecord> classicGroupJoinNewMember(RequestContext context, JoinGroupRequestData request, ClassicGroup group, CompletableFuture<JoinGroupResponseData> responseFuture) {
        if (group.isInState(ClassicGroupState.DEAD)) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        } else if (!group.supportsProtocols(request.protocolType(), request.protocols())) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()));
        } else {
            Optional<String> groupInstanceId = Optional.ofNullable(request.groupInstanceId());
            String newMemberId = group.generateMemberId(context.clientId(), groupInstanceId);
            if (groupInstanceId.isPresent()) {
                return this.classicGroupJoinNewStaticMember(context, request, group, newMemberId, responseFuture);
            }
            return this.classicGroupJoinNewDynamicMember(context, request, group, newMemberId, responseFuture);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, CoordinatorRecord> classicGroupJoinNewStaticMember(RequestContext context, JoinGroupRequestData request, ClassicGroup group, String newMemberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        String groupInstanceId = request.groupInstanceId();
        String existingMemberId = group.staticMemberId(groupInstanceId);
        if (existingMemberId != null) {
            this.log.info("Static member with groupInstanceId={} and unknown member id joins group {} in {} state. Replacing previously mapped member {} with this groupInstanceId.", new Object[]{groupInstanceId, group.groupId(), group.currentState(), existingMemberId});
            return this.updateStaticMemberThenRebalanceOrCompleteJoin(context, request, group, existingMemberId, newMemberId, responseFuture);
        }
        this.log.info("Static member with groupInstanceId={} and unknown member id joins group {} in {} state. Created a new member id {} for this member and added to the group.", new Object[]{groupInstanceId, group.groupId(), group.currentState(), newMemberId});
        return this.addMemberThenRebalanceOrCompleteJoin(context, request, group, newMemberId, responseFuture);
    }

    private CoordinatorResult<Void, CoordinatorRecord> classicGroupJoinNewDynamicMember(RequestContext context, JoinGroupRequestData request, ClassicGroup group, String newMemberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        if (!JoinGroupRequest.requiresKnownMemberId((short)context.apiVersion())) {
            this.log.info("Dynamic member with unknown member id joins group {} in state {}. Created a new member id {} and added the member to the group.", new Object[]{group.groupId(), group.currentState(), newMemberId});
            return this.addMemberThenRebalanceOrCompleteJoin(context, request, group, newMemberId, responseFuture);
        }
        this.log.info("Dynamic member with unknown member id joins group {} in {} state. Created a new member id {} and requesting the member to rejoin with this id.", new Object[]{group.groupId(), group.currentState(), newMemberId});
        group.addPendingMember(newMemberId);
        String classicGroupHeartbeatKey = GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), newMemberId);
        this.timer.schedule(classicGroupHeartbeatKey, request.sessionTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.expireClassicGroupMemberHeartbeat(group.groupId(), newMemberId));
        responseFuture.complete(new JoinGroupResponseData().setMemberId(newMemberId).setErrorCode(Errors.MEMBER_ID_REQUIRED.code()));
        return EMPTY_RESULT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoordinatorResult<Void, CoordinatorRecord> classicGroupJoinExistingMember(RequestContext context, JoinGroupRequestData request, ClassicGroup group, CompletableFuture<JoinGroupResponseData> responseFuture) {
        String memberId = request.memberId();
        String groupInstanceId = request.groupInstanceId();
        if (group.isInState(ClassicGroupState.DEAD)) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            return EMPTY_RESULT;
        }
        if (!group.supportsProtocols(request.protocolType(), request.protocols())) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()));
            return EMPTY_RESULT;
        }
        if (group.isPendingMember(memberId)) {
            if (groupInstanceId != null) {
                throw new IllegalStateException("Received unexpected JoinGroup with groupInstanceId=" + groupInstanceId + " for pending member with memberId=" + memberId);
            }
            this.log.debug("Pending dynamic member with id {} joins group {} in {} state. Adding to the group now.", new Object[]{memberId, group.groupId(), group.currentState()});
            return this.addMemberThenRebalanceOrCompleteJoin(context, request, group, memberId, responseFuture);
        }
        try {
            group.validateMember(memberId, groupInstanceId, "join-group");
        }
        catch (KafkaException ex) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.forException((Throwable)ex).code()).setProtocolType(null).setProtocolName(null));
            return EMPTY_RESULT;
        }
        ClassicGroupMember member = group.member(memberId);
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE)) {
            return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Member " + member.memberId() + " is joining group during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
        }
        if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            if (!member.matches(request.protocols())) return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Updating metadata for member " + memberId + " during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
            responseFuture.complete(new JoinGroupResponseData().setMembers(group.isLeader(memberId) ? group.currentClassicGroupMembers() : Collections.emptyList()).setMemberId(memberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(false));
            return EMPTY_RESULT;
        } else if (group.isInState(ClassicGroupState.STABLE)) {
            if (group.isLeader(memberId)) {
                return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Leader " + memberId + " re-joining group during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
            }
            if (!member.matches(request.protocols())) {
                return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Updating metadata for member " + memberId + " during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
            }
            responseFuture.complete(new JoinGroupResponseData().setMembers(Collections.emptyList()).setMemberId(memberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(false));
            return EMPTY_RESULT;
        } else {
            this.log.warn("Attempt to add rejoining member {} of group {} in unexpected group state {}", new Object[]{memberId, group.groupId(), group.stateAsString()});
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, CoordinatorRecord> completeClassicGroupJoin(String groupId) {
        ClassicGroup group;
        try {
            group = this.getOrMaybeCreateClassicGroup(groupId, false);
        }
        catch (GroupIdNotFoundException | UnknownMemberIdException exception) {
            this.log.debug("Cannot find the group, skipping rebalance stage.", exception);
            return EMPTY_RESULT;
        }
        return this.completeClassicGroupJoin(group);
    }

    private CoordinatorResult<Void, CoordinatorRecord> completeClassicGroupJoin(ClassicGroup group) {
        this.timer.cancel(GroupMetadataManager.classicGroupJoinKey(group.groupId()));
        String groupId = group.groupId();
        Map<String, ClassicGroupMember> notYetRejoinedDynamicMembers = group.notYetRejoinedMembers().entrySet().stream().filter(entry -> !((ClassicGroupMember)entry.getValue()).isStaticMember()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!notYetRejoinedDynamicMembers.isEmpty()) {
            notYetRejoinedDynamicMembers.values().forEach(failedMember -> {
                group.remove(failedMember.memberId());
                this.timer.cancel(GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), failedMember.memberId()));
            });
            this.log.info("Group {} removed dynamic members who haven't joined: {}", (Object)groupId, notYetRejoinedDynamicMembers.keySet());
        }
        if (group.isInState(ClassicGroupState.DEAD)) {
            this.log.info("Group {} is dead, skipping rebalance stage.", (Object)groupId);
        } else {
            if (!group.maybeElectNewJoinedLeader() && !group.allMembers().isEmpty()) {
                this.log.error("Group {} could not complete rebalance because no members rejoined.", (Object)groupId);
                this.timer.schedule(GroupMetadataManager.classicGroupJoinKey(groupId), group.rebalanceTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.completeClassicGroupJoin(group.groupId()));
                return EMPTY_RESULT;
            }
            group.initNextGeneration();
            if (group.isInState(ClassicGroupState.EMPTY)) {
                this.log.info("Group {} with generation {} is now empty.", (Object)groupId, (Object)group.generationId());
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (t != null) {
                        Errors error = GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t));
                        this.log.warn("Failed to write empty metadata for group {}: {}", (Object)group.groupId(), (Object)error.message());
                    }
                });
                List<CoordinatorRecord> records = Collections.singletonList(CoordinatorRecordHelpers.newGroupMetadataRecord(group, Collections.emptyMap(), this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, CoordinatorRecord>(records, appendFuture, false);
            }
            this.log.info("Stabilized group {} generation {} with {} members.", new Object[]{groupId, group.generationId(), group.numMembers()});
            group.allMembers().forEach(member -> {
                List<Object> members = Collections.emptyList();
                if (group.isLeader(member.memberId())) {
                    members = group.currentClassicGroupMembers();
                }
                JoinGroupResponseData response = new JoinGroupResponseData().setMembers(members).setMemberId(member.memberId()).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(false).setErrorCode(Errors.NONE.code());
                group.completeJoinFuture((ClassicGroupMember)member, response);
                this.rescheduleClassicGroupMemberHeartbeat(group, (ClassicGroupMember)member);
                member.setIsNew(false);
                group.addPendingSyncMember(member.memberId());
            });
            this.schedulePendingSync(group);
        }
        return EMPTY_RESULT;
    }

    private void schedulePendingSync(ClassicGroup group) {
        this.timer.schedule(GroupMetadataManager.classicGroupSyncKey(group.groupId()), group.rebalanceTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.expirePendingSync(group.groupId(), group.generationId()));
    }

    private CoordinatorResult<Void, CoordinatorRecord> expireClassicGroupMemberHeartbeat(String groupId, String memberId) {
        ClassicGroup group;
        try {
            group = this.getOrMaybeCreateClassicGroup(groupId, false);
        }
        catch (GroupIdNotFoundException | UnknownMemberIdException exception) {
            this.log.debug("Received notification of heartbeat expiration for member {} after group {} had already been deleted or upgraded.", (Object)memberId, (Object)groupId);
            return EMPTY_RESULT;
        }
        if (group.isInState(ClassicGroupState.DEAD)) {
            this.log.info("Received notification of heartbeat expiration for member {} after group {} had already been unloaded or deleted.", (Object)memberId, (Object)group.groupId());
        } else {
            if (group.isPendingMember(memberId)) {
                this.log.info("Pending member {} in group {} has been removed after session timeout expiration.", (Object)memberId, (Object)group.groupId());
                return this.removePendingMemberAndUpdateClassicGroup(group, memberId);
            }
            if (!group.hasMember(memberId)) {
                this.log.debug("Member {} has already been removed from the group.", (Object)memberId);
            } else {
                ClassicGroupMember member = group.member(memberId);
                if (!member.hasSatisfiedHeartbeat()) {
                    this.log.info("Member {} in group {} has failed, removing it from the group.", (Object)member.memberId(), (Object)group.groupId());
                    return this.removeMemberAndUpdateClassicGroup(group, member, "removing member " + member.memberId() + " on heartbeat expiration.");
                }
            }
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, CoordinatorRecord> removeMemberAndUpdateClassicGroup(ClassicGroup group, ClassicGroupMember member, String reason) {
        group.completeJoinFuture(member, new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        group.remove(member.memberId());
        if (group.isInState(ClassicGroupState.STABLE) || group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            return this.maybePrepareRebalanceOrCompleteJoin(group, reason);
        }
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE) && group.hasAllMembersJoined()) {
            return this.completeClassicGroupJoin(group);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, CoordinatorRecord> removePendingMemberAndUpdateClassicGroup(ClassicGroup group, String memberId) {
        group.remove(memberId);
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE) && group.hasAllMembersJoined()) {
            return this.completeClassicGroupJoin(group);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, CoordinatorRecord> updateMemberThenRebalanceOrCompleteJoin(JoinGroupRequestData request, ClassicGroup group, ClassicGroupMember member, String joinReason, CompletableFuture<JoinGroupResponseData> responseFuture) {
        group.updateMember(member, request.protocols(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), responseFuture);
        return this.maybePrepareRebalanceOrCompleteJoin(group, joinReason);
    }

    private CoordinatorResult<Void, CoordinatorRecord> addMemberThenRebalanceOrCompleteJoin(RequestContext context, JoinGroupRequestData request, ClassicGroup group, String memberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        Optional<String> groupInstanceId = Optional.ofNullable(request.groupInstanceId());
        ClassicGroupMember member = new ClassicGroupMember(memberId, groupInstanceId, context.clientId(), context.clientAddress().toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), request.protocols());
        member.setIsNew(true);
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE) && group.previousState() == ClassicGroupState.EMPTY) {
            group.setNewMemberAdded(true);
        }
        group.add(member, responseFuture);
        this.rescheduleClassicGroupMemberHeartbeat(group, member, this.classicGroupNewMemberJoinTimeoutMs);
        return this.maybePrepareRebalanceOrCompleteJoin(group, "Adding new member " + memberId + " with group instance id " + request.groupInstanceId() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request));
    }

    private CoordinatorResult<Void, CoordinatorRecord> maybePrepareRebalanceOrCompleteJoin(ClassicGroup group, String reason) {
        if (group.canRebalance()) {
            return this.prepareRebalance(group, reason);
        }
        return this.maybeCompleteJoinPhase(group);
    }

    CoordinatorResult<Void, CoordinatorRecord> prepareRebalance(ClassicGroup group, String reason) {
        if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            this.resetAndPropagateAssignmentWithError(group, Errors.REBALANCE_IN_PROGRESS);
        }
        this.removeSyncExpiration(group);
        boolean isInitialRebalance = group.isInState(ClassicGroupState.EMPTY);
        if (isInitialRebalance) {
            int delayMs = this.classicGroupInitialRebalanceDelayMs;
            int remainingMs = Math.max(group.rebalanceTimeoutMs() - this.classicGroupInitialRebalanceDelayMs, 0);
            this.timer.schedule(GroupMetadataManager.classicGroupJoinKey(group.groupId()), delayMs, TimeUnit.MILLISECONDS, false, () -> this.tryCompleteInitialRebalanceElseSchedule(group.groupId(), delayMs, remainingMs));
        }
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.log.info("Preparing to rebalance group {} in state {} with old generation {} (reason: {}).", new Object[]{group.groupId(), group.currentState(), group.generationId(), reason});
        return isInitialRebalance ? EMPTY_RESULT : this.maybeCompleteJoinElseSchedule(group);
    }

    private CoordinatorResult<Void, CoordinatorRecord> maybeCompleteJoinElseSchedule(ClassicGroup group) {
        String classicGroupJoinKey = GroupMetadataManager.classicGroupJoinKey(group.groupId());
        if (group.hasAllMembersJoined()) {
            return this.completeClassicGroupJoin(group);
        }
        this.timer.schedule(classicGroupJoinKey, group.rebalanceTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.completeClassicGroupJoin(group.groupId()));
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, CoordinatorRecord> tryCompleteInitialRebalanceElseSchedule(String groupId, int delayMs, int remainingMs) {
        ClassicGroup group;
        try {
            group = this.getOrMaybeCreateClassicGroup(groupId, false);
        }
        catch (GroupIdNotFoundException | UnknownMemberIdException exception) {
            this.log.debug("Cannot find the group, skipping the initial rebalance stage.", exception);
            return EMPTY_RESULT;
        }
        if (!group.newMemberAdded() || remainingMs == 0) {
            return this.completeClassicGroupJoin(group);
        }
        group.setNewMemberAdded(false);
        int newDelayMs = Math.min(this.classicGroupInitialRebalanceDelayMs, remainingMs);
        int newRemainingMs = Math.max(remainingMs - delayMs, 0);
        this.timer.schedule(GroupMetadataManager.classicGroupJoinKey(group.groupId()), newDelayMs, TimeUnit.MILLISECONDS, false, () -> this.tryCompleteInitialRebalanceElseSchedule(group.groupId(), newDelayMs, newRemainingMs));
        return EMPTY_RESULT;
    }

    private void resetAndPropagateAssignmentWithError(ClassicGroup group, Errors error) {
        if (!group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            throw new IllegalStateException("Group " + group.groupId() + " must be in " + ClassicGroupState.COMPLETING_REBALANCE.name() + " state but is in " + (Object)((Object)group.currentState()) + ".");
        }
        group.allMembers().forEach(member -> member.setAssignment(ClassicGroupMember.EMPTY_ASSIGNMENT));
        this.propagateAssignment(group, error);
    }

    private void setAndPropagateAssignment(ClassicGroup group, Map<String, byte[]> assignment) {
        if (!group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            throw new IllegalStateException("The group must be in CompletingRebalance state to set and propagate assignment.");
        }
        group.allMembers().forEach(member -> member.setAssignment(assignment.getOrDefault(member.memberId(), ClassicGroupMember.EMPTY_ASSIGNMENT)));
        this.propagateAssignment(group, Errors.NONE);
    }

    private void propagateAssignment(ClassicGroup group, Errors error) {
        Optional<Object> protocolName = Optional.empty();
        Optional<Object> protocolType = Optional.empty();
        if (error == Errors.NONE) {
            protocolName = group.protocolName();
            protocolType = group.protocolType();
        }
        for (ClassicGroupMember member : group.allMembers()) {
            if (!member.hasAssignment() && error == Errors.NONE) {
                this.log.warn("Sending empty assignment to member {} of {} for generation {} with no errors", new Object[]{member.memberId(), group.groupId(), group.generationId()});
            }
            if (!group.completeSyncFuture(member, new SyncGroupResponseData().setProtocolName((String)protocolName.orElse(null)).setProtocolType((String)protocolType.orElse(null)).setAssignment(member.assignment()).setErrorCode(error.code()))) continue;
            this.rescheduleClassicGroupMemberHeartbeat(group, member);
        }
    }

    public void rescheduleClassicGroupMemberHeartbeat(ClassicGroup group, ClassicGroupMember member) {
        this.rescheduleClassicGroupMemberHeartbeat(group, member, member.sessionTimeoutMs());
    }

    private void rescheduleClassicGroupMemberHeartbeat(ClassicGroup group, ClassicGroupMember member, long timeoutMs) {
        String classicGroupHeartbeatKey = GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), member.memberId());
        this.timer.schedule(classicGroupHeartbeatKey, timeoutMs, TimeUnit.MILLISECONDS, false, () -> this.expireClassicGroupMemberHeartbeat(group.groupId(), member.memberId()));
    }

    private void removeSyncExpiration(ClassicGroup group) {
        group.clearPendingSyncMembers();
        this.timer.cancel(GroupMetadataManager.classicGroupSyncKey(group.groupId()));
    }

    private CoordinatorResult<Void, CoordinatorRecord> expirePendingSync(String groupId, int generationId) {
        ClassicGroup group;
        try {
            group = this.getOrMaybeCreateClassicGroup(groupId, false);
        }
        catch (GroupIdNotFoundException | UnknownMemberIdException exception) {
            this.log.debug("Received notification of sync expiration for an unknown classic group {}.", (Object)groupId);
            return EMPTY_RESULT;
        }
        if (generationId != group.generationId()) {
            this.log.error("Received unexpected notification of sync expiration for {} with an old generation {} while the group has {}.", new Object[]{group.groupId(), generationId, group.generationId()});
        } else if (group.isInState(ClassicGroupState.DEAD) || group.isInState(ClassicGroupState.EMPTY) || group.isInState(ClassicGroupState.PREPARING_REBALANCE)) {
            this.log.error("Received unexpected notification of sync expiration after group {} already transitioned to {} state.", (Object)group.groupId(), (Object)group.stateAsString());
        } else if ((group.isInState(ClassicGroupState.COMPLETING_REBALANCE) || group.isInState(ClassicGroupState.STABLE)) && !group.hasReceivedSyncFromAllMembers()) {
            HashSet<String> pendingSyncMembers = new HashSet<String>(group.allPendingSyncMembers());
            pendingSyncMembers.forEach(memberId -> {
                group.remove((String)memberId);
                this.timer.cancel(GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), memberId));
            });
            this.log.debug("Group {} removed members who haven't sent their sync requests: {}", (Object)group.groupId(), pendingSyncMembers);
            return this.prepareRebalance(group, "Removing " + pendingSyncMembers + " on pending sync request expiration");
        }
        return EMPTY_RESULT;
    }

    private boolean acceptJoiningMember(ClassicGroup group, String memberId) {
        switch (group.currentState()) {
            case EMPTY: 
            case DEAD: {
                return true;
            }
            case PREPARING_REBALANCE: {
                return group.hasMember(memberId) && group.member(memberId).isAwaitingJoin() || group.numAwaitingJoinResponse() < this.classicGroupMaxSize;
            }
            case COMPLETING_REBALANCE: 
            case STABLE: {
                return group.hasMember(memberId) || group.numMembers() < this.classicGroupMaxSize;
            }
        }
        throw new IllegalStateException("Unknown group state: " + group.stateAsString());
    }

    private CoordinatorResult<Void, CoordinatorRecord> updateStaticMemberThenRebalanceOrCompleteJoin(RequestContext context, JoinGroupRequestData request, ClassicGroup group, String oldMemberId, String newMemberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        String currentLeader = group.leaderOrNull();
        ClassicGroupMember newMember = group.replaceStaticMember(request.groupInstanceId(), oldMemberId, newMemberId);
        this.rescheduleClassicGroupMemberHeartbeat(group, newMember);
        int oldRebalanceTimeoutMs = newMember.rebalanceTimeoutMs();
        int oldSessionTimeoutMs = newMember.sessionTimeoutMs();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection oldProtocols = newMember.supportedProtocols();
        group.updateMember(newMember, request.protocols(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), responseFuture);
        if (group.isInState(ClassicGroupState.STABLE)) {
            String groupInstanceId = request.groupInstanceId();
            String selectedProtocolForNextGeneration = group.selectProtocol();
            if (group.protocolName().orElse("").equals(selectedProtocolForNextGeneration)) {
                this.log.info("Static member which joins during Stable stage and doesn't affect the selected protocol will not trigger a rebalance.");
                Map<String, byte[]> groupAssignment = group.groupAssignment();
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (t != null) {
                        this.log.warn("Failed to persist metadata for group {} static member {} with group instance id {} due to {}. Reverting to old member id {}.", new Object[]{group.groupId(), newMemberId, groupInstanceId, t.getMessage(), oldMemberId});
                        group.updateMember(newMember, oldProtocols, oldRebalanceTimeoutMs, oldSessionTimeoutMs, null);
                        ClassicGroupMember oldMember = group.replaceStaticMember(groupInstanceId, newMemberId, oldMemberId);
                        this.rescheduleClassicGroupMemberHeartbeat(group, oldMember);
                        responseFuture.complete(new JoinGroupResponseData().setMemberId("").setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(currentLeader).setSkipAssignment(false).setErrorCode(GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t)).code()));
                    } else if (JoinGroupRequest.supportsSkippingAssignment((short)context.apiVersion())) {
                        boolean isLeader = group.isLeader(newMemberId);
                        group.completeJoinFuture(newMember, new JoinGroupResponseData().setMembers(isLeader ? group.currentClassicGroupMembers() : Collections.emptyList()).setMemberId(newMemberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(isLeader));
                    } else {
                        group.completeJoinFuture(newMember, new JoinGroupResponseData().setMemberId(newMemberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(currentLeader).setSkipAssignment(false));
                    }
                });
                List<CoordinatorRecord> records = Collections.singletonList(CoordinatorRecordHelpers.newGroupMetadataRecord(group, groupAssignment, this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, CoordinatorRecord>(records, appendFuture, false);
            }
            return this.maybePrepareRebalanceOrCompleteJoin(group, "Group's selectedProtocol will change because static member " + newMember.memberId() + " with instance id " + groupInstanceId + " joined with change of protocol; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request));
        }
        if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            return this.prepareRebalance(group, "Updating metadata for static member " + newMember.memberId() + " with instance id " + request.groupInstanceId() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request));
        }
        if (group.isInState(ClassicGroupState.EMPTY) || group.isInState(ClassicGroupState.DEAD)) {
            throw new IllegalStateException("Group " + group.groupId() + " was not supposed to be in the state " + group.stateAsString() + " when the unknown static member " + request.groupInstanceId() + " rejoins.");
        }
        return this.maybeCompleteJoinPhase(group);
    }

    public CoordinatorResult<Void, CoordinatorRecord> classicGroupSync(RequestContext context, SyncGroupRequestData request, CompletableFuture<SyncGroupResponseData> responseFuture) throws UnknownMemberIdException {
        Group group;
        try {
            group = this.group(request.groupId());
        }
        catch (GroupIdNotFoundException e) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
            return EMPTY_RESULT;
        }
        if (group.isEmpty()) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
            return EMPTY_RESULT;
        }
        if (group.type() == Group.GroupType.CLASSIC) {
            return this.classicGroupSyncToClassicGroup((ClassicGroup)group, context, request, responseFuture);
        }
        return this.classicGroupSyncToConsumerGroup((ConsumerGroup)group, context, request, responseFuture);
    }

    private CoordinatorResult<Void, CoordinatorRecord> classicGroupSyncToClassicGroup(ClassicGroup group, RequestContext context, SyncGroupRequestData request, CompletableFuture<SyncGroupResponseData> responseFuture) throws IllegalStateException {
        String groupId = request.groupId();
        String memberId = request.memberId();
        Optional<Errors> errorOpt = this.validateSyncGroup(group, request);
        if (errorOpt.isPresent()) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(errorOpt.get().code()));
        } else if (group.isInState(ClassicGroupState.PREPARING_REBALANCE)) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.REBALANCE_IN_PROGRESS.code()));
        } else if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            group.member(memberId).setAwaitingSyncFuture(responseFuture);
            this.removePendingSyncMember(group, request.memberId());
            if (group.isLeader(memberId)) {
                this.log.info("Assignment received from leader {} for group {} for generation {}. The group has {} members, {} of which are static.", new Object[]{memberId, groupId, group.generationId(), group.numMembers(), group.allStaticMemberIds().size()});
                HashMap<String, byte[]> assignment = new HashMap<String, byte[]>();
                request.assignments().forEach(memberAssignment -> assignment.put(memberAssignment.memberId(), memberAssignment.assignment()));
                HashMap membersWithMissingAssignment = new HashMap();
                group.allMembers().forEach(member -> {
                    if (!assignment.containsKey(member.memberId())) {
                        membersWithMissingAssignment.put(member.memberId(), ClassicGroupMember.EMPTY_ASSIGNMENT);
                    }
                });
                assignment.putAll(membersWithMissingAssignment);
                if (!membersWithMissingAssignment.isEmpty()) {
                    this.log.warn("Setting empty assignments for members {} of {} for generation {}.", new Object[]{membersWithMissingAssignment, groupId, group.generationId()});
                }
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE) && request.generationId() == group.generationId()) {
                        if (t != null) {
                            Errors error = GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t));
                            this.resetAndPropagateAssignmentWithError(group, error);
                            this.maybePrepareRebalanceOrCompleteJoin(group, "Error " + error + " when storing group assignmentduring SyncGroup (member: " + memberId + ").");
                        } else {
                            this.setAndPropagateAssignment(group, assignment);
                            group.transitionTo(ClassicGroupState.STABLE);
                            this.metrics.record("CompletedRebalances");
                        }
                    }
                });
                List<CoordinatorRecord> records = Collections.singletonList(CoordinatorRecordHelpers.newGroupMetadataRecord(group, assignment, this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, CoordinatorRecord>(records, appendFuture, false);
            }
        } else if (group.isInState(ClassicGroupState.STABLE)) {
            this.removePendingSyncMember(group, memberId);
            ClassicGroupMember member2 = group.member(memberId);
            responseFuture.complete(new SyncGroupResponseData().setProtocolType((String)group.protocolType().orElse(null)).setProtocolName((String)group.protocolName().orElse(null)).setAssignment(member2.assignment()).setErrorCode(Errors.NONE.code()));
        } else if (group.isInState(ClassicGroupState.DEAD)) {
            throw new IllegalStateException("Reached unexpected condition for Dead group " + groupId);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, CoordinatorRecord> classicGroupSyncToConsumerGroup(ConsumerGroup group, RequestContext context, SyncGroupRequestData request, CompletableFuture<SyncGroupResponseData> responseFuture) throws UnknownMemberIdException, FencedInstanceIdException, IllegalGenerationException, InconsistentGroupProtocolException, RebalanceInProgressException, IllegalStateException {
        String groupId = request.groupId();
        String memberId = request.memberId();
        String instanceId = request.groupInstanceId();
        ConsumerGroupMember member = this.validateConsumerGroupMember(group, memberId, instanceId);
        this.throwIfMemberDoesNotUseClassicProtocol(member);
        this.throwIfGenerationIdUnmatched(member.memberId(), member.memberEpoch(), request.generationId());
        this.throwIfClassicProtocolUnmatched(member, request.protocolType(), request.protocolName());
        this.throwIfRebalanceInProgress(group, member);
        CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
        appendFuture.whenComplete((__, t) -> {
            if (t == null) {
                this.cancelConsumerGroupSyncTimeout(groupId, memberId);
                this.scheduleConsumerGroupSessionTimeout(groupId, memberId, member.classicProtocolSessionTimeout().get());
                responseFuture.complete(new SyncGroupResponseData().setProtocolType(request.protocolType()).setProtocolName(request.protocolName()).setAssignment(this.prepareAssignment(member)));
            }
        });
        return new CoordinatorResult<Void, CoordinatorRecord>(Collections.emptyList(), appendFuture, false);
    }

    private byte[] prepareAssignment(ConsumerGroupMember member) {
        try {
            return ConsumerProtocol.serializeAssignment((ConsumerProtocolAssignment)Utils.toConsumerProtocolAssignment(member.assignedPartitions(), this.metadataImage.topics()), (short)ConsumerProtocol.deserializeVersion((ByteBuffer)ByteBuffer.wrap(member.classicMemberMetadata().get().supportedProtocols().iterator().next().metadata()))).array();
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Malformed embedded consumer protocol in version deserialization.");
        }
    }

    static Errors appendGroupMetadataErrorToResponseError(Errors appendError) {
        switch (appendError) {
            case UNKNOWN_TOPIC_OR_PARTITION: 
            case NOT_ENOUGH_REPLICAS: 
            case REQUEST_TIMED_OUT: {
                return Errors.COORDINATOR_NOT_AVAILABLE;
            }
            case NOT_LEADER_OR_FOLLOWER: 
            case KAFKA_STORAGE_ERROR: {
                return Errors.NOT_COORDINATOR;
            }
            case MESSAGE_TOO_LARGE: 
            case RECORD_LIST_TOO_LARGE: 
            case INVALID_FETCH_SIZE: {
                return Errors.UNKNOWN_SERVER_ERROR;
            }
        }
        return appendError;
    }

    private Optional<Errors> validateSyncGroup(ClassicGroup group, SyncGroupRequestData request) {
        if (group.isInState(ClassicGroupState.DEAD)) {
            return Optional.of(Errors.COORDINATOR_NOT_AVAILABLE);
        }
        try {
            group.validateMember(request.memberId(), request.groupInstanceId(), "sync-group");
        }
        catch (KafkaException ex) {
            return Optional.of(Errors.forException((Throwable)ex));
        }
        if (request.generationId() != group.generationId()) {
            return Optional.of(Errors.ILLEGAL_GENERATION);
        }
        if (this.isProtocolInconsistent(request.protocolType(), group.protocolType().orElse(null)) || this.isProtocolInconsistent(request.protocolName(), group.protocolName().orElse(null))) {
            return Optional.of(Errors.INCONSISTENT_GROUP_PROTOCOL);
        }
        return Optional.empty();
    }

    private void removePendingSyncMember(ClassicGroup group, String memberId) {
        group.removePendingSyncMember(memberId);
        String syncKey = GroupMetadataManager.classicGroupSyncKey(group.groupId());
        switch (group.currentState()) {
            case EMPTY: 
            case DEAD: 
            case PREPARING_REBALANCE: {
                this.timer.cancel(syncKey);
                break;
            }
            case COMPLETING_REBALANCE: 
            case STABLE: {
                if (!group.hasReceivedSyncFromAllMembers()) break;
                this.timer.cancel(syncKey);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown group state: " + group.stateAsString());
            }
        }
    }

    public CoordinatorResult<HeartbeatResponseData, CoordinatorRecord> classicGroupHeartbeat(RequestContext context, HeartbeatRequestData request) {
        Group group;
        try {
            group = this.group(request.groupId());
        }
        catch (GroupIdNotFoundException e) {
            throw new UnknownMemberIdException(String.format("Group %s not found.", request.groupId()));
        }
        if (group.type() == Group.GroupType.CLASSIC) {
            return this.classicGroupHeartbeatToClassicGroup((ClassicGroup)group, context, request);
        }
        return this.classicGroupHeartbeatToConsumerGroup((ConsumerGroup)group, context, request);
    }

    private CoordinatorResult<HeartbeatResponseData, CoordinatorRecord> classicGroupHeartbeatToClassicGroup(ClassicGroup group, RequestContext context, HeartbeatRequestData request) {
        this.validateClassicGroupHeartbeat(group, request.memberId(), request.groupInstanceId(), request.generationId());
        switch (group.currentState()) {
            case EMPTY: {
                return new CoordinatorResult<HeartbeatResponseData, CoordinatorRecord>(Collections.emptyList(), new HeartbeatResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
            }
            case PREPARING_REBALANCE: {
                this.rescheduleClassicGroupMemberHeartbeat(group, group.member(request.memberId()));
                return new CoordinatorResult<HeartbeatResponseData, CoordinatorRecord>(Collections.emptyList(), new HeartbeatResponseData().setErrorCode(Errors.REBALANCE_IN_PROGRESS.code()));
            }
            case COMPLETING_REBALANCE: 
            case STABLE: {
                this.rescheduleClassicGroupMemberHeartbeat(group, group.member(request.memberId()));
                return new CoordinatorResult<HeartbeatResponseData, CoordinatorRecord>(Collections.emptyList(), new HeartbeatResponseData());
            }
        }
        throw new IllegalStateException("Reached unexpected state " + (Object)((Object)group.currentState()) + " for group " + group.groupId());
    }

    private void validateClassicGroupHeartbeat(ClassicGroup group, String memberId, String groupInstanceId, int generationId) throws CoordinatorNotAvailableException, IllegalGenerationException {
        if (group.isInState(ClassicGroupState.DEAD)) {
            throw Errors.COORDINATOR_NOT_AVAILABLE.exception();
        }
        group.validateMember(memberId, groupInstanceId, "heartbeat");
        if (generationId != group.generationId()) {
            throw Errors.ILLEGAL_GENERATION.exception();
        }
    }

    private CoordinatorResult<HeartbeatResponseData, CoordinatorRecord> classicGroupHeartbeatToConsumerGroup(ConsumerGroup group, RequestContext context, HeartbeatRequestData request) throws UnknownMemberIdException, FencedInstanceIdException, IllegalGenerationException {
        String groupId = request.groupId();
        String memberId = request.memberId();
        String instanceId = request.groupInstanceId();
        ConsumerGroupMember member = this.validateConsumerGroupMember(group, memberId, instanceId);
        this.throwIfMemberDoesNotUseClassicProtocol(member);
        this.throwIfGenerationIdUnmatched(memberId, member.memberEpoch(), request.generationId());
        this.scheduleConsumerGroupSessionTimeout(groupId, memberId, member.classicProtocolSessionTimeout().get());
        Errors error = Errors.NONE;
        if (member.memberEpoch() < group.groupEpoch() || member.state() == MemberState.UNREVOKED_PARTITIONS || member.state() == MemberState.UNRELEASED_PARTITIONS && !group.waitingOnUnreleasedPartition(member)) {
            error = Errors.REBALANCE_IN_PROGRESS;
            this.scheduleConsumerGroupJoinTimeoutIfAbsent(groupId, memberId, member.rebalanceTimeoutMs());
        }
        return new CoordinatorResult<HeartbeatResponseData, CoordinatorRecord>(Collections.emptyList(), new HeartbeatResponseData().setErrorCode(error.code()));
    }

    private ConsumerGroupMember validateConsumerGroupMember(ConsumerGroup group, String memberId, String instanceId) throws UnknownMemberIdException, FencedInstanceIdException {
        ConsumerGroupMember member;
        if (instanceId == null) {
            member = group.getOrMaybeCreateMember(memberId, false);
        } else {
            member = group.staticMember(instanceId);
            if (member == null) {
                throw new UnknownMemberIdException(String.format("Member with instance id %s is not a member of group %s.", instanceId, group.groupId()));
            }
            this.throwIfInstanceIdIsFenced(member, group.groupId(), memberId, instanceId);
        }
        return member;
    }

    public CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> classicGroupLeave(RequestContext context, LeaveGroupRequestData request) throws UnknownMemberIdException {
        Group group;
        try {
            group = this.group(request.groupId());
        }
        catch (GroupIdNotFoundException e) {
            throw new UnknownMemberIdException(String.format("Group %s not found.", request.groupId()));
        }
        if (group.type() == Group.GroupType.CLASSIC) {
            return this.classicGroupLeaveToClassicGroup((ClassicGroup)group, context, request);
        }
        return this.classicGroupLeaveToConsumerGroup((ConsumerGroup)group, context, request);
    }

    private CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> classicGroupLeaveToConsumerGroup(ConsumerGroup group, RequestContext context, LeaveGroupRequestData request) throws UnknownMemberIdException {
        String groupId = group.groupId();
        ArrayList<LeaveGroupResponseData.MemberResponse> memberResponses = new ArrayList<LeaveGroupResponseData.MemberResponse>();
        HashSet<ConsumerGroupMember> validLeaveGroupMembers = new HashSet<ConsumerGroupMember>();
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        for (LeaveGroupRequestData.MemberIdentity memberIdentity : request.members()) {
            String memberId = memberIdentity.memberId();
            String instanceId = memberIdentity.groupInstanceId();
            String reason = memberIdentity.reason() != null ? memberIdentity.reason() : "not provided";
            try {
                ConsumerGroupMember member;
                if (instanceId == null) {
                    member = group.getOrMaybeCreateMember(memberId, false);
                    this.throwIfMemberDoesNotUseClassicProtocol(member);
                    this.log.info("[Group {}] Dynamic Member {} has left group through explicit `LeaveGroup` request; client reason: {}", new Object[]{groupId, memberId, reason});
                } else {
                    member = group.staticMember(instanceId);
                    this.throwIfStaticMemberIsUnknown(member, instanceId);
                    if (!"".equals(memberId)) {
                        this.throwIfInstanceIdIsFenced(member, groupId, memberId, instanceId);
                    }
                    this.throwIfMemberDoesNotUseClassicProtocol(member);
                    memberId = member.memberId();
                    this.log.info("[Group {}] Static Member {} with instance id {} has left group through explicit `LeaveGroup` request; client reason: {}", new Object[]{groupId, memberId, instanceId, reason});
                }
                this.removeMember(records, groupId, memberId);
                this.cancelTimers(groupId, memberId);
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(memberId).setGroupInstanceId(instanceId));
                validLeaveGroupMembers.add(member);
            }
            catch (KafkaException e) {
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(memberId).setGroupInstanceId(instanceId).setErrorCode(Errors.forException((Throwable)e).code()));
            }
        }
        if (!records.isEmpty()) {
            Map<String, TopicMetadata> subscriptionMetadata = group.computeSubscriptionMetadata(group.computeSubscribedTopicNames(validLeaveGroupMembers), this.metadataImage.topics(), this.metadataImage.cluster());
            if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
                this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)group.groupId(), subscriptionMetadata);
                records.add(CoordinatorRecordHelpers.newGroupSubscriptionMetadataRecord(group.groupId(), subscriptionMetadata));
            }
            records.add(CoordinatorRecordHelpers.newGroupEpochRecord(groupId, group.groupEpoch() + 1));
        }
        return new CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord>(records, new LeaveGroupResponseData().setMembers(memberResponses));
    }

    private CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> classicGroupLeaveToClassicGroup(ClassicGroup group, RequestContext context, LeaveGroupRequestData request) throws UnknownMemberIdException {
        if (group.isInState(ClassicGroupState.DEAD)) {
            return new CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord>(Collections.emptyList(), new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        ArrayList<LeaveGroupResponseData.MemberResponse> memberResponses = new ArrayList<LeaveGroupResponseData.MemberResponse>();
        for (LeaveGroupRequestData.MemberIdentity member : request.members()) {
            String reason;
            String string = reason = member.reason() != null ? member.reason() : "not provided";
            if ("".equals(member.memberId())) {
                if (member.groupInstanceId() != null && group.hasStaticMember(member.groupInstanceId())) {
                    this.removeCurrentMemberFromClassicGroup(group, group.staticMemberId(member.groupInstanceId()), reason);
                    memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()));
                    continue;
                }
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
                continue;
            }
            if (group.isPendingMember(member.memberId())) {
                group.remove(member.memberId());
                this.timer.cancel(GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), member.memberId()));
                this.log.info("[Group {}] Pending member {} has left group through explicit `LeaveGroup` request; client reason: {}", new Object[]{group.groupId(), member.memberId(), reason});
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()));
                continue;
            }
            try {
                group.validateMember(member.memberId(), member.groupInstanceId(), "leave-group");
                this.removeCurrentMemberFromClassicGroup(group, member.memberId(), reason);
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()));
            }
            catch (KafkaException e) {
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()).setErrorCode(Errors.forException((Throwable)e).code()));
            }
        }
        List validLeaveGroupMembers = memberResponses.stream().filter(response -> response.errorCode() == Errors.NONE.code()).map(LeaveGroupResponseData.MemberResponse::memberId).collect(Collectors.toList());
        String reason = "explicit `LeaveGroup` request for (" + String.join((CharSequence)", ", validLeaveGroupMembers) + ") members.";
        CoordinatorResult<Void, CoordinatorRecord> coordinatorResult = EMPTY_RESULT;
        if (!validLeaveGroupMembers.isEmpty()) {
            switch (group.currentState()) {
                case COMPLETING_REBALANCE: 
                case STABLE: {
                    coordinatorResult = this.maybePrepareRebalanceOrCompleteJoin(group, reason);
                    break;
                }
                case PREPARING_REBALANCE: {
                    coordinatorResult = this.maybeCompleteJoinPhase(group);
                    break;
                }
            }
        }
        return new CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord>(coordinatorResult.records(), new LeaveGroupResponseData().setMembers(memberResponses), coordinatorResult.appendFuture(), coordinatorResult.replayRecords());
    }

    private void removeCurrentMemberFromClassicGroup(ClassicGroup group, String memberId, String reason) {
        ClassicGroupMember member = group.member(memberId);
        this.timer.cancel(GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), memberId));
        this.log.info("[Group {}] Member {} has left group through explicit `LeaveGroup` request; client reason: {}", new Object[]{group.groupId(), memberId, reason});
        group.completeJoinFuture(member, new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        group.remove(member.memberId());
    }

    public void createGroupTombstoneRecords(String groupId, List<CoordinatorRecord> records) {
        this.createGroupTombstoneRecords(this.group(groupId), records);
    }

    public void createGroupTombstoneRecords(Group group, List<CoordinatorRecord> records) {
        group.createGroupTombstoneRecords(records);
    }

    void validateDeleteGroup(String groupId) throws ApiException {
        Group group = this.group(groupId);
        group.validateDeleteGroup();
    }

    public void maybeDeleteGroup(String groupId, List<CoordinatorRecord> records) {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group != null && group.isEmpty()) {
            this.createGroupTombstoneRecords(groupId, records);
        }
    }

    private static boolean isEmptyClassicGroup(Group group) {
        return group != null && group.type() == Group.GroupType.CLASSIC && group.isEmpty();
    }

    private static boolean isEmptyConsumerGroup(Group group) {
        return group != null && group.type() == Group.GroupType.CONSUMER && group.isEmpty();
    }

    private boolean maybeDeleteEmptyClassicGroup(Group group, List<CoordinatorRecord> records) {
        if (GroupMetadataManager.isEmptyClassicGroup(group)) {
            if (group != null) {
                this.createGroupTombstoneRecords(group, records);
            }
            return true;
        }
        return false;
    }

    private void maybeDeleteEmptyConsumerGroup(String groupId, List<CoordinatorRecord> records) {
        Group group = (Group)this.groups.get((Object)groupId, Long.MAX_VALUE);
        if (GroupMetadataManager.isEmptyConsumerGroup(group)) {
            this.createGroupTombstoneRecords(group, records);
            this.removeGroup(groupId);
        }
    }

    private boolean isProtocolInconsistent(String protocolTypeOrName, String groupProtocolTypeOrName) {
        return protocolTypeOrName != null && groupProtocolTypeOrName != null && !groupProtocolTypeOrName.equals(protocolTypeOrName);
    }

    public Set<String> groupIds() {
        return Collections.unmodifiableSet(this.groups.keySet());
    }

    static String classicGroupHeartbeatKey(String groupId, String memberId) {
        return "heartbeat-" + groupId + "-" + memberId;
    }

    static String classicGroupJoinKey(String groupId) {
        return "join-" + groupId;
    }

    static String classicGroupSyncKey(String groupId) {
        return "sync-" + groupId;
    }

    static String consumerGroupJoinKey(String groupId, String memberId) {
        return "join-" + groupId + "-" + memberId;
    }

    static String consumerGroupSyncKey(String groupId, String memberId) {
        return "sync-" + groupId + "-" + memberId;
    }

    public static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private Time time = null;
        private CoordinatorTimer<Void, CoordinatorRecord> timer = null;
        private List<ConsumerGroupPartitionAssignor> consumerGroupAssignors = null;
        private int consumerGroupMaxSize = Integer.MAX_VALUE;
        private int consumerGroupHeartbeatIntervalMs = 5000;
        private int consumerGroupMetadataRefreshIntervalMs = Integer.MAX_VALUE;
        private MetadataImage metadataImage = null;
        private int consumerGroupSessionTimeoutMs = 45000;
        private int classicGroupMaxSize = Integer.MAX_VALUE;
        private int classicGroupInitialRebalanceDelayMs = 3000;
        private int classicGroupNewMemberJoinTimeoutMs = 300000;
        private int classicGroupMinSessionTimeoutMs;
        private int classicGroupMaxSessionTimeoutMs;
        private ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy;
        private ShareGroupPartitionAssignor shareGroupAssignor = null;
        private int shareGroupMaxSize = Integer.MAX_VALUE;
        private int shareGroupHeartbeatIntervalMs = 5000;
        private int shareGroupSessionTimeoutMs = 45000;
        private int shareGroupMetadataRefreshIntervalMs = Integer.MAX_VALUE;
        private GroupCoordinatorMetricsShard metrics;

        Builder withLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder withSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder withTime(Time time) {
            this.time = time;
            return this;
        }

        Builder withTimer(CoordinatorTimer<Void, CoordinatorRecord> timer) {
            this.timer = timer;
            return this;
        }

        Builder withConsumerGroupAssignors(List<ConsumerGroupPartitionAssignor> consumerGroupAssignors) {
            this.consumerGroupAssignors = consumerGroupAssignors;
            return this;
        }

        Builder withConsumerGroupMaxSize(int consumerGroupMaxSize) {
            this.consumerGroupMaxSize = consumerGroupMaxSize;
            return this;
        }

        Builder withConsumerGroupSessionTimeout(int consumerGroupSessionTimeoutMs) {
            this.consumerGroupSessionTimeoutMs = consumerGroupSessionTimeoutMs;
            return this;
        }

        Builder withConsumerGroupHeartbeatInterval(int consumerGroupHeartbeatIntervalMs) {
            this.consumerGroupHeartbeatIntervalMs = consumerGroupHeartbeatIntervalMs;
            return this;
        }

        Builder withConsumerGroupMetadataRefreshIntervalMs(int consumerGroupMetadataRefreshIntervalMs) {
            this.consumerGroupMetadataRefreshIntervalMs = consumerGroupMetadataRefreshIntervalMs;
            return this;
        }

        Builder withMetadataImage(MetadataImage metadataImage) {
            this.metadataImage = metadataImage;
            return this;
        }

        Builder withClassicGroupMaxSize(int classicGroupMaxSize) {
            this.classicGroupMaxSize = classicGroupMaxSize;
            return this;
        }

        Builder withClassicGroupInitialRebalanceDelayMs(int classicGroupInitialRebalanceDelayMs) {
            this.classicGroupInitialRebalanceDelayMs = classicGroupInitialRebalanceDelayMs;
            return this;
        }

        Builder withClassicGroupNewMemberJoinTimeoutMs(int classicGroupNewMemberJoinTimeoutMs) {
            this.classicGroupNewMemberJoinTimeoutMs = classicGroupNewMemberJoinTimeoutMs;
            return this;
        }

        Builder withClassicGroupMinSessionTimeoutMs(int classicGroupMinSessionTimeoutMs) {
            this.classicGroupMinSessionTimeoutMs = classicGroupMinSessionTimeoutMs;
            return this;
        }

        Builder withClassicGroupMaxSessionTimeoutMs(int classicGroupMaxSessionTimeoutMs) {
            this.classicGroupMaxSessionTimeoutMs = classicGroupMaxSessionTimeoutMs;
            return this;
        }

        Builder withConsumerGroupMigrationPolicy(ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy) {
            this.consumerGroupMigrationPolicy = consumerGroupMigrationPolicy;
            return this;
        }

        Builder withGroupCoordinatorMetricsShard(GroupCoordinatorMetricsShard metrics) {
            this.metrics = metrics;
            return this;
        }

        Builder withShareGroupAssignor(ShareGroupPartitionAssignor shareGroupAssignor) {
            this.shareGroupAssignor = shareGroupAssignor;
            return this;
        }

        public Builder withShareGroupMaxSize(int shareGroupMaxSize) {
            this.shareGroupMaxSize = shareGroupMaxSize;
            return this;
        }

        Builder withShareGroupSessionTimeout(int shareGroupSessionTimeoutMs) {
            this.shareGroupSessionTimeoutMs = shareGroupSessionTimeoutMs;
            return this;
        }

        Builder withShareGroupHeartbeatInterval(int shareGroupHeartbeatIntervalMs) {
            this.shareGroupHeartbeatIntervalMs = shareGroupHeartbeatIntervalMs;
            return this;
        }

        Builder withShareGroupMetadataRefreshIntervalMs(int shareGroupMetadataRefreshIntervalMs) {
            this.shareGroupMetadataRefreshIntervalMs = shareGroupMetadataRefreshIntervalMs;
            return this;
        }

        GroupMetadataManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.metadataImage == null) {
                this.metadataImage = MetadataImage.EMPTY;
            }
            if (this.time == null) {
                this.time = Time.SYSTEM;
            }
            if (this.timer == null) {
                throw new IllegalArgumentException("Timer must be set.");
            }
            if (this.consumerGroupAssignors == null || this.consumerGroupAssignors.isEmpty()) {
                throw new IllegalArgumentException("Assignors must be set before building.");
            }
            if (this.shareGroupAssignor == null) {
                this.shareGroupAssignor = new SimpleAssignor();
            }
            if (this.metrics == null) {
                throw new IllegalArgumentException("GroupCoordinatorMetricsShard must be set.");
            }
            return new GroupMetadataManager(this.snapshotRegistry, this.logContext, this.time, this.timer, this.metrics, this.consumerGroupAssignors, this.metadataImage, this.consumerGroupMaxSize, this.consumerGroupSessionTimeoutMs, this.consumerGroupHeartbeatIntervalMs, this.consumerGroupMetadataRefreshIntervalMs, this.classicGroupMaxSize, this.classicGroupInitialRebalanceDelayMs, this.classicGroupNewMemberJoinTimeoutMs, this.classicGroupMinSessionTimeoutMs, this.classicGroupMaxSessionTimeoutMs, this.consumerGroupMigrationPolicy, this.shareGroupAssignor, this.shareGroupMaxSize, this.shareGroupSessionTimeoutMs, this.shareGroupHeartbeatIntervalMs, this.shareGroupMetadataRefreshIntervalMs);
        }
    }
}

