/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.juneau.commons.io.ReaderInputStream;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;

public class StringEntity
extends BasicHttpEntity {
    private static final String EMPTY = "";
    private byte[] byteCache;

    public StringEntity() {
    }

    public StringEntity(ContentType contentType, String content) {
        super(contentType, content);
    }

    protected StringEntity(StringEntity copyFrom) {
        super(copyFrom);
    }

    @Override
    public byte[] asBytes() throws IOException {
        if (this.isCached() && this.byteCache == null) {
            this.byteCache = this.content().getBytes(this.getCharset());
        }
        if (Utils.nn(this.byteCache)) {
            return this.byteCache;
        }
        return this.content().getBytes(this.getCharset());
    }

    @Override
    public String asString() throws IOException {
        return this.content();
    }

    @Override
    public StringEntity copy() {
        return new StringEntity(this);
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.isCached()) {
            return new ByteArrayInputStream(this.asBytes());
        }
        return new ReaderInputStream((Reader)new StringReader(this.content()), this.getCharset());
    }

    @Override
    public long getContentLength() {
        if (this.isCached()) {
            return this.asSafeBytes().length;
        }
        long l = super.getContentLength();
        if (l != -1L || this.isSupplied()) {
            return l;
        }
        String s = this.content();
        if (this.getCharset() == IoUtils.UTF8) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                return -1L;
            }
        }
        return s.length();
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public StringEntity setCached() throws IOException {
        super.setCached();
        return this;
    }

    @Override
    public StringEntity setCharset(Charset value) {
        super.setCharset(value);
        return this;
    }

    @Override
    public StringEntity setChunked() {
        super.setChunked();
        return this;
    }

    @Override
    public StringEntity setChunked(boolean value) {
        super.setChunked(value);
        return this;
    }

    @Override
    public StringEntity setContent(Object value) {
        super.setContent(value);
        return this;
    }

    @Override
    public StringEntity setContent(Supplier<?> value) {
        super.setContent(value);
        return this;
    }

    @Override
    public StringEntity setContentEncoding(ContentEncoding value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public StringEntity setContentEncoding(String value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public StringEntity setContentLength(long value) {
        super.setContentLength(value);
        return this;
    }

    @Override
    public StringEntity setContentType(ContentType value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public StringEntity setContentType(String value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public StringEntity setMaxLength(int value) {
        super.setMaxLength(value);
        return this;
    }

    @Override
    public StringEntity setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        AssertionUtils.assertArgNotNull("out", out);
        if (this.isCached()) {
            out.write(this.asBytes());
        } else {
            OutputStreamWriter osw = new OutputStreamWriter(out, this.getCharset());
            osw.write(this.content());
            osw.flush();
        }
    }

    private String content() {
        return this.contentOrElse(EMPTY);
    }
}

