/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import org.apache.juneau.annotation.ExternalDocs;
import org.apache.juneau.annotation.ExternalDocsAnnotation;
import org.apache.juneau.commons.annotation.AnnotationObject;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.http.annotation.Contact;
import org.apache.juneau.http.annotation.ContactAnnotation;
import org.apache.juneau.http.annotation.License;
import org.apache.juneau.http.annotation.LicenseAnnotation;
import org.apache.juneau.http.annotation.Tag;
import org.apache.juneau.rest.annotation.Swagger;

public class SwaggerAnnotation {
    public static final Swagger DEFAULT = SwaggerAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(Swagger a) {
        return a == null || DEFAULT.equals(a);
    }

    public static class Builder
    extends AnnotationObject.Builder {
        private String[] description = new String[0];
        private Contact contact = ContactAnnotation.DEFAULT;
        private ExternalDocs externalDocs = ExternalDocsAnnotation.DEFAULT;
        private License license = LicenseAnnotation.DEFAULT;
        private String version = "";
        private String[] termsOfService = new String[0];
        private String[] title = new String[0];
        private String[] value = new String[0];
        private Tag[] tags = new Tag[0];

        protected Builder() {
            super(Swagger.class);
        }

        public Swagger build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder contact(Contact value) {
            this.contact = value;
            return this;
        }

        public Builder externalDocs(ExternalDocs value) {
            this.externalDocs = value;
            return this;
        }

        public Builder license(License value) {
            this.license = value;
            return this;
        }

        public Builder tags(Tag ... value) {
            this.tags = value;
            return this;
        }

        public Builder termsOfService(String ... value) {
            this.termsOfService = value;
            return this;
        }

        public Builder title(String ... value) {
            this.title = value;
            return this;
        }

        public Builder value(String ... value) {
            this.value = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }
    }

    private static class Object
    extends AnnotationObject
    implements Swagger {
        private final String[] description;
        private final Contact contact;
        private final ExternalDocs externalDocs;
        private final License license;
        private final String version;
        private final String[] termsOfService;
        private final String[] title;
        private final String[] value;
        private final Tag[] tags;

        Object(Builder b) {
            super((AnnotationObject.Builder)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.contact = b.contact;
            this.externalDocs = b.externalDocs;
            this.license = b.license;
            this.tags = (Tag[])CollectionUtils.copyOf((java.lang.Object[])b.tags);
            this.termsOfService = (String[])CollectionUtils.copyOf((java.lang.Object[])b.termsOfService);
            this.title = (String[])CollectionUtils.copyOf((java.lang.Object[])b.title);
            this.value = (String[])CollectionUtils.copyOf((java.lang.Object[])b.value);
            this.version = b.version;
        }

        @Override
        public Contact contact() {
            return this.contact;
        }

        @Override
        public ExternalDocs externalDocs() {
            return this.externalDocs;
        }

        @Override
        public License license() {
            return this.license;
        }

        @Override
        public Tag[] tags() {
            return this.tags;
        }

        @Override
        public String[] termsOfService() {
            return this.termsOfService;
        }

        @Override
        public String[] title() {
            return this.title;
        }

        @Override
        public String[] value() {
            return this.value;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }
}

