/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.BuiltinException;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class Regex
extends BaseBuiltin {
    @Override
    public String getName() {
        return "regex";
    }

    @Override
    public int getArgLength() {
        return 0;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context2) {
        if (length < 2) {
            throw new BuiltinException(this, context2, "Must have at least 2 arguments to " + this.getName());
        }
        String text = this.getString(this.getArg(0, args, context2), context2);
        String pattern = this.getString(this.getArg(1, args, context2), context2);
        Matcher m = Pattern.compile(pattern).matcher(text);
        if (!m.matches()) {
            return false;
        }
        if (length > 2) {
            BindingEnvironment env = context2.getEnv();
            for (int i = 0; i < Math.min(length - 2, m.groupCount()); ++i) {
                Node match;
                String gm = m.group(i + 1);
                Node node = match = gm != null ? NodeFactory.createLiteralString(gm) : NodeFactory.createLiteralString("");
                if (env.bind(args[i + 2], match)) continue;
                return false;
            }
        }
        return true;
    }

    protected String getString(Node n, RuleContext context2) {
        if (n.isLiteral()) {
            return n.getLiteralLexicalForm();
        }
        throw new BuiltinException(this, context2, this.getName() + " takes only literal arguments");
    }
}

