/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.objenesis.instantiator.basic;

import com.esotericsoftware.kryo.kryo5.objenesis.ObjenesisException;
import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.ObjectInstantiator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class DelegatingToExoticInstantiator<T>
implements ObjectInstantiator<T> {
    private final ObjectInstantiator<T> wrapped;

    protected DelegatingToExoticInstantiator(String className, Class<T> type) {
        Class<ObjectInstantiator<T>> clazz = this.instantiatorClass(className);
        Constructor<ObjectInstantiator<T>> constructor = this.instantiatorConstructor(className, clazz);
        this.wrapped = this.instantiator(className, type, constructor);
    }

    private ObjectInstantiator<T> instantiator(String className, Class<T> type, Constructor<ObjectInstantiator<T>> constructor) {
        try {
            return constructor.newInstance(type);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e2) {
            throw new RuntimeException("Failed to call constructor of " + className, e2);
        }
    }

    private Class<ObjectInstantiator<T>> instantiatorClass(String className) {
        try {
            Class<ObjectInstantiator<T>> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e2) {
            throw new ObjenesisException(this.getClass().getSimpleName() + " now requires objenesis-exotic to be in the classpath", e2);
        }
    }

    private Constructor<ObjectInstantiator<T>> instantiatorConstructor(String className, Class<ObjectInstantiator<T>> clazz) {
        try {
            return clazz.getConstructor(Class.class);
        }
        catch (NoSuchMethodException e2) {
            throw new ObjenesisException("Try to find constructor taking a Class<T> in parameter on " + className + " but can't find it", e2);
        }
    }

    @Override
    public T newInstance() {
        return this.wrapped.newInstance();
    }
}

