/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.scripting;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.scripting.RDFJS;

public class NV
implements RDFJS {
    private NodeValue nv;
    private static final boolean narrowDoubles = true;

    public static Object fromNodeValue(NodeValue nv) {
        if (nv == null) {
            return null;
        }
        if (nv.isString()) {
            return nv.getString();
        }
        if (nv.isNumber()) {
            if (nv.isInteger()) {
                return nv.getInteger().longValue();
            }
            if (nv.isDecimal()) {
                return nv.getDecimal().doubleValue();
            }
            if (nv.isDouble()) {
                return nv.getDouble();
            }
        }
        if (nv.isBoolean()) {
            return nv.getBoolean();
        }
        return new NV(nv);
    }

    public static NodeValue toNodeValue(Object r) {
        if (r == null) {
            return null;
        }
        if (r instanceof NV) {
            return ((NV)r).nv();
        }
        if (r instanceof NodeValue) {
            return (NodeValue)r;
        }
        if (r instanceof CharSequence) {
            return NodeValue.makeString(((CharSequence)r).toString());
        }
        if (r instanceof Number) {
            return NV.number2value((Number)r);
        }
        if (r instanceof Boolean) {
            return NodeValue.makeBoolean((Boolean)r);
        }
        if (r instanceof URI) {
            Node n = NodeFactory.createURI((String)((URI)r).toString());
            return NodeValue.makeNode(n);
        }
        throw new ExprEvalException("Can't convert '" + String.valueOf(r) + "' to a NodeValue.  r is of class " + r.getClass().getName());
    }

    static NodeValue number2value(Number r) {
        if (r instanceof Integer) {
            return NodeValue.makeInteger(((Integer)r).intValue());
        }
        if (r instanceof Long) {
            return NodeValue.makeInteger((Long)r);
        }
        if (r instanceof Double) {
            double d = (Double)r;
            if (Double.isFinite(d)) {
                try {
                    long x = (long)d;
                    if ((double)x == d) {
                        return NodeValue.makeInteger(x);
                    }
                    if (d == Math.floor(d) && Double.isFinite(d)) {
                        BigInteger big = new BigDecimal(d).toBigInteger();
                        return NodeValue.makeInteger(big);
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ExprEvalException("Bad number format", ex);
                }
            }
            return NodeValue.makeDouble(d);
        }
        if (r instanceof BigInteger) {
            return NodeValue.makeInteger((BigInteger)r);
        }
        if (r instanceof BigDecimal) {
            return NodeValue.makeDecimal((BigDecimal)r);
        }
        throw new ExprEvalException("Unknown return type for number: " + String.valueOf(r));
    }

    public boolean isURI() {
        return this.nv.isIRI();
    }

    public boolean isBlank() {
        return this.nv.isBlank();
    }

    public boolean isNumber() {
        return this.nv.isNumber();
    }

    public boolean isLiteral() {
        return this.nv.isLiteral();
    }

    public boolean isTripleTerm() {
        return this.nv.isTripleTerm();
    }

    @Override
    public String getTermType() {
        if (this.isURI()) {
            return "NamedNode";
        }
        if (this.isBlank()) {
            return "BlankNode";
        }
        if (this.isLiteral()) {
            return "Literal";
        }
        if (this.isTripleTerm()) {
            return "Triple";
        }
        return null;
    }

    @Override
    public String getValue() {
        if (this.isURI()) {
            return this.getUri();
        }
        if (this.isBlank()) {
            return this.getLabel();
        }
        if (this.isLiteral()) {
            return this.getLex();
        }
        if (this.isTripleTerm()) {
            return this.nv.asString();
        }
        return null;
    }

    public String getLabel() {
        return this.nv.asNode().getBlankNodeLabel();
    }

    public String getDT() {
        return this.nv.getDatatypeURI();
    }

    public String getDatatype() {
        return this.nv.getDatatypeURI();
    }

    public String getLanguage() {
        return this.nv.getLang();
    }

    public String getLang() {
        return this.nv.getLang().toLowerCase();
    }

    public String getLex() {
        return this.nv.getNode().getLiteralLexicalForm();
    }

    public String getUri() {
        return this.nv.getNode().getURI();
    }

    public NV(NodeValue nv) {
        this.nv = nv;
    }

    public NodeValue nv() {
        return this.nv;
    }

    public String toString() {
        return this.nv.asUnquotedString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nv == null ? 0 : this.nv.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NV other = (NV)obj;
        return !(this.nv == null ? other.nv != null : !this.nv.equals(other.nv));
    }
}

