/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.metrics;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.storageengine.load.metrics.ActiveLoadingFilesMetricsSet;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class ActiveLoadingFilesNumberMetricsSet
extends ActiveLoadingFilesMetricsSet {
    private static final String PENDING = "pending";
    private static final String QUEUING = "queuing";
    private static final String LOADING = "loading";
    private Counter queuingFileCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter loadingFileCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private static final ActiveLoadingFilesNumberMetricsSet INSTANCE = new ActiveLoadingFilesNumberMetricsSet();

    public void increaseQueuingFileCounter(long number) {
        this.queuingFileCounter.inc(number);
    }

    public void increaseLoadingFileCounter(long number) {
        this.loadingFileCounter.inc(number);
    }

    @Override
    protected void bindOtherCounters(AbstractMetricService metricService) {
        this.totalPendingFileCounter = metricService.getOrCreateCounter(Metric.ACTIVE_LOADING_FILES_NUMBER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), PENDING});
        this.queuingFileCounter = metricService.getOrCreateCounter(Metric.ACTIVE_LOADING_FILES_NUMBER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), QUEUING});
        this.loadingFileCounter = metricService.getOrCreateCounter(Metric.ACTIVE_LOADING_FILES_NUMBER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), LOADING});
    }

    @Override
    protected void unbindOtherCounters(AbstractMetricService metricService) {
        this.totalPendingFileCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.queuingFileCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.loadingFileCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        metricService.remove(MetricType.COUNTER, Metric.ACTIVE_LOADING_FILES_NUMBER.toString(), new String[]{Tag.TYPE.toString(), PENDING});
        metricService.remove(MetricType.COUNTER, Metric.ACTIVE_LOADING_FILES_NUMBER.toString(), new String[]{Tag.TYPE.toString(), QUEUING});
        metricService.remove(MetricType.COUNTER, Metric.ACTIVE_LOADING_FILES_NUMBER.toString(), new String[]{Tag.TYPE.toString(), LOADING});
    }

    @Override
    protected String getMetricName() {
        return Metric.ACTIVE_LOADING_FILES_NUMBER.toString();
    }

    public static ActiveLoadingFilesNumberMetricsSet getInstance() {
        return INSTANCE;
    }

    private ActiveLoadingFilesNumberMetricsSet() {
    }
}

