/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.PatternRecognitionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrPatternAlternationOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPatternFlattener;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class OptimizeRowPattern
implements Rule<PatternRecognitionNode> {
    private static final Pattern<PatternRecognitionNode> PATTERN = Patterns.patternRecognition();

    @Override
    public Pattern<PatternRecognitionNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(PatternRecognitionNode node, Captures captures, Rule.Context context) {
        IrRowPattern optimizedPattern = IrPatternAlternationOptimizer.optimize(IrRowPatternFlattener.optimize(node.getPattern()));
        if (optimizedPattern.equals(node.getPattern())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new PatternRecognitionNode(node.getPlanNodeId(), node.getChild(), node.getPartitionBy(), node.getOrderingScheme(), node.getHashSymbol(), node.getMeasures(), node.getRowsPerMatch(), node.getSkipToLabels(), node.getSkipToPosition(), optimizedPattern, node.getVariableDefinitions()));
    }
}

