/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.dispatch;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.inlong.dataproxy.dispatch.DispatchProfile;
import org.apache.inlong.dataproxy.dispatch.DispatchProfileCallback;
import org.apache.inlong.dataproxy.utils.MessageUtils;
import org.apache.inlong.sdk.commons.protocol.ProxyEvent;
import org.apache.inlong.sdk.commons.protocol.ProxyPackEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchManager {
    public static final Logger LOG = LoggerFactory.getLogger(DispatchManager.class);
    public static final String KEY_DISPATCH_TIMEOUT = "dispatchTimeout";
    public static final String KEY_DISPATCH_MAX_PACKCOUNT = "dispatchMaxPackCount";
    public static final String KEY_DISPATCH_MAX_PACKSIZE = "dispatchMaxPackSize";
    public static final long DEFAULT_DISPATCH_TIMEOUT = 2000L;
    public static final long DEFAULT_DISPATCH_MAX_PACKCOUNT = 256L;
    public static final long DEFAULT_DISPATCH_MAX_PACKSIZE = 327680L;
    public static final long MINUTE_MS = 60000L;
    private final long dispatchTimeout;
    private final long maxPackCount;
    private final long maxPackSize;
    private final ArrayList<LinkedBlockingQueue<DispatchProfile>> dispatchQueues;
    private final AtomicInteger sendIndex = new AtomicInteger();
    private ConcurrentHashMap<String, DispatchProfile> profileCache = new ConcurrentHashMap();
    private AtomicBoolean needOutputOvertimeData = new AtomicBoolean(false);
    private AtomicLong inCounter = new AtomicLong(0L);
    private AtomicLong outCounter = new AtomicLong(0L);

    public DispatchManager(Context context, ArrayList<LinkedBlockingQueue<DispatchProfile>> dispatchQueues) {
        this.dispatchQueues = dispatchQueues;
        this.dispatchTimeout = context.getLong(KEY_DISPATCH_TIMEOUT, Long.valueOf(2000L));
        this.maxPackCount = context.getLong(KEY_DISPATCH_MAX_PACKCOUNT, Long.valueOf(256L));
        this.maxPackSize = context.getLong(KEY_DISPATCH_MAX_PACKSIZE, Long.valueOf(327680L));
    }

    public void addEvent(ProxyEvent event) {
        String eventUid = event.getUid();
        long dispatchTime = event.getMsgTime() - event.getMsgTime() % 60000L;
        String dispatchKey = eventUid + "." + dispatchTime;
        DispatchProfile dispatchProfile = this.profileCache.get(dispatchKey);
        if (dispatchProfile == null) {
            dispatchProfile = new DispatchProfile(eventUid, event.getInlongGroupId(), event.getInlongStreamId(), dispatchTime);
            this.profileCache.put(dispatchKey, dispatchProfile);
        }
        boolean addResult = dispatchProfile.addEvent(event, this.maxPackCount, this.maxPackSize);
        this.addSendIndex((Event)event, dispatchProfile);
        if (!addResult) {
            DispatchProfile newDispatchProfile = new DispatchProfile(eventUid, event.getInlongGroupId(), event.getInlongStreamId(), dispatchTime);
            DispatchProfile oldDispatchProfile = this.profileCache.put(dispatchKey, newDispatchProfile);
            this.dispatchQueues.get(dispatchProfile.getSendIndex() % this.dispatchQueues.size()).offer(dispatchProfile);
            this.outCounter.addAndGet(dispatchProfile.getCount());
            newDispatchProfile.addEvent(event, this.maxPackCount, this.maxPackSize);
        }
        this.inCounter.incrementAndGet();
    }

    private void addSendIndex(Event event, DispatchProfile dispatchProfile) {
        if (MessageUtils.isSyncSendForOrder(event)) {
            String partitionKey = (String)event.getHeaders().get("partitionKey");
            int sendIndex = Math.abs(partitionKey.hashCode());
            dispatchProfile.setOrder(true);
            dispatchProfile.setSendIndex(sendIndex);
        } else {
            dispatchProfile.setSendIndex(this.sendIndex.incrementAndGet());
        }
    }

    public void addPackEvent(ProxyPackEvent packEvent) {
        String eventUid = packEvent.getUid();
        long dispatchTime = packEvent.getMsgTime() - packEvent.getMsgTime() % 60000L;
        DispatchProfile dispatchProfile = new DispatchProfile(eventUid, packEvent.getInlongGroupId(), packEvent.getInlongStreamId(), dispatchTime);
        DispatchProfileCallback callback = new DispatchProfileCallback(packEvent.getEvents().size(), packEvent.getCallback());
        dispatchProfile.setCallback(callback);
        for (ProxyEvent event : packEvent.getEvents()) {
            this.inCounter.incrementAndGet();
            boolean addResult = dispatchProfile.addEvent(event, this.maxPackCount, this.maxPackSize);
            this.addSendIndex((Event)event, dispatchProfile);
            if (addResult) continue;
            this.outCounter.addAndGet(dispatchProfile.getCount());
            this.dispatchQueues.get(dispatchProfile.getSendIndex() % this.dispatchQueues.size()).offer(dispatchProfile);
            dispatchProfile = new DispatchProfile(eventUid, event.getInlongGroupId(), event.getInlongStreamId(), dispatchTime);
            dispatchProfile.setCallback(callback);
            dispatchProfile.addEvent(event, this.maxPackCount, this.maxPackSize);
        }
        if (dispatchProfile.getEvents().size() > 0) {
            this.outCounter.addAndGet(dispatchProfile.getCount());
            this.dispatchQueues.get(dispatchProfile.getSendIndex() % this.dispatchQueues.size()).offer(dispatchProfile);
        }
    }

    public void outputOvertimeData() {
        if (!this.needOutputOvertimeData.getAndSet(false)) {
            return;
        }
        LOG.debug("start to outputOvertimeData profileCacheSize:{},dispatchQueueSize:{}", (Object)this.profileCache.size(), (Object)this.dispatchQueues.stream().mapToInt(LinkedBlockingQueue::size).sum());
        long currentTime = System.currentTimeMillis();
        long createThreshold = currentTime - this.dispatchTimeout;
        ArrayList<String> removeKeys = new ArrayList<String>();
        long eventCount = 0L;
        for (Map.Entry<String, DispatchProfile> entry : this.profileCache.entrySet()) {
            DispatchProfile dispatchProfile = entry.getValue();
            eventCount += dispatchProfile.getCount();
            if (!dispatchProfile.isTimeout(createThreshold)) continue;
            removeKeys.add(entry.getKey());
        }
        removeKeys.forEach(key -> {
            DispatchProfile dispatchProfile = this.profileCache.remove(key);
            if (dispatchProfile != null) {
                this.dispatchQueues.get(dispatchProfile.getSendIndex() % this.dispatchQueues.size()).offer(dispatchProfile);
                this.outCounter.addAndGet(dispatchProfile.getCount());
            }
        });
        LOG.debug("end to outputOvertimeData profileCacheSize:{},dispatchQueueSize:{},eventCount:{},inCounter:{},outCounter:{}", new Object[]{this.profileCache.size(), this.dispatchQueues.stream().mapToInt(LinkedBlockingQueue::size).sum(), eventCount, this.inCounter.getAndSet(0L), this.outCounter.getAndSet(0L)});
    }

    public long getDispatchTimeout() {
        return this.dispatchTimeout;
    }

    public long getMaxPackCount() {
        return this.maxPackCount;
    }

    public long getMaxPackSize() {
        return this.maxPackSize;
    }

    public void setNeedOutputOvertimeData() {
        this.needOutputOvertimeData.getAndSet(true);
    }
}

