/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.condition;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.ExpressionOperator;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="condition", names={"isnull"}, parameter="(Expr expr)", descriptions={"- Return true if 'expr' is NULL;", "- Return false otherwise."}, examples={"isnull(5 + 3) = false", "isnull(5 / 0) = true"})
public class IsNullFunction
implements ValueParser {
    private ValueParser stringParser;
    private ExpressionOperator operator;

    public IsNullFunction(Function expr) {
        Expression expression = (Expression)expr.getParameters().getExpressions().get(0);
        try {
            this.stringParser = OperatorTools.buildParser(expression);
        }
        catch (Exception e) {
            this.operator = OperatorTools.buildOperator(expression);
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object val = null;
        try {
            val = this.stringParser != null ? this.stringParser.parse(sourceData, rowIndex, context) : Boolean.valueOf(this.operator.check(sourceData, rowIndex, context));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val == null;
    }
}

