/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils.regex;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.plugin.utils.regex.DateUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scanner.class);

    public static List<FinalPatternInfo> getFinalPatternInfos(String originPattern, String cycleUnit, String timeOffset, long startTime, long endTime, boolean isRetry) {
        TimeRange range = Scanner.getTimeRange(startTime, endTime, cycleUnit, timeOffset, isRetry);
        String strStartTime = DateTransUtils.millSecConvertToTimeStr((long)range.startTime, (String)cycleUnit);
        String strEndTime = DateTransUtils.millSecConvertToTimeStr((long)range.endTime, (String)cycleUnit);
        LOGGER.info("{} scan time is between {} and {}", new Object[]{originPattern, strStartTime, strEndTime});
        List<Long> dateRegion = DateUtils.getDateRegion(range.startTime, range.endTime, cycleUnit);
        ArrayList<FinalPatternInfo> finalPatternList = new ArrayList<FinalPatternInfo>();
        for (Long time : dateRegion) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(time);
            FinalPatternInfo finalPatternInfo = new FinalPatternInfo(DateUtils.replaceDateExpression(calendar, originPattern), time);
            finalPatternList.add(finalPatternInfo);
        }
        return finalPatternList;
    }

    public static List<String> getDataTimeList(long startTime, long endTime, String cycleUnit, String timeOffset, boolean isRetry) {
        TimeRange range = Scanner.getTimeRange(startTime, endTime, cycleUnit, timeOffset, isRetry);
        ArrayList<String> dataTimeList = new ArrayList<String>();
        List<Long> dateRegion = DateUtils.getDateRegion(range.startTime, range.endTime, cycleUnit);
        for (Long time : dateRegion) {
            String dataTime = DateTransUtils.millSecConvertToTimeStr((long)time, (String)cycleUnit);
            dataTimeList.add(dataTime);
        }
        return dataTimeList;
    }

    public static TimeRange getTimeRange(long startTime, long endTime, String cycleUnit, String timeOffset, boolean isRetry) {
        if (!isRetry) {
            long currentTime = System.currentTimeMillis();
            startTime = currentTime + OffsetManager.getScanCycleRange((String)cycleUnit) + DateTransUtils.calcOffset((String)timeOffset);
            endTime = currentTime + DateTransUtils.calcOffset((String)timeOffset);
        }
        return new TimeRange(startTime, endTime);
    }

    public static class FinalPatternInfo {
        public String finalPattern;
        public Long dataTime;

        public FinalPatternInfo(String finalPattern, Long dataTime) {
            this.finalPattern = finalPattern;
            this.dataTime = dataTime;
        }
    }

    public static class TimeRange {
        public Long startTime;
        public Long endTime;

        public TimeRange(Long startTime, Long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }
}

