/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;

public class DualKeyLinkedMap<A, B, V> {
    private final LinkedHashMap<A, Tuple2<B, V>> aMap;
    private final Map<B, A> bMap;
    private Collection<V> values;

    public DualKeyLinkedMap(int initialCapacity) {
        this.aMap = new LinkedHashMap(initialCapacity);
        this.bMap = new HashMap<B, A>(initialCapacity);
    }

    public int size() {
        return this.aMap.size();
    }

    @Nullable
    public V getValueByKeyA(A aKey) {
        Tuple2<B, V> value = this.aMap.get(aKey);
        return (V)(value != null ? value.f1 : null);
    }

    @Nullable
    public V getValueByKeyB(B bKey) {
        A aKey = this.bMap.get(bKey);
        return (V)(aKey != null ? this.aMap.get(aKey).f1 : null);
    }

    @Nullable
    public A getKeyAByKeyB(B bKey) {
        return this.bMap.get(bKey);
    }

    @Nullable
    public B getKeyBByKeyA(A aKey) {
        Tuple2<B, V> value = this.aMap.get(aKey);
        return (B)(value != null ? value.f0 : null);
    }

    @Nullable
    public V put(A aKey, B bKey, V value) {
        V oldValue = this.getValueByKeyA(aKey);
        if (!Objects.equals(aKey, this.getKeyAByKeyB(bKey))) {
            this.removeKeyB(bKey);
            B oldBKeyOfAKey = this.getKeyBByKeyA(aKey);
            if (oldBKeyOfAKey != null) {
                this.bMap.remove(oldBKeyOfAKey);
            }
        }
        this.aMap.put(aKey, Tuple2.of(bKey, value));
        this.bMap.put(bKey, aKey);
        return oldValue;
    }

    public boolean containsKeyA(A aKey) {
        return this.aMap.containsKey(aKey);
    }

    public boolean containsKeyB(B bKey) {
        return this.bMap.containsKey(bKey);
    }

    @Nullable
    public V removeKeyA(A aKey) {
        Tuple2 aValue = (Tuple2)this.aMap.remove(aKey);
        if (aValue != null) {
            this.bMap.remove(aValue.f0);
            return (V)aValue.f1;
        }
        return null;
    }

    @Nullable
    public V removeKeyB(B bKey) {
        A aKey = this.bMap.remove(bKey);
        if (aKey != null) {
            Tuple2 aValue = (Tuple2)this.aMap.remove(aKey);
            return (V)(aValue != null ? aValue.f1 : null);
        }
        return null;
    }

    public Collection<V> values() {
        Values vs = this.values;
        if (vs == null) {
            this.values = vs = new Values();
        }
        return vs;
    }

    public Set<A> keySetA() {
        return this.aMap.keySet();
    }

    public Set<B> keySetB() {
        return this.bMap.keySet();
    }

    public void clear() {
        this.aMap.clear();
        this.bMap.clear();
    }

    private final class ValueIterator
    implements Iterator<V> {
        private final Iterator<Tuple2<B, V>> iterator;

        private ValueIterator() {
            this.iterator = DualKeyLinkedMap.this.aMap.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            Tuple2 value = this.iterator.next();
            return value.f1;
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return DualKeyLinkedMap.this.aMap.size();
        }
    }
}

