/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeQueryable;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class InternalTypeInfo<T>
extends TypeInformation<T>
implements DataTypeQueryable {
    private static final String FORMAT = "%s(%s, %s)";
    private final LogicalType type;
    private final Class<T> typeClass;
    private final TypeSerializer<T> typeSerializer;

    private InternalTypeInfo(LogicalType type, Class<T> typeClass, TypeSerializer<T> typeSerializer) {
        this.type = (LogicalType)Preconditions.checkNotNull((Object)type);
        this.typeClass = (Class)Preconditions.checkNotNull(typeClass);
        this.typeSerializer = (TypeSerializer)Preconditions.checkNotNull(typeSerializer);
    }

    public static <T> InternalTypeInfo<T> of(LogicalType type) {
        Class typeClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)type);
        TypeSerializer serializer = InternalSerializers.create(type);
        return new InternalTypeInfo(type, typeClass, serializer);
    }

    public static InternalTypeInfo<RowData> of(RowType type) {
        return InternalTypeInfo.of((LogicalType)type);
    }

    public static InternalTypeInfo<RowData> ofFields(LogicalType ... fieldTypes) {
        return InternalTypeInfo.of(RowType.of((LogicalType[])fieldTypes));
    }

    public static InternalTypeInfo<RowData> ofFields(LogicalType[] fieldTypes, String[] fieldNames) {
        return InternalTypeInfo.of(RowType.of((LogicalType[])fieldTypes, (String[])fieldNames));
    }

    public LogicalType toLogicalType() {
        return this.type;
    }

    public TypeSerializer<T> toSerializer() {
        return this.typeSerializer;
    }

    public RowType toRowType() {
        return (RowType)this.type;
    }

    public RowDataSerializer toRowSerializer() {
        return (RowDataSerializer)this.typeSerializer;
    }

    @Deprecated
    public LogicalType[] toRowFieldTypes() {
        return (LogicalType[])this.toRowType().getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
    }

    @Deprecated
    public String[] toRowFieldNames() {
        return (String[])this.toRowType().getFields().stream().map(RowType.RowField::getName).toArray(String[]::new);
    }

    @Deprecated
    public int toRowSize() {
        return this.toRowType().getFieldCount();
    }

    public DataType getDataType() {
        return DataTypeUtils.toInternalDataType((LogicalType)this.type);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return this.typeSerializer;
    }

    public String toString() {
        return String.format(FORMAT, this.type.asSummaryString(), this.typeClass.getName(), this.typeSerializer.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InternalTypeInfo that = (InternalTypeInfo)((Object)o);
        return this.typeSerializer.equals(that.typeSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.typeSerializer);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof InternalTypeInfo;
    }
}

