/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.lang.annotation.Annotation;
import java.util.Optional;

public class Annotations {
    private Annotations() {
        throw new UnsupportedOperationException();
    }

    public static <A extends Annotation> Optional<A> findPropertyAnnotation(BeanPropertyDefinition beanPropertyDefinition, Class<A> annotationClass) {
        return Annotations.tryGetFieldAnnotation(beanPropertyDefinition, annotationClass).map(Optional::of).orElse(Annotations.tryGetGetterAnnotation(beanPropertyDefinition, annotationClass)).map(Optional::of).orElse(Annotations.tryGetSetterAnnotation(beanPropertyDefinition, annotationClass));
    }

    public static boolean memberIsUnwrapped(AnnotatedMember member) {
        if (member == null) {
            return false;
        }
        return Optional.ofNullable((JsonUnwrapped)member.getAnnotation(JsonUnwrapped.class)).isPresent();
    }

    public static String unwrappedPrefix(AnnotatedMember member) {
        if (member == null) {
            return "";
        }
        return Optional.ofNullable((JsonUnwrapped)member.getAnnotation(JsonUnwrapped.class)).map(JsonUnwrapped::prefix).orElse("");
    }

    private static <A extends Annotation> Optional<A> tryGetGetterAnnotation(BeanPropertyDefinition beanPropertyDefinition, Class<A> annotationClass) {
        if (beanPropertyDefinition.hasGetter()) {
            return Optional.ofNullable(beanPropertyDefinition.getGetter().getAnnotation(annotationClass));
        }
        return Optional.empty();
    }

    private static <A extends Annotation> Optional<A> tryGetSetterAnnotation(BeanPropertyDefinition beanPropertyDefinition, Class<A> annotationClass) {
        if (beanPropertyDefinition.hasSetter()) {
            return Optional.ofNullable(beanPropertyDefinition.getSetter().getAnnotation(annotationClass));
        }
        return Optional.empty();
    }

    private static <A extends Annotation> Optional<A> tryGetFieldAnnotation(BeanPropertyDefinition beanPropertyDefinition, Class<A> annotationClass) {
        if (beanPropertyDefinition.hasField()) {
            return Optional.ofNullable(beanPropertyDefinition.getField().getAnnotation(annotationClass));
        }
        return Optional.empty();
    }

    public static String memberName(AnnotatedMember member) {
        if (member == null || member.getMember() == null) {
            return "";
        }
        return member.getMember().getName();
    }
}

