/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.fasterxml.classmate.ResolvedType;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.swagger2.mappers.EnumMapper;

@Deprecated
class Properties {
    private static final Map<String, Function<String, Property>> TYPE_FACTORY = new HashMap<String, Function<String, Property>>();

    private Properties() {
        throw new UnsupportedOperationException();
    }

    public static Property property(String typeName) {
        String safeTypeName = Optional.ofNullable(typeName).orElse("");
        return TYPE_FACTORY.getOrDefault(safeTypeName.toLowerCase(), Properties.voidOrRef(safeTypeName)).apply(safeTypeName);
    }

    public static Property property(ModelReference modelRef) {
        if (modelRef.isMap()) {
            return new MapProperty(Properties.property((ModelReference)modelRef.itemModel().orElseThrow(() -> new IllegalStateException("ModelRef that is a map should have an itemModel"))));
        }
        if (modelRef.isCollection()) {
            if ("byte".equals(modelRef.itemModel().map(ModelReference::getType).orElse(""))) {
                return new ByteArrayProperty();
            }
            return new ArrayProperty(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty((ModelReference)modelRef.itemModel().orElseThrow(() -> new IllegalStateException("ModelRef that is a collection should have an itemModel"))), modelRef.getAllowableValues()));
        }
        return Properties.property(modelRef.getType());
    }

    public static Property itemTypeProperty(ModelReference paramModel) {
        if (paramModel.isCollection()) {
            return new ArrayProperty(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty((ModelReference)paramModel.itemModel().orElseThrow(() -> new IllegalStateException("ModelRef that is a collection should have an itemModel"))), paramModel.getAllowableValues()));
        }
        return Properties.property(paramModel.getType());
    }

    private static Function<String, Property> newInstanceOf(Class<? extends Property> clazz) {
        return input -> {
            try {
                return (Property)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        };
    }

    static Comparator<String> defaultOrdering(Map<String, ModelProperty> properties) {
        return Properties.byPosition(properties).thenComparing(Properties.byName());
    }

    private static Function<String, Property> voidOrRef(String typeName) {
        return input -> {
            if (typeName.equalsIgnoreCase("void")) {
                return null;
            }
            return new RefProperty(typeName);
        };
    }

    private static Function<String, Property> bytePropertyFactory() {
        return input -> {
            IntegerProperty integerProperty = new IntegerProperty();
            integerProperty.setFormat("int32");
            integerProperty.setMaximum(BigDecimal.valueOf(127L));
            integerProperty.setMinimum(BigDecimal.valueOf(-128L));
            return integerProperty;
        };
    }

    private static Function<String, Property> filePropertyFactory() {
        return input -> new FileProperty();
    }

    private static Comparator<String> byName() {
        return String::compareTo;
    }

    private static Comparator<String> byPosition(Map<String, ModelProperty> modelProperties) {
        return (first, second) -> {
            ModelProperty p1 = (ModelProperty)modelProperties.get(first);
            ModelProperty p2 = (ModelProperty)modelProperties.get(second);
            return Integer.compare(p1.getPosition(), p2.getPosition());
        };
    }

    static Predicate<Map.Entry<String, ModelProperty>> voidProperties() {
        return input -> ResolvedTypes.isVoid((ResolvedType)((ModelProperty)input.getValue()).getType()) || Properties.collectionOfVoid(((ModelProperty)input.getValue()).getType()) || ResolvedTypes.isVoid((ResolvedType)((ModelProperty)input.getValue()).getType().getArrayElementType());
    }

    private static boolean collectionOfVoid(ResolvedType type) {
        return Collections.isContainerType((ResolvedType)type) && ResolvedTypes.isVoid((ResolvedType)Collections.collectionElementType((ResolvedType)type));
    }

    static {
        TYPE_FACTORY.put("int", Properties.newInstanceOf(IntegerProperty.class));
        TYPE_FACTORY.put("long", Properties.newInstanceOf(LongProperty.class));
        TYPE_FACTORY.put("float", Properties.newInstanceOf(FloatProperty.class));
        TYPE_FACTORY.put("double", Properties.newInstanceOf(DoubleProperty.class));
        TYPE_FACTORY.put("string", Properties.newInstanceOf(StringProperty.class));
        TYPE_FACTORY.put("boolean", Properties.newInstanceOf(BooleanProperty.class));
        TYPE_FACTORY.put("date", Properties.newInstanceOf(DateProperty.class));
        TYPE_FACTORY.put("date-time", Properties.newInstanceOf(DateTimeProperty.class));
        TYPE_FACTORY.put("bigdecimal", Properties.newInstanceOf(DecimalProperty.class));
        TYPE_FACTORY.put("biginteger", Properties.newInstanceOf(LongProperty.class));
        TYPE_FACTORY.put("uuid", Properties.newInstanceOf(UUIDProperty.class));
        TYPE_FACTORY.put("object", Properties.newInstanceOf(ObjectProperty.class));
        TYPE_FACTORY.put("byte", Properties.bytePropertyFactory());
        TYPE_FACTORY.put("__file", Properties.filePropertyFactory());
    }
}

