/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterStatsNodeResponse
extends BaseNodeResponse {
    private NodeInfo nodeInfo;
    private NodeStats nodeStats;
    private ShardStats[] shardsStats;
    private ClusterHealthStatus clusterStatus;

    ClusterStatsNodeResponse() {
    }

    public ClusterStatsNodeResponse(DiscoveryNode node, @Nullable ClusterHealthStatus clusterStatus, NodeInfo nodeInfo, NodeStats nodeStats, ShardStats[] shardsStats) {
        super(node);
        this.nodeInfo = nodeInfo;
        this.nodeStats = nodeStats;
        this.shardsStats = shardsStats;
        this.clusterStatus = clusterStatus;
    }

    public NodeInfo nodeInfo() {
        return this.nodeInfo;
    }

    public NodeStats nodeStats() {
        return this.nodeStats;
    }

    @Nullable
    public ClusterHealthStatus clusterStatus() {
        return this.clusterStatus;
    }

    public ShardStats[] shardsStats() {
        return this.shardsStats;
    }

    public static ClusterStatsNodeResponse readNodeResponse(StreamInput in) throws IOException {
        ClusterStatsNodeResponse nodeResponse = new ClusterStatsNodeResponse();
        nodeResponse.readFrom(in);
        return nodeResponse;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterStatus = null;
        if (in.readBoolean()) {
            this.clusterStatus = ClusterHealthStatus.fromValue(in.readByte());
        }
        this.nodeInfo = NodeInfo.readNodeInfo(in);
        this.nodeStats = NodeStats.readNodeStats(in);
        int size = in.readVInt();
        this.shardsStats = new ShardStats[size];
        for (int i = 0; i < size; ++i) {
            this.shardsStats[i] = ShardStats.readShardStats(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.clusterStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.clusterStatus.value());
        }
        this.nodeInfo.writeTo(out);
        this.nodeStats.writeTo(out);
        out.writeVInt(this.shardsStats.length);
        for (ShardStats ss : this.shardsStats) {
            ss.writeTo(out);
        }
    }
}

