/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.http;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.http.HttpDataNodeRequest;

@JsonTypeDefine(value="HTTP")
@ApiModel(value="HTTP data node info")
public class HttpDataNodeInfo
extends DataNodeInfo {
    @ApiModelProperty(value="HTTP base url")
    private String baseUrl;
    @ApiModelProperty(value="Whether to enable credential")
    private Boolean enableCredential;
    @ApiModelProperty(value="Max connect count")
    private Integer maxConnect;

    public HttpDataNodeInfo() {
        this.setType("HTTP");
    }

    @Override
    public DataNodeRequest genRequest() {
        return (DataNodeRequest)CommonBeanUtils.copyProperties((Object)this, HttpDataNodeRequest::new);
    }

    protected HttpDataNodeInfo(HttpDataNodeInfoBuilder<?, ?> b) {
        super(b);
        this.baseUrl = ((HttpDataNodeInfoBuilder)b).baseUrl;
        this.enableCredential = ((HttpDataNodeInfoBuilder)b).enableCredential;
        this.maxConnect = ((HttpDataNodeInfoBuilder)b).maxConnect;
    }

    public static HttpDataNodeInfoBuilder<?, ?> builder() {
        return new HttpDataNodeInfoBuilderImpl();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Boolean getEnableCredential() {
        return this.enableCredential;
    }

    public Integer getMaxConnect() {
        return this.maxConnect;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setEnableCredential(Boolean enableCredential) {
        this.enableCredential = enableCredential;
    }

    public void setMaxConnect(Integer maxConnect) {
        this.maxConnect = maxConnect;
    }

    public HttpDataNodeInfo(String baseUrl, Boolean enableCredential, Integer maxConnect) {
        this.baseUrl = baseUrl;
        this.enableCredential = enableCredential;
        this.maxConnect = maxConnect;
    }

    @Override
    public String toString() {
        return "HttpDataNodeInfo(super=" + super.toString() + ", baseUrl=" + this.getBaseUrl() + ", enableCredential=" + this.getEnableCredential() + ", maxConnect=" + this.getMaxConnect() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpDataNodeInfo)) {
            return false;
        }
        HttpDataNodeInfo other = (HttpDataNodeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$enableCredential = this.getEnableCredential();
        Boolean other$enableCredential = other.getEnableCredential();
        if (this$enableCredential == null ? other$enableCredential != null : !((Object)this$enableCredential).equals(other$enableCredential)) {
            return false;
        }
        Integer this$maxConnect = this.getMaxConnect();
        Integer other$maxConnect = other.getMaxConnect();
        if (this$maxConnect == null ? other$maxConnect != null : !((Object)this$maxConnect).equals(other$maxConnect)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        return !(this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpDataNodeInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $enableCredential = this.getEnableCredential();
        result = result * 59 + ($enableCredential == null ? 43 : ((Object)$enableCredential).hashCode());
        Integer $maxConnect = this.getMaxConnect();
        result = result * 59 + ($maxConnect == null ? 43 : ((Object)$maxConnect).hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        return result;
    }

    private static final class HttpDataNodeInfoBuilderImpl
    extends HttpDataNodeInfoBuilder<HttpDataNodeInfo, HttpDataNodeInfoBuilderImpl> {
        private HttpDataNodeInfoBuilderImpl() {
        }

        @Override
        protected HttpDataNodeInfoBuilderImpl self() {
            return this;
        }

        @Override
        public HttpDataNodeInfo build() {
            return new HttpDataNodeInfo(this);
        }
    }

    public static abstract class HttpDataNodeInfoBuilder<C extends HttpDataNodeInfo, B extends HttpDataNodeInfoBuilder<C, B>>
    extends DataNodeInfo.DataNodeInfoBuilder<C, B> {
        private String baseUrl;
        private Boolean enableCredential;
        private Integer maxConnect;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (B)this.self();
        }

        public B enableCredential(Boolean enableCredential) {
            this.enableCredential = enableCredential;
            return (B)this.self();
        }

        public B maxConnect(Integer maxConnect) {
            this.maxConnect = maxConnect;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HttpDataNodeInfo.HttpDataNodeInfoBuilder(super=" + super.toString() + ", baseUrl=" + this.baseUrl + ", enableCredential=" + this.enableCredential + ", maxConnect=" + this.maxConnect + ")";
        }
    }
}

