/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleUpdateStatement
extends SQLUpdateStatement
implements OracleStatement,
SQLReplaceable {
    private List<SQLHint> hints = new ArrayList<SQLHint>(1);
    private boolean only = false;
    private String alias;
    private final List<SQLExpr> returningInto = new ArrayList<SQLExpr>();

    public OracleUpdateStatement() {
        super(DbType.oracle);
    }

    public List<SQLExpr> getReturningInto() {
        return this.returningInto;
    }

    public void addReturningInto(SQLExpr returningInto) {
        if (returningInto == null) {
            return;
        }
        returningInto.setParent(this);
        this.returningInto.add(returningInto);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof OracleASTVisitor) {
            this.accept0((OracleASTVisitor)visitor);
            return;
        }
        super.accept(visitor);
    }

    @Override
    public void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.hints);
            this.acceptChild((SQLASTVisitor)visitor, this.tableSource);
            this.acceptChild((SQLASTVisitor)visitor, this.items);
            this.acceptChild((SQLASTVisitor)visitor, this.where);
            this.acceptChild((SQLASTVisitor)visitor, this.returning);
            this.acceptChild((SQLASTVisitor)visitor, this.returningInto);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        boolean replace = super.replace(expr, target);
        if (replace) {
            return true;
        }
        for (int i = this.returningInto.size() - 1; i >= 0; --i) {
            if (this.returningInto.get(i) != expr) continue;
            target.setParent(this);
            this.returningInto.set(i, target);
            return true;
        }
        return false;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isOnly() {
        return this.only;
    }

    public void setOnly(boolean only) {
        this.only = only;
    }

    public int getHintsSize() {
        if (this.hints == null) {
            return 0;
        }
        return this.hints.size();
    }

    public List<SQLHint> getHints() {
        if (this.hints == null) {
            this.hints = new ArrayList<SQLHint>(2);
        }
        return this.hints;
    }

    public void setHints(List<SQLHint> hints) {
        this.hints = hints;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OracleUpdateStatement that = (OracleUpdateStatement)o;
        if (this.with != null ? !this.with.equals(that.getWith()) : that.getWith() != null) {
            return false;
        }
        if (!this.items.equals(that.getItems())) {
            return false;
        }
        if (this.where != null ? !this.where.equals(that.getWhere()) : that.getWhere() != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.getFrom()) : that.getFrom() != null) {
            return false;
        }
        if (this.hints != null ? !this.hints.equals(that.hints) : that.hints != null) {
            return false;
        }
        if (this.tableSource != null ? !this.tableSource.equals(that.tableSource) : that.tableSource != null) {
            return false;
        }
        if (this.returning != null ? !this.returning.equals(that.returning) : that.returning != null) {
            return false;
        }
        return this.orderBy != null ? this.orderBy.equals(that.orderBy) : that.orderBy == null;
    }

    @Override
    public int hashCode() {
        int result = this.with != null ? this.with.hashCode() : 0;
        result = 31 * result + this.items.hashCode();
        result = 31 * result + (this.where != null ? this.where.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.tableSource != null ? this.tableSource.hashCode() : 0);
        result = 31 * result + (this.returning != null ? this.returning.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + (this.hints != null ? this.hints.hashCode() : 0);
        return result;
    }
}

