/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.dataproxy.DataProxyClusterInfo;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataProxyClusterOperator
extends AbstractClusterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProxyClusterOperator.class);

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterType().equals(clusterType);
    }

    @Override
    public String getClusterType() {
        return "DATAPROXY";
    }

    @Override
    protected void setTargetEntity(ClusterRequest request, InlongClusterEntity targetEntity) {
        LOGGER.debug("do nothing for data proxy cluster in set target entity");
    }

    @Override
    public ClusterInfo getFromEntity(InlongClusterEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        return (ClusterInfo)CommonBeanUtils.copyProperties((Object)entity, DataProxyClusterInfo::new);
    }

    @Override
    public Object getClusterInfo(InlongClusterEntity entity) {
        List clusterNodeEntityList = this.clusterNodeEntityMapper.selectByParentId(entity.getId(), null);
        HashMap map = new HashMap();
        ArrayList<String> urlList = new ArrayList<String>();
        for (InlongClusterNodeEntity clusterNodeEntity : clusterNodeEntityList) {
            urlList.add(clusterNodeEntity.getIp() + ":" + clusterNodeEntity.getPort());
        }
        map.put("urls", urlList);
        return map;
    }
}

