/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ImplicitContextKeyed;
import javax.annotation.Nullable;

public final class HttpRouteState
implements ImplicitContextKeyed {
    private static final ContextKey<HttpRouteState> KEY = ContextKey.named("opentelemetry-http-server-route-key");
    @Nullable
    private final String method;
    @Nullable
    private volatile String route;
    private volatile int updatedBySourceOrder;

    @Nullable
    public static HttpRouteState fromContextOrNull(Context context) {
        return context.get(KEY);
    }

    public static HttpRouteState create(@Nullable String method, @Nullable String route, int updatedBySourceOrder) {
        return new HttpRouteState(method, route, updatedBySourceOrder);
    }

    private HttpRouteState(@Nullable String method, @Nullable String route, int updatedBySourceOrder) {
        this.method = method;
        this.updatedBySourceOrder = updatedBySourceOrder;
        this.route = route;
    }

    @Override
    public Context storeInContext(Context context) {
        return context.with(KEY, this);
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public int getUpdatedBySourceOrder() {
        return this.updatedBySourceOrder;
    }

    @Nullable
    public String getRoute() {
        return this.route;
    }

    public void update(Context context, int updatedBySourceOrder, String route) {
        this.updatedBySourceOrder = updatedBySourceOrder;
        this.route = route;
    }
}

