/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools.cli;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.inlong.tubemq.corebase.cluster.MasterInfo;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.fielddef.CliArgDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStatus;
import org.apache.inlong.tubemq.server.common.utils.HttpUtils;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;
import org.apache.inlong.tubemq.server.tools.cli.CliAbstractBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliMetaDataBRU
extends CliAbstractBase {
    private static final Logger logger = LoggerFactory.getLogger(CliMetaDataBRU.class);
    private static final List<String> allowedOpTypeList = Arrays.asList("backup", "recovery");
    private static final int maxDataLength = 150000;
    private static final String curOperator = "SystemCliAdmin";
    private static final String storeFileNameClusterConf = "clusterConfig";
    private static final String storeFileNameBrokerConf = "brokerConfig";
    private static final String storeFileNameTopicCtrl = "topicControlConfig";
    private static final String storeFileNameTopicDeploy = "topicDeployConfig";
    private static final String storeFileNameGroupCtrl = "groupCtrlConfig";
    private static final String storeFileNameCsmCtrl = "groupConsumeConfig";
    private String masterServers = null;
    private String operationType = null;
    private String authToken = null;
    private String backupAndRecoveryPath = "./meta_backup";
    private File metaDataDir = null;
    private MasterInfo masterInfo;

    public CliMetaDataBRU() {
        super("tubemq-metadata-bru.sh");
        this.initCommandOptions();
    }

    @Override
    protected void initCommandOptions() {
        this.addCommandOption(CliArgDef.MASTERSERVER);
        this.addCommandOption(CliArgDef.OPERATIONTYPE);
        this.addCommandOption(CliArgDef.METAFILEPATH);
        this.addCommandOption(CliArgDef.AUTHTOKEN);
    }

    @Override
    public boolean processParams(String[] args) throws Exception {
        CommandLine cli = this.parser.parse(this.options, args);
        if (cli == null) {
            throw new ParseException("Parse args failure");
        }
        if (cli.hasOption(CliArgDef.VERSION.longOpt)) {
            this.version();
        }
        if (cli.hasOption(CliArgDef.HELP.longOpt)) {
            this.help();
        }
        if (!cli.hasOption(CliArgDef.MASTERSERVER.longOpt)) {
            throw new Exception(CliArgDef.MASTERSERVER.longOpt + " is required!");
        }
        this.masterServers = cli.getOptionValue(CliArgDef.MASTERSERVER.longOpt);
        if (TStringUtils.isBlank((String)this.masterServers)) {
            throw new Exception(CliArgDef.MASTERSERVER.longOpt + " is not allowed blank!");
        }
        this.masterInfo = new MasterInfo(this.masterServers.trim());
        if (!cli.hasOption(CliArgDef.OPERATIONTYPE.longOpt)) {
            throw new Exception(CliArgDef.OPERATIONTYPE.longOpt + " is required!");
        }
        this.operationType = cli.getOptionValue(CliArgDef.OPERATIONTYPE.longOpt);
        if (TStringUtils.isBlank((String)this.operationType)) {
            throw new Exception(CliArgDef.OPERATIONTYPE.longOpt + " is not allowed blank!");
        }
        if (!allowedOpTypeList.contains(this.operationType)) {
            throw new Exception(CliArgDef.OPERATIONTYPE.longOpt + " only supports " + allowedOpTypeList);
        }
        if (cli.hasOption(CliArgDef.METAFILEPATH.longOpt)) {
            this.backupAndRecoveryPath = cli.getOptionValue(CliArgDef.METAFILEPATH.longOpt);
            if (TStringUtils.isBlank((String)this.backupAndRecoveryPath)) {
                throw new Exception(CliArgDef.METAFILEPATH.longOpt + " is not allowed blank!");
            }
        }
        this.metaDataDir = new File(this.backupAndRecoveryPath);
        if (!this.metaDataDir.exists()) {
            if (this.operationType.equalsIgnoreCase("backup")) {
                if (!this.metaDataDir.mkdirs()) {
                    throw new IOException(new StringBuilder(512).append("Creates the directory named ").append(this.metaDataDir.getAbsolutePath()).append(" failure!").toString());
                }
            } else {
                throw new RuntimeException(new StringBuilder(512).append("Path ").append(this.backupAndRecoveryPath).append(" is not existed!").toString());
            }
        }
        if (!this.metaDataDir.isDirectory() || !this.metaDataDir.canRead()) {
            throw new RuntimeException(new StringBuilder(512).append("Path ").append(this.backupAndRecoveryPath).append(" is not a readable directory!").toString());
        }
        if (this.operationType.equalsIgnoreCase("recovery")) {
            this.authToken = cli.getOptionValue(CliArgDef.AUTHTOKEN.longOpt);
            if (TStringUtils.isBlank((String)this.authToken)) {
                throw new Exception(CliArgDef.AUTHTOKEN.longOpt + " is not allowed blank!");
            }
        }
        return true;
    }

    public static void main(String[] args) {
        CliMetaDataBRU cliMetaDataBRU = new CliMetaDataBRU();
        StringBuilder strBuff = new StringBuilder(512);
        try {
            boolean result = cliMetaDataBRU.processParams(args);
            if (!result) {
                throw new Exception("Parse parameters failure!");
            }
            cliMetaDataBRU.processCommands(strBuff);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            cliMetaDataBRU.help();
        }
    }

    public void processCommands(StringBuilder strBuff) {
        if (this.operationType.equals("backup")) {
            this.backupMetaData(strBuff);
        } else {
            this.recoveryMetaData(strBuff);
        }
    }

    private void backupMetaData(StringBuilder strBuff) {
        logger.info("[Backup meta-data] begin, start query data from remote");
        if (!this.backupClusterConfig(strBuff)) {
            return;
        }
        if (!this.backupBrokerConfig(strBuff)) {
            return;
        }
        if (!this.backupTopicCtrlConfig(strBuff)) {
            return;
        }
        if (!this.backupTopicDeployConfig(strBuff)) {
            return;
        }
        if (!this.backupGroupCtrlConfig(strBuff)) {
            return;
        }
        if (!this.backupConsumeCtrlConfig(strBuff)) {
            return;
        }
        logger.info("[Backup meta-data] end, backup finished!");
    }

    private void recoveryMetaData(StringBuilder strBuff) {
        ProcessResult result = new ProcessResult();
        logger.info("[Recovery meta-data] begin, start read data from local path");
        if (!this.recoveryClusterConfig(strBuff, result)) {
            return;
        }
        if (!this.recoveryBrokerConfig(strBuff, result)) {
            return;
        }
        if (!this.recoveryTopicCtrlConfig(strBuff, result)) {
            return;
        }
        if (!this.recoveryTopicDeployConfig(strBuff, result)) {
            return;
        }
        if (!this.recoveryGroupCtrlConfig(strBuff, result)) {
            return;
        }
        if (!this.recoveryConsumeCtrlConfig(strBuff, result)) {
            return;
        }
        logger.info("[Recovery meta-data] end, recovery finished!");
    }

    private boolean backupClusterConfig(StringBuilder strBuff) {
        logger.info("[Backup Cluster Conf] begin ");
        Map<String, ClusterSettingEntity> clusterSettingMap = this.getClusterConfInfo(strBuff);
        if (clusterSettingMap == null) {
            logger.error("  download cluster configurations failure!");
            return false;
        }
        logger.info("[Backup Cluster Conf] store cluster configurations to local file");
        this.storeObjectToFile(clusterSettingMap, this.backupAndRecoveryPath, storeFileNameClusterConf);
        logger.info("[Backup Cluster Conf] verify configurations ");
        Map storedSettingMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameClusterConf);
        if (storedSettingMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameClusterConf).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        if (storedSettingMap.size() != clusterSettingMap.size()) {
            logger.error("  verify failure, stored cluster configurations size not equal!");
            return false;
        }
        for (Map.Entry<String, ClusterSettingEntity> qryEntry : clusterSettingMap.entrySet()) {
            ClusterSettingEntity targetEntity = (ClusterSettingEntity)storedSettingMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals(qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored cluster configure value not equal!").append(" data in server is ").append(qryEntry.getValue().toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Backup Cluster Conf] end, success!");
        return true;
    }

    private boolean recoveryClusterConfig(StringBuilder strBuff, ProcessResult result) {
        logger.info("[Recovery Cluster Conf] begin ");
        Map storedSettingMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameClusterConf);
        if (storedSettingMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameClusterConf).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Cluster Conf] upload cluster configurations to master");
        if (!this.writeClusterConfInfo(storedSettingMap, strBuff, result)) {
            logger.error(strBuff.append("  write cluster configurations failure!").append(result.getErrMsg()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Cluster Conf] read restored cluster configurations from master");
        Map<String, ClusterSettingEntity> clusterSettingMap = this.getClusterConfInfo(strBuff);
        if (clusterSettingMap == null) {
            logger.error("  read restored cluster setting configurations failure!");
            return false;
        }
        logger.info("[Recovery Cluster Conf] verify configurations");
        if (storedSettingMap.size() != clusterSettingMap.size()) {
            logger.error("  verify failure, restored cluster configure size not equal!");
            return false;
        }
        for (Map.Entry qryEntry : storedSettingMap.entrySet()) {
            ClusterSettingEntity targetEntity = clusterSettingMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals((ClusterSettingEntity)qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored cluster configure value not equal!").append(" data in server is ").append(((ClusterSettingEntity)qryEntry.getValue()).toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            return false;
        }
        logger.info("[Recovery Cluster Conf] end, success!");
        return true;
    }

    private Map<String, ClusterSettingEntity> getClusterConfInfo(StringBuilder strBuff) {
        JsonObject jsonRes = this.qryDataFromMaster("admin_query_cluster_default_setting", new HashMap<String, String>(), strBuff);
        if (!jsonRes.get("result").getAsBoolean()) {
            logger.info(strBuff.append("Query cluster configurations info failure:").append(jsonRes.get("result").getAsString()).toString());
            strBuff.delete(0, strBuff.length());
            return null;
        }
        HashMap<String, ClusterSettingEntity> clusterSettingMap = new HashMap<String, ClusterSettingEntity>();
        JsonArray clusterInfoList = jsonRes.get("data").getAsJsonArray();
        for (int i = 0; i < clusterInfoList.size(); ++i) {
            JsonObject jsonItem = clusterInfoList.get(i).getAsJsonObject();
            if (jsonItem == null) continue;
            try {
                BaseEntity baseEntity = this.getBaseEntityInfo(jsonItem);
                TopicPropGroup defTopicProps = this.getTopicProps(jsonItem);
                int brokerPort = jsonItem.get("brokerPort").getAsInt();
                int brokerTlsPort = jsonItem.get("brokerTLSPort").getAsInt();
                int brokerWebPort = jsonItem.get("brokerWebPort").getAsInt();
                int maxMsgSizeInMB = jsonItem.get("maxMsgSizeInMB").getAsInt();
                int qryPriorityId = jsonItem.get("qryPriorityId").getAsInt();
                boolean flowCtrlEnable = jsonItem.get("flowCtrlEnable").getAsBoolean();
                int flowRuleCnt = jsonItem.get("flowCtrlRuleCount").getAsInt();
                JsonArray flowCtrlInfoArray = jsonItem.get("flowCtrlInfo").getAsJsonArray();
                String flowCtrlInfoStr = flowCtrlInfoArray.toString();
                EnableStatus flowCtrlStatus = flowCtrlEnable ? EnableStatus.STATUS_ENABLE : EnableStatus.STATUS_DISABLE;
                ClusterSettingEntity settingEntity = new ClusterSettingEntity(baseEntity);
                settingEntity.updModifyInfo(baseEntity.getDataVerId(), brokerPort, brokerTlsPort, brokerWebPort, maxMsgSizeInMB, qryPriorityId, flowCtrlStatus, flowRuleCnt, flowCtrlInfoStr, defTopicProps);
                clusterSettingMap.put(settingEntity.getRecordKey(), settingEntity);
                continue;
            }
            catch (Throwable e) {
                logger.error(strBuff.append("Parse cluster configurations(").append(jsonItem).append(") throw exception ").append(e).toString());
                strBuff.delete(0, strBuff.length());
                throw e;
            }
        }
        return clusterSettingMap;
    }

    private boolean writeClusterConfInfo(Map<String, ClusterSettingEntity> clusterConfMap, StringBuilder strBuff, ProcessResult result) {
        if (clusterConfMap.isEmpty()) {
            return true;
        }
        HashMap<String, String> inParamMap = new HashMap<String, String>();
        for (ClusterSettingEntity entity : clusterConfMap.values()) {
            entity.getConfigureInfo(inParamMap, true);
            if (!this.writeDataToMaster("admin_set_cluster_default_setting", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            inParamMap.clear();
        }
        return true;
    }

    private boolean backupBrokerConfig(StringBuilder strBuff) {
        logger.info("[Backup Broker Conf] begin ");
        Map<String, BrokerConfEntity> brokerConfMap = this.getBrokerConfInfos(strBuff);
        if (brokerConfMap == null) {
            logger.error("  download broker configurations is null!");
            return false;
        }
        logger.info("[Backup Broker Conf] store broker configurations to local file");
        this.storeObjectToFile(brokerConfMap, this.backupAndRecoveryPath, storeFileNameBrokerConf);
        logger.info("[Backup Broker Conf] verify configurations");
        Map storedBrokerConfigMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameBrokerConf);
        if (storedBrokerConfigMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameBrokerConf).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        if (storedBrokerConfigMap.size() != brokerConfMap.size()) {
            logger.error("  verify failure, stored brokerConfig size not equal!");
            return false;
        }
        for (Map.Entry<String, BrokerConfEntity> qryEntry : brokerConfMap.entrySet()) {
            BrokerConfEntity targetEntity = (BrokerConfEntity)storedBrokerConfigMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals(qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored brokerConfig value not equal!").append(" data in server is ").append(qryEntry.getValue().toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Backup Broker Conf] end, success!");
        return true;
    }

    private boolean recoveryBrokerConfig(StringBuilder strBuff, ProcessResult result) {
        logger.info("[Recovery Broker Conf] begin ");
        Map storedBrokerConfigMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameBrokerConf);
        if (storedBrokerConfigMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameBrokerConf).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Broker Conf]  upload broker configurations to master");
        if (!this.writeBrokerConfInfo(storedBrokerConfigMap, strBuff, result)) {
            logger.error(strBuff.append("  write broker configurations failure!").append(result.getErrMsg()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Broker Conf] read restored broker configurations from master");
        Map<String, BrokerConfEntity> brokerConfMap = this.getBrokerConfInfos(strBuff);
        if (brokerConfMap == null) {
            logger.error("  read restored broker configurations failure!");
            return false;
        }
        logger.info("[Recovery Broker Conf] verify configurations");
        if (brokerConfMap.size() != storedBrokerConfigMap.size()) {
            logger.error("  verify failure, restored brokerConfig size not equal!");
            return false;
        }
        for (Map.Entry qryEntry : storedBrokerConfigMap.entrySet()) {
            BrokerConfEntity targetEntity = brokerConfMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals((BrokerConfEntity)qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored brokerConfig value not equal!").append(" data in server is ").append(((BrokerConfEntity)qryEntry.getValue()).toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            return false;
        }
        logger.info("[Recovery Broker Conf] end, success!");
        return true;
    }

    private Map<String, BrokerConfEntity> getBrokerConfInfos(StringBuilder strBuff) {
        JsonObject jsonRes = this.qryDataFromMaster("admin_query_broker_configure", new HashMap<String, String>(), strBuff);
        if (!jsonRes.get("result").getAsBoolean()) {
            logger.info(strBuff.append("Query broker configurations info failure:").append(jsonRes.get("result").getAsString()).toString());
            strBuff.delete(0, strBuff.length());
            return null;
        }
        HashMap<String, BrokerConfEntity> brokerInfoMap = new HashMap<String, BrokerConfEntity>();
        JsonArray jsonBrokerInfoList = jsonRes.get("data").getAsJsonArray();
        for (int i = 0; i < jsonBrokerInfoList.size(); ++i) {
            JsonObject jsonItem = jsonBrokerInfoList.get(i).getAsJsonObject();
            if (jsonItem == null) continue;
            try {
                BaseEntity baseEntity = this.getBaseEntityInfo(jsonItem);
                int brokerId = jsonItem.get("brokerId").getAsInt();
                String brokerIp = jsonItem.get("brokerIp").getAsString();
                BrokerConfEntity brokerConfEntity = new BrokerConfEntity(baseEntity, brokerId, brokerIp);
                TopicPropGroup topicPropGroup = this.getTopicProps(jsonItem);
                int brokerPort = jsonItem.get("brokerPort").getAsInt();
                int brokerTlsPort = jsonItem.get("brokerTLSPort").getAsInt();
                int brokerWebPort = jsonItem.get("brokerWebPort").getAsInt();
                int regionId = jsonItem.get("regionId").getAsInt();
                int groupId = jsonItem.get("groupId").getAsInt();
                String statusInfo = jsonItem.get("manageStatus").getAsString();
                ManageStatus mngStatus = ManageStatus.descOf(statusInfo);
                brokerConfEntity.updModifyInfo(baseEntity.getDataVerId(), brokerPort, brokerTlsPort, brokerWebPort, regionId, groupId, mngStatus, topicPropGroup);
                brokerInfoMap.put(brokerIp, brokerConfEntity);
                continue;
            }
            catch (Throwable e) {
                logger.error(strBuff.append("Parse broker configurations(").append(jsonItem).append(") throw exception ").append(e).toString());
                strBuff.delete(0, strBuff.length());
                throw e;
            }
        }
        return brokerInfoMap;
    }

    private boolean writeBrokerConfInfo(Map<String, BrokerConfEntity> brokerConfigMap, StringBuilder strBuff, ProcessResult result) {
        if (brokerConfigMap.isEmpty()) {
            return true;
        }
        int count = 0;
        HashMap<String, String> inParamMap = new HashMap<String, String>();
        for (BrokerConfEntity entity : brokerConfigMap.values()) {
            if (count++ > 0) {
                strBuff.append(",");
            }
            entity.toWebJsonStr(strBuff, false, false, true, true);
            if (strBuff.length() <= 150000 && count % 50 != 0) continue;
            inParamMap.put("brokerJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_batch_add_broker_configure", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            count = 0;
            inParamMap.clear();
            strBuff.delete(0, strBuff.length());
        }
        if (strBuff.length() > 0) {
            inParamMap.put("brokerJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_batch_add_broker_configure", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            strBuff.delete(0, strBuff.length());
        }
        return true;
    }

    private boolean backupTopicCtrlConfig(StringBuilder strBuff) {
        logger.info("[Backup Topic Ctrl] begin ");
        Map<String, TopicCtrlEntity> topicCtrlMap = this.getTopicControlInfos(strBuff);
        if (topicCtrlMap == null) {
            logger.error("    download topic-control configures is null!");
            return false;
        }
        logger.info("[Backup Topic Ctrl] store topic-control configurations to local file");
        this.storeObjectToFile(topicCtrlMap, this.backupAndRecoveryPath, storeFileNameTopicCtrl);
        logger.info("[Backup Topic Ctrl] verify configurations");
        Map storedTopicCtrlMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameTopicCtrl);
        if (storedTopicCtrlMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameTopicCtrl).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        if (storedTopicCtrlMap.size() != topicCtrlMap.size()) {
            logger.error("  verify failure, stored topic-control size not equal!");
            return false;
        }
        for (Map.Entry<String, TopicCtrlEntity> qryEntry : topicCtrlMap.entrySet()) {
            TopicCtrlEntity targetEntity = (TopicCtrlEntity)storedTopicCtrlMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals(qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored topic-control value not equal!").append(" data in server is ").append(qryEntry.getValue().toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Backup Topic Ctrl] end, success!");
        return true;
    }

    private boolean recoveryTopicCtrlConfig(StringBuilder strBuff, ProcessResult result) {
        logger.info("[Recovery Topic Ctrl] begin ");
        Map storedTopicCtrlMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameTopicCtrl);
        if (storedTopicCtrlMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameTopicCtrl).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Topic Ctrl] upload topic-control configurations to master");
        if (!this.writeTopicCtrlInfo(storedTopicCtrlMap, strBuff, result)) {
            logger.error(strBuff.append("  write topic-control configurations failure!").append(result.getErrMsg()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Topic Ctrl] read restored topic-control configurations from master");
        Map<String, TopicCtrlEntity> topicCtrlMap = this.getTopicControlInfos(strBuff);
        if (topicCtrlMap == null) {
            logger.error("  download topic-control configurations are null!");
            return false;
        }
        logger.info("[Recovery Topic Ctrl] verify configurations");
        HashSet srcTopicSet = new HashSet(storedTopicCtrlMap.keySet());
        HashSet<String> tgtTopicSet = new HashSet<String>(topicCtrlMap.keySet());
        srcTopicSet.remove("__offset_history__");
        tgtTopicSet.remove("__offset_history__");
        if (srcTopicSet.size() != tgtTopicSet.size()) {
            logger.error("  verify failure, restored topic-control configurations size not equal!");
            return false;
        }
        for (Map.Entry qryEntry : storedTopicCtrlMap.entrySet()) {
            TopicCtrlEntity targetEntity = topicCtrlMap.get(qryEntry.getKey());
            if (targetEntity == null) {
                logger.error(strBuff.append("  verify failure, stored topic-control value not equal!").append(" data in server is ").append(((TopicCtrlEntity)qryEntry.getValue()).toString()).append(", data stored is null").toString());
                strBuff.delete(0, strBuff.length());
                return false;
            }
            if ((!targetEntity.getTopicName().equals("__offset_history__") || targetEntity.isMatched((TopicCtrlEntity)qryEntry.getValue(), false)) && (targetEntity.getTopicName().equals("__offset_history__") || targetEntity.isDataEquals((TopicCtrlEntity)qryEntry.getValue()))) continue;
            logger.error(strBuff.append("  verify failure, stored topic-control value not equal!").append(" data in server is ").append(((TopicCtrlEntity)qryEntry.getValue()).toString()).append(", data stored is ").append(targetEntity).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Topic Ctrl] end, success!");
        return true;
    }

    private Map<String, TopicCtrlEntity> getTopicControlInfos(StringBuilder strBuff) {
        JsonObject jsonRes = this.qryDataFromMaster("admin_query_topic_control_info", new HashMap<String, String>(), strBuff);
        if (!jsonRes.get("result").getAsBoolean()) {
            logger.info(strBuff.append("Query topic control configurations info failure:").append(jsonRes.get("result").getAsString()).toString());
            strBuff.delete(0, strBuff.length());
            return null;
        }
        HashMap<String, TopicCtrlEntity> topicCtrlMap = new HashMap<String, TopicCtrlEntity>();
        JsonArray jsonTopicCtrlList = jsonRes.get("data").getAsJsonArray();
        for (int i = 0; i < jsonTopicCtrlList.size(); ++i) {
            JsonObject jsonItem = jsonTopicCtrlList.get(i).getAsJsonObject();
            if (jsonItem == null) continue;
            try {
                BaseEntity baseEntity = this.getBaseEntityInfo(jsonItem);
                String topicName = jsonItem.get("topicName").getAsString();
                int topicNameId = jsonItem.get("topicNameId").getAsInt();
                boolean enableAuthCtrl = jsonItem.get("enableAuthControl").getAsBoolean();
                int maxMsgSizeInMB = jsonItem.get("maxMsgSizeInMB").getAsInt();
                EnableStatus authCtrlStatus = enableAuthCtrl ? EnableStatus.STATUS_ENABLE : EnableStatus.STATUS_DISABLE;
                TopicCtrlEntity topicCtrlEntity = new TopicCtrlEntity(baseEntity, topicName);
                topicCtrlEntity.updModifyInfo(baseEntity.getDataVerId(), topicNameId, maxMsgSizeInMB, authCtrlStatus);
                topicCtrlMap.put(topicCtrlEntity.getTopicName(), topicCtrlEntity);
                continue;
            }
            catch (Throwable e) {
                logger.error(strBuff.append("Parse topic control configurations(").append(jsonItem).append(") throw exception ").append(e).toString());
                strBuff.delete(0, strBuff.length());
                throw e;
            }
        }
        return topicCtrlMap;
    }

    private boolean writeTopicCtrlInfo(Map<String, TopicCtrlEntity> topicCtrlMap, StringBuilder strBuff, ProcessResult result) {
        TopicCtrlEntity entity;
        if (topicCtrlMap.isEmpty()) {
            return true;
        }
        int count = 0;
        HashMap<String, String> inParamMap = new HashMap<String, String>();
        for (TopicCtrlEntity entity2 : topicCtrlMap.values()) {
            if (entity2.getTopicName().equals("__offset_history__")) continue;
            if (count++ > 0) {
                strBuff.append(",");
            }
            entity2.toWebJsonStr(strBuff, true, true);
            if (strBuff.length() <= 150000 && count % 50 != 0) continue;
            inParamMap.put("topicCtrlJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_batch_add_topic_control_info", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            count = 0;
            inParamMap.clear();
            strBuff.delete(0, strBuff.length());
        }
        if (strBuff.length() > 0) {
            inParamMap.put("topicCtrlJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_batch_add_topic_control_info", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            strBuff.delete(0, strBuff.length());
        }
        if ((entity = topicCtrlMap.get("__offset_history__")) == null) {
            return true;
        }
        inParamMap.clear();
        entity.toWebJsonStr(strBuff, true, true);
        inParamMap.put("topicCtrlJsonSet", "[" + strBuff.toString() + "]");
        strBuff.delete(0, strBuff.length());
        inParamMap.put("createUser", curOperator);
        inParamMap.put("modifyUser", curOperator);
        if (!this.writeDataToMaster("admin_batch_update_topic_control_info", this.authToken, inParamMap, strBuff, result)) {
            return false;
        }
        strBuff.delete(0, strBuff.length());
        return true;
    }

    private boolean backupTopicDeployConfig(StringBuilder strBuff) {
        logger.info("[Backup Topic Deploy] begin ");
        Map<String, TopicDeployEntity> topicDeployMap = this.getTopicDeployInfos(strBuff);
        if (topicDeployMap == null) {
            logger.error("  download topic-deploy configurations is null!");
            return false;
        }
        logger.info("[Backup Topic Deploy] store topic-deploy configurations to local file");
        this.storeObjectToFile(topicDeployMap, this.backupAndRecoveryPath, storeFileNameTopicDeploy);
        logger.info("[Backup Topic Deploy] verify configurations");
        Map storedTopicDeployMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameTopicDeploy);
        if (storedTopicDeployMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameTopicDeploy).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        if (storedTopicDeployMap.size() != topicDeployMap.size()) {
            logger.error("  verify failure, stored topic-deploy configures size not equal!");
            return false;
        }
        for (Map.Entry<String, TopicDeployEntity> qryEntry : topicDeployMap.entrySet()) {
            TopicDeployEntity targetEntity = (TopicDeployEntity)storedTopicDeployMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals(qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored topic-deploy value not equal!").append(" data in server is ").append(qryEntry.getValue().toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            return false;
        }
        logger.info("[Backup Topic Deploy] end, success!");
        return true;
    }

    private boolean recoveryTopicDeployConfig(StringBuilder strBuff, ProcessResult result) {
        logger.info("[Recovery Topic Deploy] begin ");
        Map storedTopicDeployMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameTopicDeploy);
        if (storedTopicDeployMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameTopicDeploy).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Topic Deploy] upload topic-deploy configurations to master");
        if (!this.writeTopicDeployInfo(storedTopicDeployMap, strBuff, result)) {
            logger.error(strBuff.append("  write topic-deploy configurations failure!").append(result.getErrMsg()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Topic Deploy] read topic-deploy configurations from master");
        Map<String, TopicDeployEntity> topicDeployMap = this.getTopicDeployInfos(strBuff);
        if (topicDeployMap == null) {
            logger.error("  download topic deploy configurations is null!");
            return false;
        }
        logger.info("[Recovery Topic Deploy] verify configurations");
        HashSet<String> srcTopicSet = new HashSet<String>();
        for (TopicDeployEntity entity : storedTopicDeployMap.values()) {
            if (entity.getTopicName().equals("__offset_history__")) continue;
            srcTopicSet.add(entity.getRecordKey());
        }
        HashSet<String> tgtTopicSet = new HashSet<String>();
        for (TopicDeployEntity topicDeployEntity : topicDeployMap.values()) {
            if (topicDeployEntity.getTopicName().equals("__offset_history__")) continue;
            tgtTopicSet.add(topicDeployEntity.getRecordKey());
        }
        if (srcTopicSet.size() != tgtTopicSet.size()) {
            logger.error("  verify failure, stored topic-deploy configurations size not equal!");
            return false;
        }
        for (Map.Entry entry : storedTopicDeployMap.entrySet()) {
            TopicDeployEntity targetEntity = topicDeployMap.get(entry.getKey());
            if (targetEntity == null) {
                logger.error(strBuff.append("  verify failure, stored topic-deploy value not equal!").append(" data in server is ").append(((TopicDeployEntity)entry.getValue()).toString()).append(", data stored is null!").toString());
                return false;
            }
            if ((!targetEntity.getTopicName().equals("__offset_history__") || targetEntity.isMatched((TopicDeployEntity)entry.getValue(), false)) && (targetEntity.getTopicName().equals("__offset_history__") || targetEntity.isDataEquals((TopicDeployEntity)entry.getValue()))) continue;
            logger.error(strBuff.append("  verify failure, stored topic-deploy value not equal!").append(" data in server is ").append(((TopicDeployEntity)entry.getValue()).toString()).append(", data stored is ").append(targetEntity).toString());
            return false;
        }
        logger.info("[Recovery Topic Deploy] end, success!");
        return true;
    }

    private Map<String, TopicDeployEntity> getTopicDeployInfos(StringBuilder strBuff) {
        JsonObject jsonRes = this.qryDataFromMaster("admin_query_topic_deploy_configure", new HashMap<String, String>(), strBuff);
        if (!jsonRes.get("result").getAsBoolean()) {
            logger.info(strBuff.append("Query topic deploy configurations info failure:").append(jsonRes.get("result").getAsString()).toString());
            strBuff.delete(0, strBuff.length());
            return null;
        }
        HashMap<String, TopicDeployEntity> topicDeployMap = new HashMap<String, TopicDeployEntity>();
        JsonArray jsonTopicDeployList = jsonRes.get("data").getAsJsonArray();
        for (int i = 0; i < jsonTopicDeployList.size(); ++i) {
            JsonObject jsonItem = jsonTopicDeployList.get(i).getAsJsonObject();
            if (jsonItem == null) continue;
            try {
                BaseEntity baseEntity = this.getBaseEntityInfo(jsonItem);
                TopicPropGroup topicPropGroup = this.getTopicProps(jsonItem);
                String topicName = jsonItem.get("topicName").getAsString();
                int brokerId = jsonItem.get("brokerId").getAsInt();
                int topicNameId = jsonItem.get("topicNameId").getAsInt();
                String brokerIp = jsonItem.get("brokerIp").getAsString();
                int brokerPort = jsonItem.get("brokerPort").getAsInt();
                int topicStatusId = jsonItem.get("topicStatusId").getAsInt();
                TopicStatus deployStatus = TopicStatus.valueOf(topicStatusId);
                TopicDeployEntity topicDeployEntity = new TopicDeployEntity(baseEntity, brokerId, topicName);
                topicDeployEntity.updModifyInfo(baseEntity.getDataVerId(), topicNameId, brokerPort, brokerIp, deployStatus, topicPropGroup);
                topicDeployMap.put(topicDeployEntity.getRecordKey(), topicDeployEntity);
                continue;
            }
            catch (Throwable e) {
                logger.error(strBuff.append("Parse topic deploy configurations(").append(jsonItem).append(") throw exception ").append(e).toString());
                strBuff.delete(0, strBuff.length());
                throw e;
            }
        }
        return topicDeployMap;
    }

    private boolean writeTopicDeployInfo(Map<String, TopicDeployEntity> topicDeployMap, StringBuilder strBuff, ProcessResult result) {
        if (topicDeployMap.isEmpty()) {
            return true;
        }
        int count = 0;
        HashMap<String, String> inParamMap = new HashMap<String, String>();
        HashMap<String, TopicDeployEntity> sysTopicDeployMap = new HashMap<String, TopicDeployEntity>();
        for (TopicDeployEntity entity : topicDeployMap.values()) {
            if (entity.getTopicName().equals("__offset_history__")) {
                sysTopicDeployMap.put(entity.getRecordKey(), entity);
                continue;
            }
            if (count++ > 0) {
                strBuff.append(",");
            }
            entity.toWebJsonStr(strBuff, true, true);
            if (strBuff.length() <= 150000 && count % 50 != 0) continue;
            inParamMap.put("topicJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_bath_add_topic_deploy_info", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            count = 0;
            inParamMap.clear();
            strBuff.delete(0, strBuff.length());
        }
        if (strBuff.length() > 0) {
            inParamMap.put("topicJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_bath_add_topic_deploy_info", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            strBuff.delete(0, strBuff.length());
        }
        count = 0;
        inParamMap.clear();
        for (TopicDeployEntity entity : sysTopicDeployMap.values()) {
            if (count++ > 0) {
                strBuff.append(",");
            }
            entity.toWebJsonStr(strBuff, true, true);
            if (strBuff.length() <= 150000 && count % 50 != 0) continue;
            inParamMap.put("topicJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_batch_update_topic_deploy_info", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            count = 0;
            inParamMap.clear();
            strBuff.delete(0, strBuff.length());
        }
        if (strBuff.length() > 0) {
            inParamMap.put("topicJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_batch_update_topic_deploy_info", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            strBuff.delete(0, strBuff.length());
        }
        return true;
    }

    private boolean backupGroupCtrlConfig(StringBuilder strBuff) {
        logger.info("[Backup Group Ctrl] begin ");
        Map<String, GroupResCtrlEntity> groupCtrlMap = this.getGroupResCtrlInfos(strBuff);
        if (groupCtrlMap == null) {
            logger.error("  download group-control configurations are null!");
            return false;
        }
        logger.info("[Backup Group Ctrl] store group-control configurations to local file");
        this.storeObjectToFile(groupCtrlMap, this.backupAndRecoveryPath, storeFileNameGroupCtrl);
        logger.info("[Backup Group Ctrl] verify configurations");
        Map storedGroupCtrlMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameGroupCtrl);
        if (storedGroupCtrlMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameGroupCtrl).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        if (storedGroupCtrlMap.size() != groupCtrlMap.size()) {
            logger.error("  verify failure, stored group-control configurations size not equal!");
            return false;
        }
        for (Map.Entry<String, GroupResCtrlEntity> qryEntry : groupCtrlMap.entrySet()) {
            GroupResCtrlEntity targetEntity = (GroupResCtrlEntity)storedGroupCtrlMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals(qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored group-control value not equal!").append(" data in server is ").append(qryEntry.getValue().toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Backup Group Ctrl] end, success!");
        return true;
    }

    private boolean recoveryGroupCtrlConfig(StringBuilder strBuff, ProcessResult result) {
        logger.info("[Recovery Group Ctrl] begin ");
        Map storedGroupCtrlMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameGroupCtrl);
        if (storedGroupCtrlMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameGroupCtrl).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Group Ctrl] upload group-control configurations to master");
        if (!this.writeGroupResCtrlInfo(storedGroupCtrlMap, strBuff, result)) {
            logger.error(strBuff.append("  write group-control configurations failure!").append(result.getErrMsg()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Group Ctrl] read restored group-control configurations from master");
        Map<String, GroupResCtrlEntity> groupCtrlMap = this.getGroupResCtrlInfos(strBuff);
        if (groupCtrlMap == null) {
            logger.error("  download group-control configurations is null!");
            return false;
        }
        logger.info("[Recovery Group Ctrl] verify configurations");
        if (groupCtrlMap.size() != storedGroupCtrlMap.size()) {
            logger.error("  verify failure, stored group-control configurations size not equal!");
            return false;
        }
        for (Map.Entry qryEntry : storedGroupCtrlMap.entrySet()) {
            GroupResCtrlEntity targetEntity = groupCtrlMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals((GroupResCtrlEntity)qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored group-control value not equal!").append(" data in server is ").append(((GroupResCtrlEntity)qryEntry.getValue()).toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            return false;
        }
        logger.info("[Recovery Group Ctrl] end, success!");
        return true;
    }

    private Map<String, GroupResCtrlEntity> getGroupResCtrlInfos(StringBuilder strBuff) {
        JsonObject jsonRes = this.qryDataFromMaster("admin_query_group_resctrl_info", new HashMap<String, String>(), strBuff);
        if (!jsonRes.get("result").getAsBoolean()) {
            logger.info(strBuff.append("Query group resource control configurations info failure:").append(jsonRes.get("result").getAsString()).toString());
            strBuff.delete(0, strBuff.length());
            return null;
        }
        HashMap<String, GroupResCtrlEntity> groupResCtrlMap = new HashMap<String, GroupResCtrlEntity>();
        JsonArray jsonGroupResCtrlList = jsonRes.get("data").getAsJsonArray();
        for (int i = 0; i < jsonGroupResCtrlList.size(); ++i) {
            JsonObject jsonItem = jsonGroupResCtrlList.get(i).getAsJsonObject();
            if (jsonItem == null) continue;
            try {
                BaseEntity baseEntity = this.getBaseEntityInfo(jsonItem);
                String groupName = jsonItem.get("groupName").getAsString();
                boolean resCheckEnable = jsonItem.get("resCheckEnable").getAsBoolean();
                int alwdBCRate = jsonItem.get("alwdBrokerClientRate").getAsInt();
                int qryPriorityId = jsonItem.get("qryPriorityId").getAsInt();
                boolean flowCtrlEnable = jsonItem.get("flowCtrlEnable").getAsBoolean();
                int flowCtrlRuleCount = jsonItem.get("flowCtrlRuleCount").getAsInt();
                JsonArray flowCtrlInfoArray = jsonItem.get("flowCtrlInfo").getAsJsonArray();
                String flowCtrlInfoStr = flowCtrlInfoArray.toString();
                EnableStatus resChkStatus = resCheckEnable ? EnableStatus.STATUS_ENABLE : EnableStatus.STATUS_DISABLE;
                EnableStatus flowCtrlStatus = flowCtrlEnable ? EnableStatus.STATUS_ENABLE : EnableStatus.STATUS_DISABLE;
                GroupResCtrlEntity groupResCtrlEntity = new GroupResCtrlEntity(baseEntity, groupName);
                groupResCtrlEntity.updModifyInfo(baseEntity.getDataVerId(), resChkStatus, alwdBCRate, qryPriorityId, flowCtrlStatus, flowCtrlRuleCount, flowCtrlInfoStr);
                groupResCtrlMap.put(groupResCtrlEntity.getGroupName(), groupResCtrlEntity);
                continue;
            }
            catch (Throwable e) {
                logger.error(strBuff.append("Parse group resource control configurations(").append(jsonItem).append(") throw exception ").append(e).toString());
                strBuff.delete(0, strBuff.length());
                throw e;
            }
        }
        return groupResCtrlMap;
    }

    private boolean writeGroupResCtrlInfo(Map<String, GroupResCtrlEntity> groupResCtrlMap, StringBuilder strBuff, ProcessResult result) {
        if (groupResCtrlMap.isEmpty()) {
            return true;
        }
        HashMap<String, String> inParamMap = new HashMap<String, String>();
        for (GroupResCtrlEntity entity : groupResCtrlMap.values()) {
            inParamMap.clear();
            inParamMap.put("groupName", entity.getGroupName());
            inParamMap.put("resCheckEnable", String.valueOf(entity.isEnableResCheck()));
            inParamMap.put("alwdBrokerClientRate", String.valueOf(entity.getAllowedBrokerClientRate()));
            inParamMap.put("qryPriorityId", String.valueOf(entity.getQryPriorityId()));
            inParamMap.put("flowCtrlEnable", String.valueOf(entity.isFlowCtrlEnable()));
            inParamMap.put("flowCtrlInfo", String.valueOf(entity.getFlowCtrlInfo()));
            inParamMap.put("dataVersionId", String.valueOf(entity.getDataVerId()));
            inParamMap.put("createUser", String.valueOf(entity.getCreateUser()));
            inParamMap.put("createDate", String.valueOf(entity.getCreateDateStr()));
            inParamMap.put("modifyUser", String.valueOf(entity.getModifyUser()));
            inParamMap.put("modifyDate", String.valueOf(entity.getModifyDateStr()));
            if (this.writeDataToMaster("admin_add_group_resctrl_info", this.authToken, inParamMap, strBuff, result)) continue;
            return false;
        }
        return true;
    }

    private boolean backupConsumeCtrlConfig(StringBuilder strBuff) {
        logger.info("[Backup Csm Ctrl] begin ");
        Map<String, GroupConsumeCtrlEntity> groupCsmInfoMap = this.getGroupCsmCtrlInfos(strBuff);
        if (groupCsmInfoMap == null) {
            logger.error("  download consume-ctrl configurations is null!");
            return false;
        }
        logger.info("[Backup Csm Ctrl] store consume-ctrl configurations to local file");
        this.storeObjectToFile(groupCsmInfoMap, this.backupAndRecoveryPath, storeFileNameCsmCtrl);
        logger.info("[Backup Csm Ctrl] verify configurations");
        Map storedGroupCsmMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameCsmCtrl);
        if (storedGroupCsmMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameCsmCtrl).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        if (storedGroupCsmMap.size() != groupCsmInfoMap.size()) {
            logger.error("  verify failure, stored consume-ctrl configures size not equal!");
            return false;
        }
        for (Map.Entry<String, GroupConsumeCtrlEntity> qryEntry : groupCsmInfoMap.entrySet()) {
            GroupConsumeCtrlEntity targetEntity = (GroupConsumeCtrlEntity)storedGroupCsmMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals(qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored consume-ctrl value not equal!").append(" data in server is ").append(qryEntry.getValue().toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Backup Csm Ctrl] end, success!");
        return true;
    }

    private boolean recoveryConsumeCtrlConfig(StringBuilder strBuff, ProcessResult result) {
        logger.info("[Recovery Csm Ctrl] begin ");
        Map storedGroupCsmMap = (Map)this.readObjectFromFile(this.backupAndRecoveryPath, storeFileNameCsmCtrl);
        if (storedGroupCsmMap == null) {
            logger.error(strBuff.append("  read configure file ").append(this.backupAndRecoveryPath).append("/").append(storeFileNameCsmCtrl).append(" failure!").toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Csm Ctrl] upload consume-control configurations to master");
        if (!this.writeGroupCsmInfo(storedGroupCsmMap, strBuff, result)) {
            logger.error(strBuff.append("  write consume-control configurations failure!").append(result.getErrMsg()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Csm Ctrl] read restored consume-control configurations from master");
        Map<String, GroupConsumeCtrlEntity> groupCsmInfoMap = this.getGroupCsmCtrlInfos(strBuff);
        if (groupCsmInfoMap == null) {
            logger.error("  download consume-control configurations are null!");
            return false;
        }
        logger.info("[Recovery Csm Ctrl] verify configurations");
        if (groupCsmInfoMap.size() != storedGroupCsmMap.size()) {
            logger.error("  verify failure, stored consume-control configurations size not equal!");
            return false;
        }
        for (Map.Entry qryEntry : storedGroupCsmMap.entrySet()) {
            GroupConsumeCtrlEntity targetEntity = groupCsmInfoMap.get(qryEntry.getKey());
            if (targetEntity != null && targetEntity.isDataEquals((GroupConsumeCtrlEntity)qryEntry.getValue()) && targetEntity.isMatched((GroupConsumeCtrlEntity)qryEntry.getValue())) continue;
            logger.error(strBuff.append("  verify failure, stored consume-control value not equal!").append(" data in server is ").append(((GroupConsumeCtrlEntity)qryEntry.getValue()).toString()).append(", data stored is ").append(targetEntity == null ? null : targetEntity.toString()).toString());
            strBuff.delete(0, strBuff.length());
            return false;
        }
        logger.info("[Recovery Csm Ctrl] end, success!");
        return true;
    }

    private Map<String, GroupConsumeCtrlEntity> getGroupCsmCtrlInfos(StringBuilder strBuff) {
        JsonObject jsonRes = this.qryDataFromMaster("admin_query_group_csmctrl_info", new HashMap<String, String>(), strBuff);
        if (!jsonRes.get("result").getAsBoolean()) {
            logger.info(strBuff.append("Query group consume control configurations info failure:").append(jsonRes.get("result").getAsString()).toString());
            strBuff.delete(0, strBuff.length());
            return null;
        }
        HashMap<String, GroupConsumeCtrlEntity> groupCsmCtrlMap = new HashMap<String, GroupConsumeCtrlEntity>();
        JsonArray jsonGroupCsmCtrlList = jsonRes.get("data").getAsJsonArray();
        for (int i = 0; i < jsonGroupCsmCtrlList.size(); ++i) {
            JsonObject jsonItem = jsonGroupCsmCtrlList.get(i).getAsJsonObject();
            if (jsonItem == null) continue;
            try {
                BaseEntity baseEntity = this.getBaseEntityInfo(jsonItem);
                String groupName = jsonItem.get("groupName").getAsString();
                String topicName = jsonItem.get("topicName").getAsString();
                boolean consumeEnable = jsonItem.get("consumeEnable").getAsBoolean();
                String disableCsmRsn = jsonItem.get("disableCsmRsn").getAsString();
                boolean filterEnable = jsonItem.get("filterEnable").getAsBoolean();
                String filterConds = jsonItem.get("filterConds").getAsString();
                EnableStatus csmStatus = consumeEnable ? EnableStatus.STATUS_ENABLE : EnableStatus.STATUS_DISABLE;
                EnableStatus filterStatus = filterEnable ? EnableStatus.STATUS_ENABLE : EnableStatus.STATUS_DISABLE;
                GroupConsumeCtrlEntity groupCsmCtrlEntity = new GroupConsumeCtrlEntity(baseEntity, groupName, topicName);
                groupCsmCtrlEntity.updModifyInfo(baseEntity.getDataVerId(), csmStatus, disableCsmRsn, filterStatus, filterConds);
                groupCsmCtrlMap.put(groupCsmCtrlEntity.getRecordKey(), groupCsmCtrlEntity);
                continue;
            }
            catch (Throwable e) {
                logger.error(strBuff.append("Parse group consume control configurations(").append(jsonItem).append(") throw exception ").append(e).toString());
                strBuff.delete(0, strBuff.length());
                throw e;
            }
        }
        return groupCsmCtrlMap;
    }

    private boolean writeGroupCsmInfo(Map<String, GroupConsumeCtrlEntity> groupCsmMap, StringBuilder strBuff, ProcessResult result) {
        if (groupCsmMap.isEmpty()) {
            return true;
        }
        int count = 0;
        HashMap<String, String> inParamMap = new HashMap<String, String>();
        for (GroupConsumeCtrlEntity entity : groupCsmMap.values()) {
            if (count++ > 0) {
                strBuff.append(",");
            }
            entity.toWebJsonStr(strBuff, true, true);
            if (strBuff.length() <= 150000 && count % 50 != 0) continue;
            inParamMap.put("groupCsmJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_batch_add_group_csmctrl_info", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            count = 0;
            inParamMap.clear();
            strBuff.delete(0, strBuff.length());
        }
        if (strBuff.length() > 0) {
            inParamMap.put("groupCsmJsonSet", "[" + strBuff.toString() + "]");
            strBuff.delete(0, strBuff.length());
            inParamMap.put("createUser", curOperator);
            inParamMap.put("modifyUser", curOperator);
            if (!this.writeDataToMaster("admin_batch_add_group_csmctrl_info", this.authToken, inParamMap, strBuff, result)) {
                return false;
            }
            strBuff.delete(0, strBuff.length());
        }
        return true;
    }

    private BaseEntity getBaseEntityInfo(JsonObject jsonItem) {
        long dataVersionId = jsonItem.get("dataVersionId").getAsInt();
        String createUser = jsonItem.get("createUser").getAsString();
        String createDateStr = jsonItem.get("createDate").getAsString();
        Date createDate = DateTimeConvertUtils.yyyyMMddHHmmss2date((String)createDateStr);
        String modifyUser = jsonItem.get("modifyUser").getAsString();
        String modifyDateStr = jsonItem.get("modifyDate").getAsString();
        Date modifyDate = DateTimeConvertUtils.yyyyMMddHHmmss2date((String)modifyDateStr);
        return new BaseEntity(dataVersionId, createUser, createDate, modifyUser, modifyDate);
    }

    private TopicPropGroup getTopicProps(JsonObject jsonItem) {
        int numTopicStores = jsonItem.get("numTopicStores").getAsInt();
        int numPartitions = jsonItem.get("numPartitions").getAsInt();
        int unflushThreshold = jsonItem.get("unflushThreshold").getAsInt();
        int unflushInterval = jsonItem.get("unflushInterval").getAsInt();
        int unflushDataHold = jsonItem.get("unflushDataHold").getAsInt();
        int memCacheMsgSizeInMB = jsonItem.get("memCacheMsgSizeInMB").getAsInt();
        int memCacheMsgCntInK = jsonItem.get("memCacheMsgCntInK").getAsInt();
        int memCacheFlushIntvl = jsonItem.get("memCacheFlushIntvl").getAsInt();
        boolean acceptPublish = jsonItem.get("acceptPublish").getAsBoolean();
        boolean acceptSubscribe = jsonItem.get("acceptSubscribe").getAsBoolean();
        String deletePolicy = jsonItem.get("deletePolicy").getAsString();
        int dataStoreType = jsonItem.get("dataStoreType").getAsInt();
        String dataPath = jsonItem.get("dataPath").getAsString();
        return new TopicPropGroup(numTopicStores, numPartitions, unflushThreshold, unflushInterval, unflushDataHold, memCacheMsgSizeInMB, memCacheMsgCntInK, memCacheFlushIntvl, acceptPublish, acceptSubscribe, deletePolicy, dataStoreType, dataPath);
    }

    private JsonObject qryDataFromMaster(String method, Map<String, String> inParamMap, StringBuilder strBuff) {
        JsonObject jsonRes = null;
        for (String address : this.masterInfo.getNodeHostPortList()) {
            String visitUrl = strBuff.append("http://").append(address).append("/webapi.htm?method=").append(method).toString();
            strBuff.delete(0, strBuff.length());
            try {
                jsonRes = HttpUtils.requestWebService(visitUrl, inParamMap);
                if (jsonRes == null) continue;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        return jsonRes;
    }

    private boolean writeDataToMaster(String method, String opCode, Map<String, String> inParamMap, StringBuilder strBuff, ProcessResult result) {
        JsonObject jsonRes = null;
        for (String address : this.masterInfo.getNodeHostPortList()) {
            String visitUrl = strBuff.append("http://").append(address).append("/webapi.htm?method=").append(method).append("&confModAuthToken=").append(opCode).toString();
            strBuff.delete(0, strBuff.length());
            try {
                jsonRes = HttpUtils.requestWebService(visitUrl, inParamMap);
                if (jsonRes == null) continue;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (jsonRes == null) {
            result.setFailResult(400, "Connect master failure!");
        } else if (jsonRes.get("result").getAsBoolean()) {
            result.setSuccResult();
        } else {
            result.setFailResult(jsonRes.get("errCode").getAsInt(), jsonRes.get("errMsg").getAsString());
        }
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object readObjectFromFile(String configPath, String fileName) {
        Object var6_8;
        FileInputStream fis;
        block17: {
            block15: {
                Object object;
                block16: {
                    fis = null;
                    File file = configPath.lastIndexOf(File.separator) != configPath.length() - 1 ? new File(configPath + File.separator + fileName + ".conf") : new File(configPath + fileName + ".conf");
                    if (!file.exists()) break block15;
                    fis = new FileInputStream(file);
                    ObjectInputStream is = new ObjectInputStream(fis);
                    Object entry = is.readObject();
                    fis.close();
                    object = entry;
                    if (fis == null) break block16;
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return object;
            }
            var6_8 = null;
            if (fis == null) break block17;
            try {
                fis.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return var6_8;
        catch (Throwable e1) {
            try {
                logger.error("store " + fileName + " exception", e1);
                Object var6_9 = null;
                return var6_9;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeObjectToFile(Object storeObj, String configPath, String fileName) {
        FileOutputStream fos = null;
        try {
            File file = configPath.lastIndexOf(File.separator) != configPath.length() - 1 ? new File(configPath + File.separator + fileName + ".conf") : new File(configPath + fileName + ".conf");
            logger.info("Store address is " + file.getAbsolutePath());
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            ObjectOutputStream p = new ObjectOutputStream(fos);
            p.writeObject(storeObj);
            p.flush();
        }
        catch (Throwable e) {
            logger.warn("store " + fileName + " exception", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable file) {}
            }
        }
    }
}

