/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SecurityConfigurationBuilder;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;

@RestController
@ApiIgnore
@RequestMapping(value={"${springfox.documentation.swagger-ui.base-url:}/swagger-resources"})
public class ApiResourceController {
    @Autowired(required=false)
    private SecurityConfiguration securityConfiguration;
    @Autowired(required=false)
    private UiConfiguration uiConfiguration;
    private final SwaggerResourcesProvider swaggerResources;

    @Autowired
    public ApiResourceController(SwaggerResourcesProvider swaggerResources, @Value(value="${springfox.documentation.swagger-ui.base-url:}") String swaggerUiBaseUrl) {
        this.swaggerResources = swaggerResources;
        this.uiConfiguration = UiConfigurationBuilder.builder().copyOf(this.uiConfiguration).swaggerUiBaseUrl(StringUtils.trimTrailingCharacter((String)swaggerUiBaseUrl, (char)'/')).build();
        this.securityConfiguration = SecurityConfigurationBuilder.builder().copyOf(this.securityConfiguration).build();
    }

    @GetMapping(value={"/configuration/security"}, produces={"application/json"})
    public ResponseEntity<SecurityConfiguration> securityConfiguration() {
        return new ResponseEntity((Object)this.securityConfiguration, HttpStatus.OK);
    }

    @GetMapping(value={"/configuration/ui"}, produces={"application/json"})
    public ResponseEntity<UiConfiguration> uiConfiguration() {
        return new ResponseEntity((Object)this.uiConfiguration, HttpStatus.OK);
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<List<SwaggerResource>> swaggerResources() {
        return new ResponseEntity((Object)((List)this.swaggerResources.get()), HttpStatus.OK);
    }
}

