/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.entry;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.inlong.tubemq.manager.utils.ValidateUtils;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="region", uniqueConstraints={@UniqueConstraint(columnNames={"clusterId", "regionId"}), @UniqueConstraint(columnNames={"id"})})
@EntityListeners(value={AuditingEntityListener.class})
public class RegionEntry {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private Long regionId;
    private String name;
    @CreatedDate
    private Date createDate;
    @LastModifiedDate
    private Date modifyDate;
    private String createUser;
    private String modifyUser;
    private Long clusterId;

    public boolean legal() {
        return !ValidateUtils.isNull(this.clusterId);
    }

    public Long getId() {
        return this.id;
    }

    public Long getRegionId() {
        return this.regionId;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public String getModifyUser() {
        return this.modifyUser;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionEntry)) {
            return false;
        }
        RegionEntry other = (RegionEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$regionId = this.getRegionId();
        Long other$regionId = other.getRegionId();
        if (this$regionId == null ? other$regionId != null : !((Object)this$regionId).equals(other$regionId)) {
            return false;
        }
        Long this$clusterId = this.getClusterId();
        Long other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !((Object)this$clusterId).equals(other$clusterId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        Date this$modifyDate = this.getModifyDate();
        Date other$modifyDate = other.getModifyDate();
        if (this$modifyDate == null ? other$modifyDate != null : !((Object)this$modifyDate).equals(other$modifyDate)) {
            return false;
        }
        String this$createUser = this.getCreateUser();
        String other$createUser = other.getCreateUser();
        if (this$createUser == null ? other$createUser != null : !this$createUser.equals(other$createUser)) {
            return false;
        }
        String this$modifyUser = this.getModifyUser();
        String other$modifyUser = other.getModifyUser();
        return !(this$modifyUser == null ? other$modifyUser != null : !this$modifyUser.equals(other$modifyUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegionEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $regionId = this.getRegionId();
        result = result * 59 + ($regionId == null ? 43 : ((Object)$regionId).hashCode());
        Long $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : ((Object)$clusterId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        Date $modifyDate = this.getModifyDate();
        result = result * 59 + ($modifyDate == null ? 43 : ((Object)$modifyDate).hashCode());
        String $createUser = this.getCreateUser();
        result = result * 59 + ($createUser == null ? 43 : $createUser.hashCode());
        String $modifyUser = this.getModifyUser();
        result = result * 59 + ($modifyUser == null ? 43 : $modifyUser.hashCode());
        return result;
    }

    public String toString() {
        return "RegionEntry(id=" + this.getId() + ", regionId=" + this.getRegionId() + ", name=" + this.getName() + ", createDate=" + this.getCreateDate() + ", modifyDate=" + this.getModifyDate() + ", createUser=" + this.getCreateUser() + ", modifyUser=" + this.getModifyUser() + ", clusterId=" + this.getClusterId() + ")";
    }
}

