/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentThreadFactory
implements ThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentThreadFactory.class);
    public static final String NAMED_THREAD_PLACEHOLDER = "agent-thread-factory";
    private final AtomicInteger mThreadNum = new AtomicInteger(1);
    private final String threadType;

    public AgentThreadFactory(String threadType) {
        this.threadType = threadType;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.threadType + "-" + NAMED_THREAD_PLACEHOLDER + "-" + this.mThreadNum.getAndIncrement());
        if (AgentUtils.enableOOMExit()) {
            t.setUncaughtExceptionHandler(ThreadUtils::threadThrowableHandler);
        }
        LOGGER.debug("{} created", (Object)t.getName());
        return t;
    }

    public static void nameThread(String uniqueName) {
        Thread.currentThread().setName(Thread.currentThread().getName().replace(NAMED_THREAD_PLACEHOLDER, uniqueName));
    }
}

