/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

public final class ReadOnlyArrayMap<K, V>
extends AbstractMap<K, V> {
    private final List<Object> array;
    private final int size;

    public static <K, V> Map<K, V> wrap(List<Object> array) {
        if (array.isEmpty()) {
            return Collections.emptyMap();
        }
        return new ReadOnlyArrayMap<K, V>(array);
    }

    private ReadOnlyArrayMap(List<Object> array) {
        this.array = array;
        this.size = array.size() / 2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object o) {
        if (o == null) {
            return false;
        }
        return this.arrayIndexOfKey(o) != -1;
    }

    @Override
    public boolean containsValue(Object o) {
        for (int i = 0; i < this.array.size(); i += 2) {
            if (!this.value(i + 1).equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public V get(Object o) {
        if (o == null) {
            return null;
        }
        int i = this.arrayIndexOfKey(o);
        return i != -1 ? (V)this.value(i + 1) : null;
    }

    int arrayIndexOfKey(Object o) {
        int result = -1;
        for (int i = 0; i < this.array.size(); i += 2) {
            if (!o.equals(this.key(i))) continue;
            return i;
        }
        return result;
    }

    K key(int i) {
        return (K)this.array.get(i);
    }

    V value(int i) {
        return (V)this.array.get(i);
    }

    @Override
    public Set<K> keySet() {
        return new KeySetView();
    }

    @Override
    public Collection<V> values() {
        return new ValuesView();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySetView();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ReadOnlyArrayMap{");
        for (int i = 0; i < this.array.size(); i += 2) {
            result.append(this.key(i)).append('=').append(this.value(i + 1));
            result.append(',');
        }
        result.setLength(result.length() - 1);
        return result.append("}").toString();
    }

    final class KeySetView
    extends SetView<K> {
        KeySetView() {
        }

        @Override
        K elementAtArrayIndex(int i) {
            return ReadOnlyArrayMap.this.key(i);
        }

        @Override
        public boolean contains(Object o) {
            return ReadOnlyArrayMap.this.containsKey(o);
        }
    }

    final class ValuesView
    extends SetView<V> {
        ValuesView() {
        }

        @Override
        V elementAtArrayIndex(int i) {
            return ReadOnlyArrayMap.this.value(i + 1);
        }

        @Override
        public boolean contains(Object o) {
            return ReadOnlyArrayMap.this.containsValue(o);
        }
    }

    final class EntrySetView
    extends SetView<Map.Entry<K, V>> {
        EntrySetView() {
        }

        @Override
        Map.Entry<K, V> elementAtArrayIndex(int i) {
            return new AbstractMap.SimpleImmutableEntry(ReadOnlyArrayMap.this.key(i), ReadOnlyArrayMap.this.value(i + 1));
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry) || ((Map.Entry)o).getKey() == null) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            int i = ReadOnlyArrayMap.this.arrayIndexOfKey(that.getKey());
            if (i == -1) {
                return false;
            }
            return ReadOnlyArrayMap.this.value(i + 1).equals(that.getValue());
        }
    }

    abstract class SetView<E>
    implements Set<E> {
        SetView() {
        }

        @Override
        public int size() {
            return ReadOnlyArrayMap.this.size;
        }

        abstract E elementAtArrayIndex(int var1);

        @Override
        public Iterator<E> iterator() {
            return new ReadOnlyIterator();
        }

        @Override
        public Object[] toArray() {
            return this.copyTo(new Object[ReadOnlyArrayMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= ReadOnlyArrayMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
            return this.copyTo(result);
        }

        <T> T[] copyTo(T[] dest) {
            int d = 0;
            for (int i = 0; i < ReadOnlyArrayMap.this.array.size(); i += 2) {
                dest[d++] = this.elementAtArrayIndex(i);
            }
            return dest;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c == null) {
                return false;
            }
            if (c.isEmpty()) {
                return true;
            }
            for (Object element : c) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        final class ReadOnlyIterator
        implements Iterator<E> {
            int current = 0;

            ReadOnlyIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.current < ReadOnlyArrayMap.this.array.size();
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = SetView.this.elementAtArrayIndex(this.current);
                this.current += 2;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

