/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.entity.vo;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

public class BranchSessionVO {
    private String xid;
    private String transactionId;
    private String branchId;
    private String resourceGroupId;
    private String resourceId;
    private String branchType;
    private Integer status;
    private String clientId;
    private String applicationData;
    private Long gmtCreate;
    private Long gmtModified;

    public BranchSessionVO() {
    }

    public BranchSessionVO(String xid, Long transactionId, Long branchId, String resourceGroupId, String resourceId, String branchType, Integer status, String clientId, String applicationData) {
        this.xid = xid;
        this.transactionId = String.valueOf(transactionId);
        this.branchId = String.valueOf(branchId);
        this.resourceGroupId = resourceGroupId;
        this.resourceId = resourceId;
        this.branchType = branchType;
        this.status = status;
        this.clientId = clientId;
        this.applicationData = applicationData;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = String.valueOf(transactionId);
    }

    public String getBranchId() {
        return this.branchId;
    }

    public void setBranchId(Long branchId) {
        this.branchId = String.valueOf(branchId);
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public void setResourceGroupId(String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getBranchType() {
        return this.branchType;
    }

    public void setBranchType(String branchType) {
        this.branchType = branchType;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Long getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public static BranchSessionVO convert(ResultSet rs) throws SQLException {
        Date gmtModifiedTimestamp;
        BranchSessionVO branchSessionVO = new BranchSessionVO();
        branchSessionVO.setXid(rs.getString("xid"));
        branchSessionVO.setTransactionId(rs.getLong("transaction_id"));
        branchSessionVO.setBranchId(rs.getLong("branch_id"));
        branchSessionVO.setResourceGroupId(rs.getString("resource_group_id"));
        branchSessionVO.setResourceId(rs.getString("resource_id"));
        branchSessionVO.setBranchType(rs.getString("branch_type"));
        branchSessionVO.setStatus(rs.getInt("status"));
        branchSessionVO.setClientId(rs.getString("client_id"));
        branchSessionVO.setApplicationData(rs.getString("application_data"));
        Date gmtCreateTimestamp = rs.getDate("gmt_create");
        if (gmtCreateTimestamp != null) {
            branchSessionVO.setGmtCreate(gmtCreateTimestamp.getTime());
        }
        if ((gmtModifiedTimestamp = rs.getDate("gmt_modified")) != null) {
            branchSessionVO.setGmtModified(gmtModifiedTimestamp.getTime());
        }
        return branchSessionVO;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BranchSessionVO that = (BranchSessionVO)o;
        return Objects.equals(this.xid, that.xid) && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.branchId, that.branchId) && Objects.equals(this.resourceGroupId, that.resourceGroupId) && Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.branchType, that.branchType) && Objects.equals(this.status, that.status) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.applicationData, that.applicationData) && Objects.equals(this.gmtCreate, that.gmtCreate) && Objects.equals(this.gmtModified, that.gmtModified);
    }

    public int hashCode() {
        return Objects.hash(this.xid, this.transactionId, this.branchId, this.resourceGroupId, this.resourceId, this.branchType, this.status, this.clientId, this.applicationData, this.gmtCreate, this.gmtModified);
    }

    public String toString() {
        return "BranchSessionVO{xid='" + this.xid + '\'' + ", transactionId=" + this.transactionId + ", branchId=" + this.branchId + ", resourceGroupId='" + this.resourceGroupId + '\'' + ", resourceId='" + this.resourceId + '\'' + ", branchType='" + this.branchType + '\'' + ", status=" + this.status + ", clientId='" + this.clientId + '\'' + ", applicationData='" + this.applicationData + '\'' + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + '}';
    }
}

