/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http.filter;

import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.seata.common.rpc.http.HttpContext;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestParamWrapper;

public class HttpFilterContext<T>
extends HttpContext<T> {
    private final Supplier<HttpRequestParamWrapper> paramWrapperSupplier;
    private volatile HttpRequestParamWrapper paramWrapper;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private static final ThreadLocal<HttpFilterContext<?>> CURRENT_CONTEXT = new ThreadLocal();
    private Object response;

    public HttpFilterContext(T request, ChannelHandlerContext channelHandlerContext, boolean keepAlive, String httpVersion, Supplier<HttpRequestParamWrapper> paramWrapperSupplier) {
        super(request, channelHandlerContext, keepAlive, httpVersion);
        this.paramWrapperSupplier = paramWrapperSupplier;
    }

    public static HttpFilterContext<?> getCurrentContext() {
        return CURRENT_CONTEXT.get();
    }

    public static void setCurrentContext(HttpFilterContext<?> context) {
        CURRENT_CONTEXT.set(context);
    }

    public static void clearCurrentContext() {
        CURRENT_CONTEXT.remove();
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public Object getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequestParamWrapper getParamWrapper() {
        if (this.paramWrapper == null) {
            HttpFilterContext httpFilterContext = this;
            synchronized (httpFilterContext) {
                if (this.paramWrapper == null) {
                    this.paramWrapper = this.paramWrapperSupplier.get();
                }
            }
        }
        return this.paramWrapper;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public <V> V getAttribute(String key) {
        return (V)this.attributes.get(key);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }
}

