/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObjectWithDataType;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Arrays;
import java.util.List;

public class SQLCastExpr
extends SQLExprImpl
implements SQLObjectWithDataType,
SQLReplaceable {
    protected boolean isTry;
    protected SQLExpr expr;
    protected SQLDataType dataType;
    protected SQLExpr format;

    public SQLCastExpr() {
    }

    public SQLCastExpr(SQLExpr expr, SQLDataType dataType) {
        this.setExpr(expr);
        this.setDataType(dataType);
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        if (expr != null) {
            expr.setParent(this);
        }
        this.expr = expr;
    }

    public SQLExpr getFormat() {
        return this.format;
    }

    public void setFormat(SQLExpr format) {
        if (format != null) {
            format.setParent(this);
        }
        this.format = format;
    }

    @Override
    public SQLDataType getDataType() {
        return this.dataType;
    }

    public long dateTypeHashCode() {
        if (this.dataType == null) {
            return 0L;
        }
        return this.dataType.nameHashCode64();
    }

    @Override
    public void setDataType(SQLDataType dataType) {
        if (dataType != null) {
            dataType.setParent(this);
        }
        this.dataType = dataType;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.expr != null) {
                this.expr.accept(visitor);
            }
            if (this.dataType != null) {
                this.dataType.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        return Arrays.asList(this.expr, this.dataType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLCastExpr castExpr = (SQLCastExpr)o;
        if (this.isTry != castExpr.isTry) {
            return false;
        }
        if (this.expr != null ? !this.expr.equals(castExpr.expr) : castExpr.expr != null) {
            return false;
        }
        return this.dataType != null ? this.dataType.equals(castExpr.dataType) : castExpr.dataType == null;
    }

    @Override
    public int hashCode() {
        int result = this.isTry ? 1 : 0;
        result = 31 * result + (this.expr != null ? this.expr.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        return result;
    }

    @Override
    public SQLDataType computeDataType() {
        return this.dataType;
    }

    @Override
    public SQLCastExpr clone() {
        SQLCastExpr x = new SQLCastExpr();
        x.isTry = this.isTry;
        if (this.expr != null) {
            x.setExpr(this.expr.clone());
        }
        if (this.dataType != null) {
            x.setDataType(this.dataType.clone());
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.expr == expr) {
            this.setExpr(target);
            return true;
        }
        return false;
    }

    public boolean isTry() {
        return this.isTry;
    }

    public void setTry(boolean aTry) {
        this.isTry = aTry;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this);
    }
}

