/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.transaction.at;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.exception.BranchTransactionException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.server.coordinator.AbstractCore;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;

public class ATCore
extends AbstractCore {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ATCore(RemotingServer remotingServer) {
        super(remotingServer);
    }

    public BranchType getHandleBranchType() {
        return BranchType.AT;
    }

    protected void branchSessionLock(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        String applicationData = branchSession.getApplicationData();
        boolean autoCommit = true;
        boolean skipCheckLock = false;
        if (StringUtils.isNotBlank((String)applicationData)) {
            try {
                Object clientSkipCheckLock;
                Map data = (Map)this.objectMapper.readValue(applicationData, HashMap.class);
                Object clientAutoCommit = data.get("autoCommit");
                if (clientAutoCommit != null && !((Boolean)clientAutoCommit).booleanValue()) {
                    autoCommit = (Boolean)clientAutoCommit;
                }
                if ((clientSkipCheckLock = data.get("skipCheckLock")) instanceof Boolean) {
                    skipCheckLock = (Boolean)clientSkipCheckLock;
                }
            }
            catch (IOException e) {
                LOGGER.error("failed to get application data: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        try {
            if (!branchSession.lock(autoCommit, skipCheckLock)) {
                throw new BranchTransactionException(TransactionExceptionCode.LockKeyConflict, String.format("Global lock acquire failed xid = %s branchId = %s", globalSession.getXid(), branchSession.getBranchId()));
            }
        }
        catch (StoreException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BranchTransactionException) {
                throw new BranchTransactionException(((BranchTransactionException)cause).getCode(), String.format("Global lock acquire failed xid = %s branchId = %s", globalSession.getXid(), branchSession.getBranchId()));
            }
            throw e;
        }
    }

    protected void branchSessionUnlock(BranchSession branchSession) throws TransactionException {
        branchSession.unlock();
    }

    public boolean lockQuery(BranchType branchType, String resourceId, String xid, String lockKeys) throws TransactionException {
        return this.lockManager.isLockable(xid, resourceId, lockKeys);
    }

    public BranchStatus branchDelete(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        return super.branchCommit(globalSession, branchSession);
    }
}

