/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.redis.store;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seata.common.XID;
import org.apache.seata.common.exception.RedisException;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.util.BeanUtils;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.store.BranchTransactionDO;
import org.apache.seata.core.store.GlobalTransactionDO;
import org.apache.seata.server.console.entity.param.GlobalSessionParam;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionCondition;
import org.apache.seata.server.session.SessionStatusValidator;
import org.apache.seata.server.storage.SessionConverter;
import org.apache.seata.server.storage.redis.JedisPooledFactory;
import org.apache.seata.server.store.AbstractTransactionStoreManager;
import org.apache.seata.server.store.SessionStorable;
import org.apache.seata.server.store.TransactionStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Transaction;

public class RedisTransactionStoreManager
extends AbstractTransactionStoreManager
implements TransactionStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisTransactionStoreManager.class);
    private static final String REDIS_SEATA_BRANCHES_PREFIX = "SEATA_BRANCHES_";
    private static final String REDIS_SEATA_BRANCH_PREFIX = "SEATA_BRANCH_";
    private static final String REDIS_SEATA_GLOBAL_PREFIX = "SEATA_GLOBAL_";
    private static final String REDIS_SEATA_STATUS_PREFIX = "SEATA_STATUS_";
    protected static final String REDIS_SEATA_BEGIN_TRANSACTIONS_KEY = "SEATA_BEGIN_TRANSACTIONS";
    private static volatile RedisTransactionStoreManager instance;
    private static final String OK = "OK";
    protected static final Configuration CONFIG;
    protected int logQueryLimit;
    public static volatile ImmutableMap<TransactionStoreManager.LogOperation, Function<GlobalTransactionDO, Boolean>> globalMap;
    public static volatile ImmutableMap<TransactionStoreManager.LogOperation, Function<BranchTransactionDO, Boolean>> branchMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisTransactionStoreManager getInstance() {
        if (instance != null) return instance;
        Class<RedisTransactionStoreManager> clazz = RedisTransactionStoreManager.class;
        synchronized (RedisTransactionStoreManager.class) {
            if (instance != null) return instance;
            instance = new RedisTransactionStoreManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public RedisTransactionStoreManager() {
        this.initGlobalMap();
        this.initBranchMap();
        this.initLogQueryLimit();
    }

    protected void initLogQueryLimit() {
        this.logQueryLimit = CONFIG.getInt("store.redis.queryLimit", 1000);
    }

    public void initGlobalMap() {
        if (CollectionUtils.isEmpty((Map)branchMap)) {
            globalMap = ImmutableMap.builder().put((Object)TransactionStoreManager.LogOperation.GLOBAL_ADD, arg_0 -> this.insertGlobalTransactionDO(arg_0)).put((Object)TransactionStoreManager.LogOperation.GLOBAL_UPDATE, arg_0 -> this.updateGlobalTransactionDO(arg_0)).put((Object)TransactionStoreManager.LogOperation.GLOBAL_REMOVE, arg_0 -> this.deleteGlobalTransactionDO(arg_0)).build();
        }
    }

    public void initBranchMap() {
        if (CollectionUtils.isEmpty((Map)branchMap)) {
            branchMap = ImmutableMap.builder().put((Object)TransactionStoreManager.LogOperation.BRANCH_ADD, arg_0 -> this.insertBranchTransactionDO(arg_0)).put((Object)TransactionStoreManager.LogOperation.BRANCH_UPDATE, arg_0 -> this.updateBranchTransactionDO(arg_0)).put((Object)TransactionStoreManager.LogOperation.BRANCH_REMOVE, arg_0 -> this.deleteBranchTransactionDO(arg_0)).build();
        }
    }

    public boolean writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable session) {
        if (globalMap.containsKey((Object)logOperation) || branchMap.containsKey((Object)logOperation)) {
            return globalMap.containsKey((Object)logOperation) ? (Boolean)((Function)globalMap.get((Object)logOperation)).apply(SessionConverter.convertGlobalTransactionDO((SessionStorable)session)) : (Boolean)((Function)branchMap.get((Object)logOperation)).apply(SessionConverter.convertBranchTransactionDO((SessionStorable)session));
        }
        throw new StoreException("Unknown LogOperation:" + logOperation.name());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean insertBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        String branchListKey = this.buildBranchListKeyByXid(branchTransactionDO.getXid());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            boolean bl;
            block14: {
                Pipeline pipelined = jedis.pipelined();
                try {
                    Date now = new Date();
                    branchTransactionDO.setGmtCreate(now);
                    branchTransactionDO.setGmtModified(now);
                    pipelined.hmset(branchKey, BeanUtils.objectToMap((Object)branchTransactionDO));
                    pipelined.rpush(branchListKey, new String[]{branchKey});
                    pipelined.sync();
                    bl = true;
                    if (pipelined == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pipelined != null) {
                        try {
                            pipelined.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pipelined.close();
            }
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean deleteBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        String branchListKey = this.buildBranchListKeyByXid(branchTransactionDO.getXid());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String xid = jedis.hget(branchKey, "xid");
            if (StringUtils.isEmpty((CharSequence)xid)) {
                boolean bl2 = true;
                return bl2;
            }
            try (Pipeline pipelined = jedis.pipelined();){
                pipelined.lrem(branchListKey, 0L, branchKey);
                pipelined.del(branchKey);
                pipelined.sync();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    protected boolean updateBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        boolean bl;
        block10: {
            String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
            String branchStatus = String.valueOf(branchTransactionDO.getStatus());
            String applicationData = String.valueOf(branchTransactionDO.getApplicationData());
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                String previousBranchStatus = jedis.hget(branchKey, "status");
                if (StringUtils.isEmpty((CharSequence)previousBranchStatus)) {
                    throw new StoreException("Branch transaction is not exist, update branch transaction failed.");
                }
                HashMap<String, String> map = new HashMap<String, String>(3, 1.0f);
                map.put("status", branchStatus);
                map.put("gmtModified", String.valueOf(new Date().getTime()));
                if (StringUtils.isNotBlank((String)branchTransactionDO.getApplicationData())) {
                    map.put("applicationData", applicationData);
                }
                jedis.hmset(branchKey, map);
                bl = true;
                if (jedis == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RedisException((Throwable)ex);
                }
            }
            jedis.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean insertGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String globalKey = this.buildGlobalKeyByTransactionId((Object)globalTransactionDO.getTransactionId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            boolean bl;
            block14: {
                Pipeline pipelined = jedis.pipelined();
                try {
                    Date now = new Date();
                    globalTransactionDO.setGmtCreate(now);
                    globalTransactionDO.setGmtModified(now);
                    pipelined.hmset(globalKey, BeanUtils.objectToMap((Object)globalTransactionDO));
                    String xid = globalTransactionDO.getXid();
                    pipelined.rpush(this.buildGlobalStatus(globalTransactionDO.getStatus()), new String[]{xid});
                    pipelined.zadd(REDIS_SEATA_BEGIN_TRANSACTIONS_KEY, (double)(globalTransactionDO.getBeginTime() + (long)globalTransactionDO.getTimeout().intValue()), globalKey);
                    pipelined.sync();
                    bl = true;
                    if (pipelined == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pipelined != null) {
                        try {
                            pipelined.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pipelined.close();
            }
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean deleteGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String globalKey = this.buildGlobalKeyByTransactionId((Object)globalTransactionDO.getTransactionId());
        String globalStatus = this.buildGlobalStatus(globalTransactionDO.getStatus());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String xid = jedis.hget(globalKey, "xid");
            if (StringUtils.isEmpty((CharSequence)xid)) {
                LOGGER.warn("Global transaction is not exist,xid = {}.Maybe has been deleted by another tc server", (Object)globalTransactionDO.getXid());
                boolean bl2 = true;
                return bl2;
            }
            try (Pipeline pipelined = jedis.pipelined();){
                pipelined.lrem(globalStatus, 0L, globalTransactionDO.getXid());
                pipelined.del(globalKey);
                if (GlobalStatus.Begin.getCode() == globalTransactionDO.getStatus().intValue() || GlobalStatus.UnKnown.getCode() == globalTransactionDO.getStatus().intValue()) {
                    pipelined.zrem(REDIS_SEATA_BEGIN_TRANSACTIONS_KEY, new String[]{globalKey});
                }
                pipelined.sync();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean updateGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String xid = globalTransactionDO.getXid();
        String globalKey = this.buildGlobalKeyByTransactionId((Object)globalTransactionDO.getTransactionId());
        Integer status = globalTransactionDO.getStatus();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            GlobalStatus after;
            jedis.watch(new String[]{globalKey});
            List statusAndGmtModified = jedis.hmget(globalKey, new String[]{"status", "gmtModified"});
            String previousStatus = (String)statusAndGmtModified.get(0);
            if (StringUtils.isEmpty((CharSequence)previousStatus)) {
                jedis.unwatch();
                throw new StoreException("Global transaction is not exist, update global transaction failed.");
            }
            if (previousStatus.equals(String.valueOf(status))) {
                jedis.unwatch();
                boolean bl = true;
                return bl;
            }
            GlobalStatus before = GlobalStatus.get((int)Integer.parseInt(previousStatus));
            if (!SessionStatusValidator.validateUpdateStatus((GlobalStatus)before, (GlobalStatus)(after = GlobalStatus.get((int)status)))) {
                throw new StoreException("Illegal changing of global status, update global transaction failed. beforeStatus[" + before.name() + "] cannot be changed to afterStatus[" + after.name() + "]");
            }
            String previousGmtModified = (String)statusAndGmtModified.get(1);
            Transaction multi = jedis.multi();
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("status", String.valueOf(globalTransactionDO.getStatus()));
            map.put("gmtModified", String.valueOf(new Date().getTime()));
            multi.hmset(globalKey, map);
            multi.lrem(this.buildGlobalStatus(Integer.valueOf(previousStatus)), 0L, xid);
            multi.rpush(this.buildGlobalStatus(globalTransactionDO.getStatus()), new String[]{xid});
            multi.zrem(REDIS_SEATA_BEGIN_TRANSACTIONS_KEY, new String[]{globalKey});
            List exec = multi.exec();
            if (CollectionUtils.isEmpty((Collection)exec)) {
                LOGGER.warn("The global transaction xid = {}, maybe changed by another TC. It does not affect the results", (Object)xid);
                boolean bl = true;
                return bl;
            }
            String hmset = exec.get(0).toString();
            long lrem = (Long)exec.get(1);
            long rpush = (Long)exec.get(2);
            if (OK.equalsIgnoreCase(hmset) && lrem > 0L && rpush > 0L) {
                boolean bl = true;
                return bl;
            }
            if (OK.equalsIgnoreCase(hmset)) {
                jedis.watch(new String[]{globalKey});
                String xid2 = jedis.hget(globalKey, "xid");
                if (StringUtils.isNotEmpty((CharSequence)xid2)) {
                    HashMap<String, String> mapPrevious = new HashMap<String, String>(2, 1.0f);
                    mapPrevious.put("status", previousStatus);
                    mapPrevious.put("gmtModified", previousGmtModified);
                    Transaction multi2 = jedis.multi();
                    multi2.hmset(globalKey, mapPrevious);
                    multi2.exec();
                }
            }
            if (lrem > 0L) {
                jedis.rpush(this.buildGlobalStatus(Integer.valueOf(previousStatus)), new String[]{xid});
            }
            if (rpush > 0L) {
                jedis.lrem(this.buildGlobalStatus(status), 0L, xid);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    public GlobalSession readSession(String xid, boolean withBranchSessions) {
        String transactionId = String.valueOf(XID.getTransactionId((String)xid));
        String globalKey = this.buildGlobalKeyByTransactionId((Object)transactionId);
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            GlobalSession session;
            Map map = jedis.hgetAll(globalKey);
            if (CollectionUtils.isEmpty((Map)map)) {
                GlobalSession globalSession = null;
                return globalSession;
            }
            GlobalTransactionDO globalTransactionDO = (GlobalTransactionDO)BeanUtils.mapToObject((Map)map, GlobalTransactionDO.class);
            List branchTransactionDOs = null;
            if (withBranchSessions) {
                branchTransactionDOs = this.readBranchSessionByXid(jedis, xid);
            }
            GlobalSession globalSession = session = this.getGlobalSession(globalTransactionDO, branchTransactionDOs, withBranchSessions);
            return globalSession;
        }
    }

    public GlobalSession readSession(String xid) {
        return this.readSession(xid, true);
    }

    public List<GlobalSession> readSession(GlobalStatus[] statuses, boolean withBranchSessions) {
        List<GlobalSession> globalSessions = Collections.synchronizedList(new ArrayList());
        List statusKeys = this.convertStatusKeys(statuses);
        Map targetMap = this.calculateStatuskeysHasData(statusKeys);
        if (targetMap.size() == 0 || this.logQueryLimit <= 0) {
            return globalSessions;
        }
        int perStatusLimit = this.resetLogQueryLimit(targetMap);
        long countGlobalSessions = targetMap.values().stream().collect(Collectors.summarizingInt(Integer::intValue)).getSum();
        long queryCount = Math.min((long)this.logQueryLimit, countGlobalSessions);
        ArrayList list = new ArrayList();
        this.dogetXidsForTargetMapRecursive(targetMap, 0L, (long)(perStatusLimit - 1), queryCount, list);
        if (CollectionUtils.isNotEmpty(list)) {
            List xids = list.stream().flatMap(Collection::stream).collect(Collectors.toList());
            xids.parallelStream().forEach(xid -> {
                GlobalSession globalSession = this.readSession(xid, withBranchSessions);
                if (globalSession != null) {
                    globalSessions.add(globalSession);
                }
            });
        }
        return globalSessions;
    }

    public List<GlobalSession> readSortByTimeoutBeginSessions(boolean withBranchSessions) {
        List<Object> list = Collections.emptyList();
        List statusKeys = this.convertStatusKeys(new GlobalStatus[]{GlobalStatus.Begin});
        Map targetMap = this.calculateStatuskeysHasData(statusKeys);
        if (targetMap.size() == 0 || this.logQueryLimit <= 0) {
            return list;
        }
        long countGlobalSessions = targetMap.values().stream().collect(Collectors.summarizingInt(Integer::intValue)).getSum();
        long queryCount = Math.min((long)this.logQueryLimit, countGlobalSessions);
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            List rep;
            Set values = jedis.zrangeByScore(REDIS_SEATA_BEGIN_TRANSACTIONS_KEY, 0.0, (double)System.currentTimeMillis(), 0, (int)queryCount);
            try (Pipeline pipeline = jedis.pipelined();){
                for (String value : values) {
                    pipeline.hgetAll(value);
                }
                rep = pipeline.syncAndReturnAll();
            }
            list = rep.stream().map(map -> {
                GlobalTransactionDO globalTransactionDO = (GlobalTransactionDO)BeanUtils.mapToObject((Map)map, GlobalTransactionDO.class);
                if (globalTransactionDO != null) {
                    String xid = globalTransactionDO.getXid();
                    List branchTransactionDOs = new ArrayList();
                    if (withBranchSessions) {
                        branchTransactionDOs = this.readBranchSessionByXid(jedis, xid);
                    }
                    return this.getGlobalSession(globalTransactionDO, branchTransactionDOs, withBranchSessions);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return list;
    }

    private int resetLogQueryLimit(Map<String, Integer> targetMap) {
        int resetLimitQuery = this.logQueryLimit;
        if (targetMap.size() > 1) {
            int size = targetMap.size();
            resetLimitQuery = this.logQueryLimit / size == 0 ? 1 : this.logQueryLimit / size;
        }
        return resetLimitQuery;
    }

    public List<GlobalSession> readSession(SessionCondition sessionCondition) {
        ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
        if (StringUtils.isNotEmpty((CharSequence)sessionCondition.getXid())) {
            GlobalSession globalSession = this.readSession(sessionCondition.getXid(), !sessionCondition.isLazyLoadBranch());
            if (globalSession != null) {
                globalSessions.add(globalSession);
            }
            return globalSessions;
        }
        if (sessionCondition.getTransactionId() != null) {
            GlobalSession globalSession = this.readSessionByTransactionId(sessionCondition.getTransactionId().toString(), !sessionCondition.isLazyLoadBranch());
            if (globalSession != null) {
                globalSessions.add(globalSession);
            }
            return globalSessions;
        }
        if (CollectionUtils.isNotEmpty((Object[])sessionCondition.getStatuses())) {
            if (sessionCondition.getStatuses().length == 1 && sessionCondition.getStatuses()[0] == GlobalStatus.Begin) {
                return this.readSortByTimeoutBeginSessions(!sessionCondition.isLazyLoadBranch());
            }
            return this.readSession(sessionCondition.getStatuses(), !sessionCondition.isLazyLoadBranch());
        }
        return null;
    }

    public List<GlobalSession> readSessionStatusByPage(GlobalSessionParam param) {
        ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
        int pageNum = param.getPageNum();
        int pageSize = param.getPageSize();
        int start = Math.max((pageNum - 1) * pageSize, 0);
        int end = pageNum * pageSize - 1;
        if (param.getStatus() != null) {
            String statusKey = this.buildGlobalStatus(Integer.valueOf(GlobalStatus.get((int)param.getStatus()).getCode()));
            try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
                List xids = jedis.lrange(statusKey, (long)start, (long)end);
                xids.forEach(xid -> {
                    GlobalSession globalSession = this.readSession(xid, param.isWithBranch());
                    if (globalSession != null) {
                        globalSessions.add(globalSession);
                    }
                });
            }
        }
        return globalSessions;
    }

    private GlobalSession getGlobalSession(GlobalTransactionDO globalTransactionDO, List<BranchTransactionDO> branchTransactionDOs, boolean withBranchSessions) {
        GlobalSession globalSession = SessionConverter.convertGlobalSession((GlobalTransactionDO)globalTransactionDO, (!withBranchSessions ? 1 : 0) != 0);
        if (CollectionUtils.isNotEmpty(branchTransactionDOs)) {
            for (BranchTransactionDO branchTransactionDO : branchTransactionDOs) {
                globalSession.add(SessionConverter.convertBranchSession((BranchTransactionDO)branchTransactionDO));
            }
        }
        return globalSession;
    }

    private GlobalSession readSessionByTransactionId(String transactionId, boolean withBranchSessions) {
        String globalKey = this.buildGlobalKeyByTransactionId((Object)transactionId);
        String xid = null;
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map map = jedis.hgetAll(globalKey);
            if (CollectionUtils.isEmpty((Map)map)) {
                GlobalSession globalSession = null;
                return globalSession;
            }
            GlobalTransactionDO globalTransactionDO = (GlobalTransactionDO)BeanUtils.mapToObject((Map)map, GlobalTransactionDO.class);
            if (globalTransactionDO != null) {
                xid = globalTransactionDO.getXid();
            }
            List branchTransactionDOs = new ArrayList();
            if (withBranchSessions) {
                branchTransactionDOs = this.readBranchSessionByXid(jedis, xid);
            }
            GlobalSession globalSession = this.getGlobalSession(globalTransactionDO, branchTransactionDOs, withBranchSessions);
            return globalSession;
        }
    }

    private List<BranchTransactionDO> readBranchSessionByXid(Jedis jedis, String xid) {
        ArrayList<BranchTransactionDO> branchTransactionDOs = new ArrayList<BranchTransactionDO>();
        String branchListKey = this.buildBranchListKeyByXid(xid);
        List branchKeys = this.lRange(jedis, branchListKey);
        if (CollectionUtils.isNotEmpty((Collection)branchKeys)) {
            try (Pipeline pipeline = jedis.pipelined();){
                branchKeys.stream().forEach(branchKey -> pipeline.hgetAll(branchKey));
                List branchInfos = pipeline.syncAndReturnAll();
                for (Object branchInfo : branchInfos) {
                    if (branchInfo == null) continue;
                    Map branchInfoMap = (Map)branchInfo;
                    Optional<BranchTransactionDO> branchTransactionDO = Optional.ofNullable((BranchTransactionDO)BeanUtils.mapToObject((Map)branchInfoMap, BranchTransactionDO.class));
                    branchTransactionDO.ifPresent(branchTransactionDOs::add);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(branchTransactionDOs)) {
            Collections.sort(branchTransactionDOs);
        }
        return branchTransactionDOs;
    }

    private List<String> lRange(Jedis jedis, String key) {
        ArrayList<String> keys = new ArrayList<String>();
        int limit = 20;
        int start = 0;
        int stop = limit;
        while (true) {
            List values = jedis.lrange(key, (long)start, (long)stop);
            keys.addAll(values);
            if (CollectionUtils.isEmpty((Collection)values) || values.size() < limit) break;
            start = keys.size();
            stop = start + limit;
        }
        return keys;
    }

    public List<BranchTransactionDO> findBranchSessionByXid(String xid) {
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            List list = this.readBranchSessionByXid(jedis, xid);
            return list;
        }
    }

    public List<GlobalSession> findGlobalSessionByPage(int pageNum, int pageSize, boolean withBranchSessions) {
        ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
        int start = Math.max((pageNum - 1) * pageSize, 0);
        int end = pageNum * pageSize - 1;
        List statusKeys = this.convertStatusKeys(GlobalStatus.values());
        Map stringLongMap = this.calculateStatuskeysHasData(statusKeys);
        List list = this.dogetXidsForTargetMap(stringLongMap, start, end, pageSize);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<String> xids = list.stream().flatMap(Collection::stream).collect(Collectors.toList());
            xids.forEach(xid -> {
                GlobalSession globalSession;
                if (globalSessions.size() < pageSize && (globalSession = this.readSession(xid, withBranchSessions)) != null) {
                    globalSessions.add(globalSession);
                }
            });
        }
        return globalSessions;
    }

    private Map<String, Integer> calculateStatuskeysHasData(List<String> statusKeys) {
        LinkedHashMap<String, Integer> resultMap = new LinkedHashMap<String, Integer>();
        HashMap<String, Integer> keysMap = new HashMap<String, Integer>(statusKeys.size());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();
             Pipeline pipelined = jedis.pipelined();){
            statusKeys.forEach(key -> pipelined.llen(key));
            List counts = pipelined.syncAndReturnAll();
            for (int i = 0; i < counts.size(); ++i) {
                if ((Long)counts.get(i) <= 0L) continue;
                keysMap.put(statusKeys.get(i), ((Long)counts.get(i)).intValue());
            }
        }
        ArrayList list = new ArrayList(keysMap.entrySet());
        list.sort((o1, o2) -> (Integer)o2.getValue() - (Integer)o1.getValue());
        list.forEach(e -> resultMap.put((String)e.getKey(), (Integer)e.getValue()));
        return resultMap;
    }

    public Long countByGlobalSessions(GlobalStatus[] values) {
        ArrayList<String> statusKeys = new ArrayList<String>();
        Long total = 0L;
        for (GlobalStatus status : values) {
            statusKeys.add(this.buildGlobalStatus(Integer.valueOf(status.getCode())));
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Long l;
            block14: {
                Pipeline pipelined = jedis.pipelined();
                try {
                    statusKeys.stream().forEach(statusKey -> pipelined.llen(statusKey));
                    List list = pipelined.syncAndReturnAll();
                    if (list.size() > 0) {
                        total = list.stream().mapToLong(value -> value).sum();
                    }
                    l = total;
                    if (pipelined == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pipelined != null) {
                        try {
                            pipelined.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pipelined.close();
            }
            return l;
        }
    }

    private List<String> convertStatusKeys(GlobalStatus ... statuses) {
        ArrayList<String> statusKeys = new ArrayList<String>();
        for (int i = 0; i < statuses.length; ++i) {
            statusKeys.add(this.buildGlobalStatus(Integer.valueOf(statuses[i].getCode())));
        }
        return statusKeys;
    }

    private void dogetXidsForTargetMapRecursive(Map<String, Integer> targetMap, long start, long end, long queryCount, List<List<String>> listList) {
        long total = listList.stream().mapToLong(List::size).sum();
        if (total >= queryCount) {
            return;
        }
        if (start >= queryCount) {
            return;
        }
        if (targetMap.size() == 0) {
            return;
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Iterator<Map.Entry<String, Integer>> iterator = targetMap.entrySet().iterator();
            while (iterator.hasNext()) {
                List list;
                String key = iterator.next().getKey();
                long sum = listList.stream().mapToLong(List::size).sum();
                long diffCount = queryCount - sum;
                if (diffCount <= 0L) {
                    return;
                }
                if (end - start >= diffCount) {
                    long endNew = start + diffCount - 1L;
                    list = jedis.lrange(key, start, endNew);
                } else {
                    list = jedis.lrange(key, start, end);
                }
                if (list.size() > 0) {
                    listList.add(list);
                    continue;
                }
                iterator.remove();
            }
        }
        long startNew = end + 1L;
        long endNew = startNew + end - start;
        this.dogetXidsForTargetMapRecursive(targetMap, startNew, endNew, queryCount, listList);
    }

    private List<List<String>> dogetXidsForTargetMap(Map<String, Integer> targetMap, int start, int end, int totalCount) {
        ArrayList<List<String>> listList = new ArrayList<List<String>>();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            for (String key : targetMap.keySet()) {
                List list = jedis.lrange(key, (long)start, (long)end);
                long sum = listList.stream().mapToLong(List::size).sum();
                if (list.size() > 0 && sum < (long)totalCount) {
                    listList.add(list);
                    continue;
                }
                start = 0;
                end = totalCount - 1;
            }
        }
        return listList;
    }

    protected String buildBranchListKeyByXid(String xid) {
        return REDIS_SEATA_BRANCHES_PREFIX + xid;
    }

    protected String buildGlobalKeyByTransactionId(Object transactionId) {
        return REDIS_SEATA_GLOBAL_PREFIX + transactionId;
    }

    protected String buildBranchKey(Long branchId) {
        return REDIS_SEATA_BRANCH_PREFIX + branchId;
    }

    protected String buildGlobalStatus(Integer status) {
        return REDIS_SEATA_STATUS_PREFIX + status;
    }

    public void setLogQueryLimit(int logQueryLimit) {
        this.logQueryLimit = logQueryLimit;
    }

    static {
        CONFIG = ConfigurationFactory.getInstance();
    }
}

