/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.coordinator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.logger.StackTraceLogger;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.server.coordinator.AbstractCore;
import org.apache.seata.server.coordinator.Core;
import org.apache.seata.server.coordinator.DefaultCore;
import org.apache.seata.server.metrics.MetricsPublisher;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.BranchSessionHandler;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHelper;
import org.apache.seata.server.session.SessionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DefaultCore
implements Core {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCore.class);
    private static final int RETRY_XAER_NOTA_TIMEOUT = ConfigurationFactory.getInstance().getInt("server.xaerNotaRetryTimeout", 60000);
    private static final Map<BranchType, AbstractCore> CORE_MAP = new ConcurrentHashMap();
    private static final boolean PARALLEL_HANDLE_BRANCH = ConfigurationFactory.getInstance().getBoolean("server.enableParallelHandleBranch", false);
    private static volatile DefaultCore instance;

    public DefaultCore(RemotingServer remotingServer) {
        List allCore = EnhancedServiceLoader.loadAll(AbstractCore.class, (Class[])new Class[]{RemotingServer.class}, (Object[])new Object[]{remotingServer});
        if (CollectionUtils.isNotEmpty((Collection)allCore)) {
            for (AbstractCore core : allCore) {
                CORE_MAP.put(core.getHandleBranchType(), core);
            }
        }
    }

    public AbstractCore getCore(BranchType branchType) {
        AbstractCore core = (AbstractCore)CORE_MAP.get(branchType);
        if (core == null) {
            throw new NotSupportYetException("unsupported type:" + branchType.name());
        }
        return core;
    }

    public void mockCore(BranchType branchType, AbstractCore core) {
        CORE_MAP.put(branchType, core);
    }

    public Long branchRegister(BranchType branchType, String resourceId, String clientId, String xid, String applicationData, String lockKeys) throws TransactionException {
        return this.getCore(branchType).branchRegister(branchType, resourceId, clientId, xid, applicationData, lockKeys);
    }

    public void branchReport(BranchType branchType, String xid, long branchId, BranchStatus status, String applicationData) throws TransactionException {
        this.getCore(branchType).branchReport(branchType, xid, branchId, status, applicationData);
    }

    public boolean lockQuery(BranchType branchType, String resourceId, String xid, String lockKeys) throws TransactionException {
        return this.getCore(branchType).lockQuery(branchType, resourceId, xid, lockKeys);
    }

    public BranchStatus branchCommit(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        return this.getCore(branchSession.getBranchType()).branchCommit(globalSession, branchSession);
    }

    public BranchStatus branchRollback(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        return this.getCore(branchSession.getBranchType()).branchRollback(globalSession, branchSession);
    }

    public BranchStatus branchDelete(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        return this.getCore(branchSession.getBranchType()).branchDelete(globalSession, branchSession);
    }

    public Boolean doBranchDelete(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start delete branch, xid:{}, branchId:{}, branchType:{}", new Object[]{globalSession.getXid(), branchSession.getBranchId(), branchSession.getBranchType()});
        }
        if (globalSession.isSaga()) {
            return true;
        }
        BranchStatus branchStatus = this.getCore(branchSession.getBranchType()).branchDelete(globalSession, branchSession);
        switch (1.$SwitchMap$org$apache$seata$core$model$BranchType[branchSession.getBranchType().ordinal()]) {
            case 1: {
                if (branchStatus.getCode() != BranchStatus.PhaseTwo_Committed.getCode()) break;
                LOGGER.info("Delete AT branch failed, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                return true;
            }
            case 2: {
                if (branchStatus.getCode() != BranchStatus.PhaseTwo_Rollbacked.getCode()) break;
                LOGGER.info("Delete TCC branch failed, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                return true;
            }
            case 3: {
                if (branchStatus.getCode() == BranchStatus.PhaseTwo_Rollbacked.getCode()) {
                    return true;
                }
                if (this.isXaerNotaTimeout(globalSession, BranchStatus.get((int)branchStatus.getCode()))) {
                    LOGGER.info("Delete branch XAER_NOTA retry timeout, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                    return true;
                }
                LOGGER.info("Delete XA branch failed, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                break;
            }
        }
        if (branchStatus == BranchStatus.PhaseTwo_RollbackFailed_Unretryable) {
            LOGGER.error("Delete branch transaction fail and stop retry, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
            return true;
        }
        LOGGER.error("Delete branch transaction failed, xid = {} branchId = {} branchType = {}", new Object[]{globalSession.getXid(), branchSession.getBranchId(), branchSession.getBranchType()});
        return false;
    }

    public String begin(String applicationId, String transactionServiceGroup, String name, int timeout) throws TransactionException {
        GlobalSession session = GlobalSession.createGlobalSession((String)applicationId, (String)transactionServiceGroup, (String)name, (int)timeout);
        MDC.put((String)"X-TX-XID", (String)session.getXid());
        session.begin();
        MetricsPublisher.postSessionDoingEvent((GlobalSession)session, (boolean)false);
        return session.getXid();
    }

    public GlobalStatus commit(String xid) throws TransactionException {
        GlobalSession globalSession = SessionHolder.findGlobalSession((String)xid);
        if (globalSession == null) {
            return GlobalStatus.Finished;
        }
        if (globalSession.isTimeout()) {
            LOGGER.info("TC detected timeout, xid = {}", (Object)globalSession.getXid());
            return GlobalStatus.TimeoutRollbacking;
        }
        boolean shouldCommit = (Boolean)SessionHolder.lockAndExecute((GlobalSession)globalSession, () -> {
            boolean shouldCommitNow = false;
            if (globalSession.getStatus() == GlobalStatus.Begin) {
                globalSession.close();
                if (globalSession.canBeCommittedAsync()) {
                    globalSession.asyncCommit();
                    MetricsPublisher.postSessionDoneEvent((GlobalSession)globalSession, (GlobalStatus)GlobalStatus.Committed, (boolean)false, (boolean)false);
                } else {
                    globalSession.changeGlobalStatus(GlobalStatus.Committing);
                    shouldCommitNow = true;
                }
                globalSession.clean();
            }
            return shouldCommitNow;
        });
        if (shouldCommit) {
            boolean success = this.doGlobalCommit(globalSession, false);
            if (success && globalSession.hasBranch() && globalSession.canBeCommittedAsync()) {
                globalSession.asyncCommit();
                return GlobalStatus.Committed;
            }
            return globalSession.getStatus();
        }
        return globalSession.getStatus() == GlobalStatus.AsyncCommitting ? GlobalStatus.Committed : globalSession.getStatus();
    }

    public boolean doGlobalCommit(GlobalSession globalSession, boolean retrying) throws TransactionException {
        boolean success = true;
        MetricsPublisher.postSessionDoingEvent((GlobalSession)globalSession, (boolean)retrying);
        if (globalSession.isSaga()) {
            success = this.getCore(BranchType.SAGA).doGlobalCommit(globalSession, retrying);
        } else {
            List branchSessions = globalSession.getSortedBranches();
            Boolean result = SessionHelper.forEach((Collection)branchSessions, branchSession -> {
                if (!retrying && branchSession.canBeCommittedAsync()) {
                    return BranchSessionHandler.CONTINUE;
                }
                BranchStatus currentStatus = branchSession.getStatus();
                if (currentStatus == BranchStatus.PhaseOne_Failed) {
                    SessionHelper.removeBranch((GlobalSession)globalSession, (BranchSession)branchSession, (!retrying ? 1 : 0) != 0);
                    return BranchSessionHandler.CONTINUE;
                }
                if (currentStatus == BranchStatus.PhaseOne_RDONLY && branchSession.getBranchType() == BranchType.XA) {
                    SessionHelper.removeBranch((GlobalSession)globalSession, (BranchSession)branchSession, (!retrying ? 1 : 0) != 0);
                    return BranchSessionHandler.CONTINUE;
                }
                if (retrying && BranchStatus.STOP_RETRY.equals((Object)currentStatus)) {
                    return BranchSessionHandler.CONTINUE;
                }
                try {
                    BranchStatus branchStatus = this.getCore(branchSession.getBranchType()).branchCommit(globalSession, branchSession);
                    if (this.isXaerNotaTimeout(globalSession, branchStatus)) {
                        LOGGER.info("Commit branch XAER_NOTA retry timeout, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                        branchStatus = BranchStatus.PhaseTwo_Committed;
                    }
                    switch (1.$SwitchMap$org$apache$seata$core$model$BranchStatus[branchStatus.ordinal()]) {
                        case 1: {
                            SessionHelper.removeBranch((GlobalSession)globalSession, (BranchSession)branchSession, (!retrying ? 1 : 0) != 0);
                            LOGGER.info("Commit branch transaction successfully, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                            return BranchSessionHandler.CONTINUE;
                        }
                        case 2: {
                            SessionHelper.endCommitFailed((GlobalSession)globalSession, (boolean)retrying);
                            LOGGER.error("Committing global transaction[{}] finally failed, caused by branch transaction[{}] commit failed.", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                            return false;
                        }
                    }
                    if (!retrying) {
                        globalSession.queueToRetryCommit();
                        return false;
                    }
                    if (globalSession.canBeCommittedAsync()) {
                        LOGGER.error("Committing branch transaction[{}], status:{} and will retry later", (Object)branchSession.getBranchId(), (Object)branchStatus);
                        return BranchSessionHandler.CONTINUE;
                    }
                    LOGGER.error("Committing global transaction[{}] failed, caused by branch transaction[{}] commit failed, will retry later.", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                    return false;
                }
                catch (Exception ex) {
                    String commitInfo = retrying ? "Global commit continue" : "Global commit failed";
                    StackTraceLogger.error((Logger)LOGGER, (Throwable)ex, (String)"Committing branch transaction exception:retrying={}, {}, {}", (Object[])new String[]{String.valueOf(retrying), branchSession.toString(), commitInfo});
                    if (!retrying) {
                        globalSession.queueToRetryCommit();
                        throw new TransactionException((Throwable)ex);
                    }
                    return BranchSessionHandler.CONTINUE;
                }
            }, (PARALLEL_HANDLE_BRANCH && branchSessions.size() >= 2 ? 1 : 0) != 0);
            if (result != null) {
                return result;
            }
            if (globalSession.hasBranch() && !globalSession.canBeCommittedAsync()) {
                LOGGER.info("Committing global transaction is NOT done, xid = {}.", (Object)globalSession.getXid());
                return false;
            }
        }
        if (success && globalSession.getBranchSessions().isEmpty()) {
            SessionHelper.endCommitted((GlobalSession)globalSession, (boolean)retrying);
            LOGGER.info("Committing global transaction is successfully done, xid = {}.", (Object)globalSession.getXid());
        }
        return success;
    }

    public GlobalStatus rollback(String xid) throws TransactionException {
        GlobalSession globalSession = SessionHolder.findGlobalSession((String)xid);
        if (globalSession == null) {
            return GlobalStatus.Finished;
        }
        boolean shouldRollBack = (Boolean)SessionHolder.lockAndExecute((GlobalSession)globalSession, () -> {
            globalSession.close();
            if (globalSession.getStatus() == GlobalStatus.Begin) {
                globalSession.changeGlobalStatus(GlobalStatus.Rollbacking);
                return true;
            }
            return false;
        });
        if (!shouldRollBack) {
            return globalSession.getStatus();
        }
        boolean rollbackSuccess = this.doGlobalRollback(globalSession, false);
        return rollbackSuccess ? GlobalStatus.Rollbacked : globalSession.getStatus();
    }

    public boolean doGlobalRollback(GlobalSession globalSession, boolean retrying) throws TransactionException {
        boolean success = true;
        MetricsPublisher.postSessionDoingEvent((GlobalSession)globalSession, (boolean)retrying);
        if (globalSession.isSaga()) {
            success = this.getCore(BranchType.SAGA).doGlobalRollback(globalSession, retrying);
        } else {
            List branchSessions = globalSession.getReverseSortedBranches();
            Boolean result = SessionHelper.forEach((Collection)branchSessions, branchSession -> {
                BranchStatus currentBranchStatus = branchSession.getStatus();
                if (currentBranchStatus == BranchStatus.PhaseOne_Failed) {
                    SessionHelper.removeBranch((GlobalSession)globalSession, (BranchSession)branchSession, (!retrying ? 1 : 0) != 0);
                    return BranchSessionHandler.CONTINUE;
                }
                if (retrying && BranchStatus.STOP_RETRY.equals((Object)currentBranchStatus)) {
                    return BranchSessionHandler.CONTINUE;
                }
                try {
                    BranchStatus branchStatus = this.branchRollback(globalSession, branchSession);
                    if (this.isXaerNotaTimeout(globalSession, branchStatus)) {
                        LOGGER.info("Rollback branch XAER_NOTA retry timeout, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                        branchStatus = BranchStatus.PhaseTwo_Rollbacked;
                    }
                    switch (1.$SwitchMap$org$apache$seata$core$model$BranchStatus[branchStatus.ordinal()]) {
                        case 3: {
                            SessionHelper.removeBranch((GlobalSession)globalSession, (BranchSession)branchSession, (!retrying ? 1 : 0) != 0);
                            LOGGER.info("Rollback branch transaction successfully, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                            return BranchSessionHandler.CONTINUE;
                        }
                        case 4: {
                            SessionHelper.endRollbackFailed((GlobalSession)globalSession, (boolean)retrying);
                            LOGGER.error("Rollback branch transaction fail and stop retry, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                            return false;
                        }
                    }
                    LOGGER.error("Rollback branch transaction fail and will retry, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                    if (!retrying) {
                        globalSession.queueToRetryRollback();
                    }
                    return false;
                }
                catch (Exception ex) {
                    StackTraceLogger.error((Logger)LOGGER, (Throwable)ex, (String)"Rollback branch transaction exception, xid = {} ,branchId = {} ,retrying={} ,exception = {}, global rollback failed", (Object[])new String[]{globalSession.getXid(), String.valueOf(branchSession.getBranchId()), String.valueOf(retrying), ex.getMessage()});
                    if (!retrying) {
                        globalSession.queueToRetryRollback();
                    }
                    throw new TransactionException((Throwable)ex);
                }
            }, (PARALLEL_HANDLE_BRANCH && branchSessions.size() >= 2 ? 1 : 0) != 0);
            if (result != null) {
                return result;
            }
        }
        if (success) {
            SessionHelper.endRollbacked((GlobalSession)globalSession, (boolean)retrying);
            LOGGER.info("Rollback global transaction successfully, xid = {}.", (Object)globalSession.getXid());
        }
        return success;
    }

    public GlobalStatus getStatus(String xid) throws TransactionException {
        GlobalSession globalSession = SessionHolder.findGlobalSession((String)xid, (boolean)false);
        if (globalSession == null) {
            return GlobalStatus.Finished;
        }
        return globalSession.getStatus();
    }

    public GlobalStatus globalReport(String xid, GlobalStatus globalStatus) throws TransactionException {
        GlobalSession globalSession = SessionHolder.findGlobalSession((String)xid);
        if (globalSession == null) {
            return globalStatus;
        }
        this.doGlobalReport(globalSession, xid, globalStatus);
        return globalSession.getStatus();
    }

    public void doGlobalReport(GlobalSession globalSession, String xid, GlobalStatus globalStatus) throws TransactionException {
        if (globalSession.isSaga()) {
            this.getCore(BranchType.SAGA).doGlobalReport(globalSession, xid, globalStatus);
        }
    }

    private boolean isXaerNotaTimeout(GlobalSession globalSession, BranchStatus branchStatus) {
        if (BranchStatus.PhaseTwo_CommitFailed_XAER_NOTA_Retryable.equals((Object)branchStatus) || BranchStatus.PhaseTwo_RollbackFailed_XAER_NOTA_Retryable.equals((Object)branchStatus)) {
            return System.currentTimeMillis() > globalSession.getBeginTime() + (long)globalSession.getTimeout() + (long)Math.max(RETRY_XAER_NOTA_TIMEOUT, globalSession.getTimeout());
        }
        return false;
    }
}

