/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.server.console.entity.vo.BranchSessionVO;
import org.apache.seata.server.console.impl.AbstractBranchService;
import org.apache.seata.server.console.service.BranchSessionService;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.storage.SessionConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'file'.equals('${sessionMode}')}")
public class BranchSessionFileServiceImpl
extends AbstractBranchService
implements BranchSessionService {
    public PageResult<BranchSessionVO> queryByXid(String xid) {
        if (StringUtils.isBlank((String)xid)) {
            throw new IllegalArgumentException("xid should not be blank");
        }
        ArrayList branchSessionVOList = new ArrayList(0);
        Collection allSessions = SessionHolder.getRootSessionManager().allSessions();
        for (GlobalSession globalSession : allSessions) {
            if (!globalSession.getXid().equals(xid)) continue;
            Set branchSessionVOS = SessionConverter.convertBranchSession((List)globalSession.getBranchSessions());
            branchSessionVOList = new ArrayList(branchSessionVOS);
            break;
        }
        return PageResult.success(branchSessionVOList, (Integer)branchSessionVOList.size(), (Integer)0, (Integer)0, (Integer)0);
    }
}

