/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.compressor.deflater;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class DeflaterUtil {
    private static final int BUFFER_SIZE = 8192;

    private DeflaterUtil() {
    }

    public static byte[] compress(byte[] bytes) {
        byte[] byArray;
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        int length = 0;
        Deflater deflater = new Deflater();
        deflater.setInput(bytes);
        deflater.finish();
        byte[] outputBytes = new byte[8192];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            while (!deflater.finished()) {
                length = deflater.deflate(outputBytes);
                bos.write(outputBytes, 0, length);
            }
            deflater.end();
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Deflater compress error", e);
            }
        }
        bos.close();
        return byArray;
    }

    public static byte[] decompress(byte[] bytes) {
        byte[] byArray;
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        int length = 0;
        Inflater inflater = new Inflater();
        inflater.setInput(bytes);
        byte[] outputBytes = new byte[8192];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            while (!inflater.finished() && (length = inflater.inflate(outputBytes)) != 0) {
                bos.write(outputBytes, 0, length);
            }
            inflater.end();
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Deflater decompress error", e);
            }
        }
        bos.close();
        return byArray;
    }
}

