/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.mcp.core.props.MCPProperties;
import org.apache.seata.mcp.core.props.NameSpaceDetail;
import org.apache.seata.mcp.core.utils.DateUtils;
import org.apache.seata.mcp.entity.dto.McpGlobalLockParamDto;
import org.apache.seata.mcp.entity.param.McpGlobalLockDeleteParam;
import org.apache.seata.mcp.entity.param.McpGlobalLockParam;
import org.apache.seata.mcp.entity.vo.McpGlobalLockVO;
import org.apache.seata.mcp.service.ConsoleApiService;
import org.apache.seata.mcp.service.ModifyConfirmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springaicommunity.mcp.annotation.McpToolParam;
import org.springframework.stereotype.Service;

@Service
public class GlobalLockTools {
    private final Logger logger = LoggerFactory.getLogger(GlobalLockTools.class);
    private final ConsoleApiService mcpRPCService;
    private final MCPProperties mcpProperties;
    private final ModifyConfirmService modifyConfirmService;
    private final ObjectMapper objectMapper;

    public GlobalLockTools(ConsoleApiService mcpRPCService, MCPProperties mcpProperties, ModifyConfirmService modifyConfirmService, ObjectMapper objectMapper) {
        this.mcpRPCService = mcpRPCService;
        this.mcpProperties = mcpProperties;
        this.modifyConfirmService = modifyConfirmService;
        this.objectMapper = objectMapper;
    }

    @McpTool(description="Query the global lock information")
    public PageResult<McpGlobalLockVO> queryGlobalLock(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global lock parameters") McpGlobalLockParamDto paramDto) {
        McpGlobalLockParam param = McpGlobalLockParam.convertFromParamDto(paramDto);
        Long timeStart = param.getTimeStart();
        Long timeEnd = param.getTimeEnd();
        Long maxQueryDuration = this.mcpProperties.getQueryDuration();
        if (timeStart != null || timeEnd != null) {
            if (timeStart == null) {
                timeStart = timeEnd - maxQueryDuration;
                param.setTimeStart(timeStart);
            }
            if (timeEnd == null) {
                timeEnd = timeStart + maxQueryDuration;
                param.setTimeEnd(timeEnd);
            }
            if (DateUtils.judgeExceedTimeDuration(timeStart, timeEnd, maxQueryDuration)) {
                return PageResult.failure((String)"", (String)String.format("The query time span is not allowed to exceed the max query duration: %s hours", DateUtils.convertToHourFromTimeStamp(maxQueryDuration)));
            }
        }
        PageResult result = null;
        String response = this.mcpRPCService.getCallTC(nameSpaceDetail, "/api/v1/console/globalLock/query", (Object)param, null, null);
        try {
            result = (PageResult)this.objectMapper.readValue(response, (TypeReference)new TypeReference<PageResult<McpGlobalLockVO>>(){});
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage());
        }
        if (result == null) {
            return PageResult.failure((String)"", (String)"query global lock failed");
        }
        return result;
    }

    @McpTool(description="Delete the global lock, Get the modify key before you delete")
    public String deleteGlobalLock(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global lock delete parameters") McpGlobalLockDeleteParam param, @McpToolParam(description="Modify key") String modifyKey) {
        if (!this.modifyConfirmService.isValidKey(modifyKey).booleanValue()) {
            return "The modify key is not available";
        }
        String result = this.mcpRPCService.deleteCallTC(nameSpaceDetail, "/api/v1/console/globalLock/delete", param, null, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("delete global lock failed, xid: %s, branchId: %s", param.getXid(), param.getBranchId());
        }
        return result;
    }

    @McpTool(description="Check if the branch session has a lock")
    public String checkGlobalLock(@McpToolParam(description="Specify the namespace of the TC node") NameSpaceDetail nameSpaceDetail, @McpToolParam(description="Global transaction id") String xid, @McpToolParam(description="Branch transaction id") String branchId) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("xid", xid);
        pathParams.put("branchId", branchId);
        String result = this.mcpRPCService.getCallTC(nameSpaceDetail, "/api/v1/console/globalLock/check", null, pathParams, null);
        if (StringUtils.isBlank((String)result)) {
            return String.format("check global lock failed, xid: %s, branchId: %s", xid, branchId);
        }
        return result;
    }
}

