/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.Header;
import com.arjuna.ats.internal.arjuna.abstractrecords.ActivationRecord;
import com.arjuna.ats.internal.arjuna.abstractrecords.CadaverActivationRecord;
import com.arjuna.ats.internal.arjuna.abstractrecords.CadaverRecord;
import com.arjuna.ats.internal.arjuna.abstractrecords.DisposeRecord;
import com.arjuna.ats.internal.arjuna.abstractrecords.PersistenceRecord;
import com.arjuna.ats.internal.arjuna.abstractrecords.RecoveryRecord;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.objectstore.TwoPhaseVolatileStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class StateManager {
    protected Hashtable modifyingActions = null;
    protected Hashtable usingActions = null;
    protected final Uid objectUid;
    protected int objectModel = 0;
    private boolean activated = false;
    private boolean currentlyActivated = false;
    private int currentStatus = 0;
    private int initialStatus = 0;
    private int myType;
    private long creationTimeMillis = System.currentTimeMillis();
    private ParticipantStore participantStore = null;
    private String storeRoot = null;
    private ReentrantLock mutex = new ReentrantLock();
    protected final Lock synchronizationLock = new ReentrantLock();
    private static final String marker = "#ARJUNA#";
    private static final byte[] markerBytes = "#ARJUNA#".getBytes(StandardCharsets.UTF_8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save_state(OutputObjectState os, int ot) {
        this.synchronizationLock.lock();
        try {
            if (ot == 1) {
                try {
                    BasicAction action = BasicAction.Current();
                    if (action == null) {
                        this.packHeader(os, new Header(null, Utility.getProcessUid()));
                    } else {
                        this.packHeader(os, new Header(action.get_uid(), Utility.getProcessUid()));
                    }
                }
                catch (IOException e) {
                    boolean bl = false;
                    this.synchronizationLock.unlock();
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restore_state(InputObjectState os, int ot) {
        this.synchronizationLock.lock();
        try {
            if (ot == 1) {
                try {
                    this.unpackHeader(os, new Header());
                }
                catch (IOException e) {
                    boolean bl = false;
                    this.synchronizationLock.unlock();
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    public boolean activate() {
        return this.activate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(String rootName) {
        this.synchronizationLock.lock();
        try {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("StateManager::activate( " + (rootName != null ? rootName : "null") + ") for object-id " + String.valueOf(this.objectUid)));
            }
            if (this.myType == 2) {
                boolean bl = true;
                return bl;
            }
            if (this.currentStatus == 4) {
                boolean bl = false;
                return bl;
            }
            BasicAction action = null;
            int oldStatus = this.currentStatus;
            boolean result = true;
            boolean forceAR = false;
            action = BasicAction.Current();
            if (action != null && action.status() == 0) {
                ReentrantLock reentrantLock = this.mutex;
                synchronized (reentrantLock) {
                    this.createLists();
                    if (this.usingActions.get(action.get_uid()) == null) {
                        this.usingActions.put(action.get_uid(), action);
                        forceAR = true;
                    }
                }
            }
            if (forceAR || this.currentStatus == 0 || this.currentStatus == 1) {
                if (this.loadObjectState()) {
                    this.setupStore(rootName);
                }
                if (this.currentStatus == 0) {
                    if (this.loadObjectState()) {
                        InputObjectState oldState = null;
                        try {
                            oldState = this.participantStore.read_committed(this.objectUid, this.type());
                        }
                        catch (ObjectStoreException e) {
                            tsLogger.i18NLogger.warn_StateManager_16(e);
                            oldState = null;
                        }
                        if (oldState != null) {
                            result = this.restore_state(oldState, 1);
                            if (result) {
                                this.currentStatus = 2;
                            }
                        } else {
                            tsLogger.i18NLogger.warn_StateManager_2(this.objectUid, this.type());
                            boolean e = false;
                            return e;
                        }
                        oldState = null;
                    } else {
                        this.currentStatus = this.currentStatus == 1 ? 3 : 2;
                    }
                } else {
                    this.currentStatus = this.currentStatus == 1 ? 3 : 2;
                }
                if (forceAR || (this.currentStatus == 2 || this.currentStatus == 1) && action != null) {
                    int arStatus = 2;
                    ActivationRecord ar = new ActivationRecord(oldStatus, this, action);
                    arStatus = action.add(ar);
                    if (arStatus != 2) {
                        ar = null;
                        if (forceAR) {
                            ReentrantLock reentrantLock = this.mutex;
                            synchronized (reentrantLock) {
                                this.usingActions.remove(action.get_uid());
                            }
                        }
                        if (arStatus == 3) {
                            result = false;
                        }
                    } else {
                        this.activated = true;
                        this.currentlyActivated = true;
                    }
                } else if (this.currentStatus == 3) {
                    this.activated = true;
                    this.currentlyActivated = true;
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    public boolean deactivate() {
        return this.deactivate(null);
    }

    public boolean deactivate(String rootName) {
        return this.deactivate(rootName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(String rootName, boolean commit) {
        this.synchronizationLock.lock();
        try {
            boolean result;
            block12: {
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("StateManager::deactivate(" + (rootName != null ? rootName : "null") + ", " + commit + ") for object-id " + String.valueOf(this.objectUid)));
                }
                result = false;
                if (this.currentlyActivated && this.myType == 1 || this.loadObjectState()) {
                    this.setupStore(rootName);
                    if (this.currentStatus == 3 || this.currentStatus == 2) {
                        String tn = this.type();
                        OutputObjectState newState = new OutputObjectState(this.objectUid, tn);
                        if (this.save_state(newState, this.myType)) {
                            try {
                                if (commit) {
                                    result = this.participantStore.write_committed(this.objectUid, tn, newState);
                                    break block12;
                                }
                                result = this.participantStore.write_uncommitted(this.objectUid, tn, newState);
                            }
                            catch (ObjectStoreException e) {
                                tsLogger.i18NLogger.warn_StateManager_3(e);
                                result = false;
                            }
                        } else {
                            tsLogger.i18NLogger.warn_StateManager_4();
                        }
                    }
                } else {
                    result = true;
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    public int status() {
        this.synchronizationLock.lock();
        try {
            int n = this.currentStatus;
            return n;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    public int objectType() {
        this.synchronizationLock.lock();
        try {
            int n = this.myType;
            return n;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    public int getObjectModel() {
        return this.objectModel;
    }

    public final Uid get_uid() {
        return this.objectUid;
    }

    public final long getCreationTimeMillis() {
        return this.creationTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        this.synchronizationLock.lock();
        try {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("StateManager::destroy for object-id " + String.valueOf(this.objectUid)));
            }
            boolean result = false;
            if (this.participantStore != null) {
                BasicAction action = BasicAction.Current();
                if (action != null) {
                    DisposeRecord dr = new DisposeRecord(this.participantStore, this);
                    if (action.add(dr) != 2) {
                        dr = null;
                        tsLogger.i18NLogger.warn_StateManager_6(action.get_uid());
                    } else {
                        result = true;
                    }
                } else {
                    try {
                        result = this.participantStore.remove_committed(this.get_uid(), this.type());
                        if (result) {
                            this.destroyed();
                        }
                    }
                    catch (Exception e) {
                        tsLogger.i18NLogger.warn_StateManager_7(e);
                        result = false;
                    }
                }
            } else {
                tsLogger.i18NLogger.warn_StateManager_8();
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    public void disable() {
        this.synchronizationLock.lock();
        try {
            this.myType = 2;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    public void print(PrintWriter strm) {
        strm.println("Uid: " + String.valueOf(this.objectUid));
        strm.println("Type: " + this.type());
    }

    public String type() {
        return "/StateManager";
    }

    public final String getStoreRoot() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"StateManager::getStoreRoot ()");
        }
        return this.storeRoot;
    }

    public ParticipantStore getStore() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"StateManager::getStore ()");
        }
        if (this.participantStore == null) {
            this.setupStore();
        }
        return this.participantStore;
    }

    protected void packHeader(OutputObjectState os, Header hdr) throws IOException {
        Uid txId = hdr == null ? null : hdr.getTxId();
        Uid processUid = hdr == null ? null : hdr.getProcessId();
        try {
            os.packStringBytes(markerBytes);
            if (txId != null) {
                UidHelper.packInto(txId, os);
                UidHelper.packInto(processUid, os);
            } else {
                UidHelper.packInto(Uid.nullUid(), os);
            }
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("StateManager.packHeader for object-id " + String.valueOf(this.get_uid()) + " birth-date " + this.creationTimeMillis));
            }
            os.packLong(this.creationTimeMillis);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.toString());
            ioException.initCause(e);
            throw ioException;
        }
    }

    protected void unpackHeader(InputObjectState os, Header hdr) throws IOException {
        try {
            if (hdr == null) {
                throw new NullPointerException();
            }
            Uid txId = null;
            Uid processUid = null;
            String myState = os.unpackString();
            if (myState.equals(marker)) {
                txId = UidHelper.unpackFrom(os);
                if (!txId.equals(Uid.nullUid())) {
                    processUid = UidHelper.unpackFrom(os);
                }
            } else {
                if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                    tsLogger.i18NLogger.warn_StateManager_9();
                }
                throw new IOException(tsLogger.i18NLogger.get_StateManager_15());
            }
            this.creationTimeMillis = os.unpackLong();
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("StateManager.unpackHeader for object-id " + String.valueOf(this.get_uid()) + " birth-date " + this.creationTimeMillis));
            }
            hdr.setTxId(txId);
            hdr.setProcessId(processUid);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable e) {
            IOException ioException = new IOException(e.toString());
            ioException.initCause(e);
            throw ioException;
        }
    }

    protected void terminate() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("StateManager::terminate() for object-id " + String.valueOf(this.get_uid())));
        }
        this.cleanup(true);
    }

    protected final synchronized void setStatus(int s) {
        this.currentStatus = s;
    }

    protected StateManager(Uid objUid) {
        this(objUid, 1, 0);
    }

    protected StateManager(Uid objUid, int ot) {
        this(objUid, ot, 0);
    }

    protected StateManager(Uid objUid, int ot, int om) {
        this.objectModel = om;
        this.myType = ot;
        this.objectUid = objUid;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("StateManager::StateManager( " + String.valueOf(this.get_uid()) + " )"));
        }
    }

    protected StateManager() {
        this(0);
    }

    protected StateManager(int ot) {
        this(ot, 0);
    }

    protected StateManager(int ot, int om) {
        this.objectModel = om;
        this.initialStatus = this.currentStatus = this.objectModel == 0 && ot == 0 ? 2 : 1;
        this.myType = ot;
        this.objectUid = new Uid();
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("StateManager::StateManager( " + ot + ", " + om + " )"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean modified() {
        this.synchronizationLock.lock();
        try {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("StateManager::modified() for object-id " + String.valueOf(this.get_uid())));
            }
            BasicAction action = BasicAction.Current();
            RecoveryRecord record = null;
            if (this.myType == 2 || this.currentStatus == 4) {
                boolean bl = true;
                return bl;
            }
            if (this.currentStatus == 0) {
                tsLogger.i18NLogger.warn_StateManager_10();
                this.activate();
            }
            if (this.currentStatus == 1) {
                this.currentStatus = 3;
            }
            if (action != null) {
                this.createLists();
                Hashtable hashtable = this.modifyingActions;
                synchronized (hashtable) {
                    block22: {
                        if (this.modifyingActions.isEmpty() || this.modifyingActions.get(action.get_uid()) == null) break block22;
                        boolean bl = true;
                        return bl;
                    }
                    this.modifyingActions.put(action.get_uid(), action);
                }
                OutputObjectState state = new OutputObjectState(this.objectUid, this.type());
                int rStatus = 2;
                if (this.save_state(state, 0)) {
                    record = this.myType == 0 && this.objectModel == 0 ? new RecoveryRecord(state, this) : new PersistenceRecord(state, this.participantStore, this);
                    rStatus = action.add(record);
                    if (rStatus != 2) {
                        Hashtable hashtable2 = this.modifyingActions;
                        synchronized (hashtable2) {
                            this.modifyingActions.remove(action.get_uid());
                        }
                        record = null;
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    protected final void persist() {
        this.synchronizationLock.lock();
        try {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("StateManager::persist() for object-id " + String.valueOf(this.get_uid())));
            }
            if (this.currentStatus == 2) {
                this.currentStatus = 1;
                this.myType = 1;
            }
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void cleanup(boolean fromTerminate) {
        this.synchronizationLock.lock();
        try {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("StateManager::cleanup() for object-id " + String.valueOf(this.get_uid())));
            }
            if (this.myType == 2) {
                return;
            }
            BasicAction action = null;
            ReentrantLock reentrantLock = this.mutex;
            synchronized (reentrantLock) {
                this.createLists();
                if (!this.usingActions.isEmpty()) {
                    Enumeration e = this.usingActions.keys();
                    while (e.hasMoreElements()) {
                        action = (BasicAction)this.usingActions.remove(e.nextElement());
                        if (action == null) continue;
                        AbstractRecord record = null;
                        int rStatus = 2;
                        if (this.currentStatus == 3 || this.currentStatus == 2) {
                            OutputObjectState state = null;
                            tsLogger.i18NLogger.warn_StateManager_11(this.objectUid, this.type());
                            if (fromTerminate) {
                                state = new OutputObjectState(this.objectUid, this.type());
                                if (!this.save_state(state, this.myType)) {
                                    tsLogger.i18NLogger.warn_StateManager_12();
                                    action.preventCommit();
                                }
                            } else {
                                action.preventCommit();
                            }
                            this.setupStore(this.storeRoot);
                            record = new CadaverRecord(state, this.participantStore, this);
                            rStatus = action.add(record);
                            if (rStatus != 2) {
                                record = null;
                            }
                        }
                        if (!this.currentlyActivated || this.currentStatus == 4) continue;
                        record = new CadaverActivationRecord(this);
                        rStatus = action.add(record);
                        if (rStatus == 2) {
                            this.currentStatus = 0;
                            continue;
                        }
                        tsLogger.i18NLogger.warn_StateManager_6(action.get_uid());
                        record = null;
                    }
                }
            }
            if (this.currentStatus == 3) {
                this.currentStatus = this.myType == 0 && this.objectModel == 0 ? 2 : 0;
            }
            this.currentlyActivated = false;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    protected final void setupStore() {
        this.setupStore(null);
    }

    protected void setupStore(String rootName) {
        this.synchronizationLock.lock();
        try {
            this.setupStore(rootName, arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreType());
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupStore(String rootName, String objectStoreType) {
        block17: {
            this.synchronizationLock.lock();
            try {
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("StateManager::setupStore ( " + (rootName != null ? rootName : "null") + " )"));
                }
                if (!this.loadObjectState()) {
                    return;
                }
                if (this.participantStore != null) {
                    return;
                }
                if (rootName == null) {
                    rootName = arjPropertyManager.getObjectStoreEnvironmentBean().getLocalOSRoot();
                }
                if (this.storeRoot != null) {
                    if (rootName == null || rootName.compareTo("") == 0 || rootName.compareTo(this.storeRoot) == 0) {
                        return;
                    }
                    this.participantStore = null;
                }
                if (rootName == null) {
                    rootName = "";
                }
                this.storeRoot = new String(rootName);
                if (this.myType == 1 || this.myType == 2) {
                    int sharedStatus = this.objectModel == 0 ? 14 : 13;
                    this.participantStore = StoreManager.setupStore(rootName, sharedStatus);
                    break block17;
                }
                try {
                    this.participantStore = new TwoPhaseVolatileStore(new ObjectStoreEnvironmentBean());
                }
                catch (Throwable ex) {
                    if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                        tsLogger.i18NLogger.warn_StateManager_13();
                    }
                    throw new FatalError(tsLogger.i18NLogger.get_StateManager_14());
                }
            }
            finally {
                this.synchronizationLock.unlock();
            }
        }
    }

    protected final boolean loadObjectState() {
        boolean load;
        boolean bl = load = this.objectModel != 0;
        if (!load && this.myType != 0 && !this.activated) {
            load = true;
        }
        return load;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean forgetAction(BasicAction action, boolean committed, int recordType) {
        this.synchronizationLock.lock();
        try {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("StateManager::forgetAction(" + String.valueOf(action != null ? action.get_uid() : Uid.nullUid()) + ") for object-id " + String.valueOf(this.objectUid)));
            }
            this.createLists();
            Serializable serializable = this.modifyingActions;
            synchronized (serializable) {
                this.modifyingActions.remove(action.get_uid());
            }
            if (recordType != 101) {
                serializable = this.mutex;
                synchronized (serializable) {
                    if (this.usingActions != null) {
                        this.usingActions.remove(action.get_uid());
                        if (this.usingActions.isEmpty()) {
                            if (committed) {
                                if (this.myType == 0 && this.objectModel == 0 || action.typeOfAction() == 1) {
                                    this.currentStatus = 2;
                                    this.initialStatus = 2;
                                } else {
                                    this.currentStatus = 0;
                                    this.initialStatus = 0;
                                }
                            } else if (this.objectModel == 0) {
                                this.currentStatus = this.initialStatus;
                            } else {
                                this.currentStatus = 0;
                                this.initialStatus = 0;
                            }
                        }
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean rememberAction(BasicAction action, int recordType, int state) {
        this.synchronizationLock.lock();
        try {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("StateManager::rememberAction(" + String.valueOf(action != null ? action.get_uid() : Uid.nullUid()) + ") for object-id " + String.valueOf(this.objectUid)));
            }
            boolean result = false;
            if (recordType != 101) {
                if (action != null && action.status() == 0) {
                    ReentrantLock reentrantLock = this.mutex;
                    synchronized (reentrantLock) {
                        this.createLists();
                        if (this.usingActions.get(action.get_uid()) == null) {
                            this.usingActions.put(action.get_uid(), action);
                        }
                    }
                }
                if (this.currentStatus == 0 || this.currentStatus == 1) {
                    this.currentStatus = state;
                }
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    protected final ReentrantLock getMutex() {
        return this.mutex;
    }

    protected final boolean lockMutex() {
        try {
            this.mutex.lock();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    protected final boolean unlockMutex() {
        try {
            this.mutex.unlock();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    protected final boolean tryLockMutex() {
        return this.mutex.tryLock();
    }

    protected void createLists() {
        this.synchronizationLock.lock();
        try {
            if (this.modifyingActions == null) {
                this.modifyingActions = new Hashtable();
                this.usingActions = new Hashtable();
            }
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }

    final void destroyed() {
        this.synchronizationLock.lock();
        try {
            this.currentStatus = 4;
        }
        finally {
            this.synchronizationLock.unlock();
        }
    }
}

