/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.polaris.service.types.PolicyAttachmentTarget;

public class AttachPolicyRequest {
    @NotNull
    @Valid
    private final PolicyAttachmentTarget target;
    private final Map<String, String> parameters;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="target", required=true)
    public PolicyAttachmentTarget getTarget() {
        return this.target;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="parameters")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonCreator
    public AttachPolicyRequest(@JsonProperty(value="target", required=true) PolicyAttachmentTarget target, @JsonProperty(value="parameters") Map<String, String> parameters) {
        this.target = target;
        this.parameters = Objects.requireNonNullElse(parameters, new HashMap());
    }

    public AttachPolicyRequest(PolicyAttachmentTarget target) {
        this.target = target;
        this.parameters = new HashMap<String, String>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PolicyAttachmentTarget target) {
        return new Builder(target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachPolicyRequest attachPolicyRequest = (AttachPolicyRequest)o;
        return Objects.equals(this.target, attachPolicyRequest.target) && Objects.equals(this.parameters, attachPolicyRequest.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachPolicyRequest {\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private PolicyAttachmentTarget target;
        private Map<String, String> parameters;

        private Builder() {
        }

        private Builder(PolicyAttachmentTarget target) {
            this.target = target;
        }

        public Builder setTarget(PolicyAttachmentTarget target) {
            this.target = target;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public AttachPolicyRequest build() {
            AttachPolicyRequest inst = new AttachPolicyRequest(this.target, this.parameters);
            return inst;
        }
    }
}

