/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.polaris.extension.auth.opa.token;

import static com.google.common.base.Preconditions.checkArgument;

import com.google.common.base.Strings;

/** A simple token provider that returns a static string value. */
public class StaticBearerTokenProvider implements BearerTokenProvider {

  private final String token;

  public StaticBearerTokenProvider(String token) {
    checkArgument(!Strings.isNullOrEmpty(token), "Token cannot be null or empty");
    this.token = token;
  }

  @Override
  public String getToken() {
    return token;
  }
}
