/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.List;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.JavaHash;
import org.apache.iceberg.types.Types;

public class JavaHashes {
    private JavaHashes() {
    }

    public static int hashCode(CharSequence str) {
        if (null == str) {
            return 0;
        }
        int result = 177;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            result = 31 * result + ch;
        }
        return result;
    }

    static JavaHash<Object> strings() {
        return CharSequenceHash.INSTANCE;
    }

    static JavaHash<StructLike> struct(Types.StructType struct) {
        return new StructLikeHash(struct);
    }

    static JavaHash<List<?>> list(Types.ListType list) {
        return new ListHash(list);
    }

    private static class CharSequenceHash
    implements JavaHash<Object> {
        private static final CharSequenceHash INSTANCE = new CharSequenceHash();

        private CharSequenceHash() {
        }

        @Override
        public int hash(Object str) {
            if (str instanceof CharSequence) {
                return JavaHashes.hashCode((CharSequence)str);
            }
            if (str != null) {
                return JavaHashes.hashCode(str.toString());
            }
            return 0;
        }
    }

    private static class StructLikeHash
    implements JavaHash<StructLike> {
        private final JavaHash<Object>[] hashes;

        private StructLikeHash(Types.StructType struct) {
            this.hashes = (JavaHash[])struct.fields().stream().map(Types.NestedField::type).map(JavaHash::forType).toArray(JavaHash[]::new);
        }

        @Override
        public int hash(StructLike struct) {
            if (struct == null) {
                return 0;
            }
            int result = 97;
            int len = this.hashes.length;
            result = 41 * result + len;
            for (int i = 0; i < len; ++i) {
                result = 41 * result + this.hashes[i].hash(struct.get(i, Object.class));
            }
            return result;
        }
    }

    private static class ListHash
    implements JavaHash<List<?>> {
        private final JavaHash<Object> elementHash;

        private ListHash(Types.ListType list) {
            this.elementHash = JavaHash.forType(list.elementType());
        }

        @Override
        public int hash(List<?> list) {
            if (list == null) {
                return 0;
            }
            int result = 17;
            result = 37 * result + list.size();
            for (Object o : list) {
                result = 37 * result + this.elementHash.hash(o);
            }
            return result;
        }
    }
}

