/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.profiles.Profile;

@FunctionalInterface
@SdkProtectedApi
public interface ChildProfileCredentialsProviderFactory {
    public AwsCredentialsProvider create(AwsCredentialsProvider var1, Profile var2);

    default public AwsCredentialsProvider create(ChildProfileCredentialsRequest request) {
        return this.create(request.sourceCredentialsProvider(), request.profile());
    }

    public static final class ChildProfileCredentialsRequest {
        private final AwsCredentialsProvider sourceCredentialsProvider;
        private final Profile profile;
        private final String sourceChain;

        private ChildProfileCredentialsRequest(Builder builder) {
            this.sourceCredentialsProvider = builder.sourceCredentialsProvider;
            this.profile = builder.profile;
            this.sourceChain = builder.sourceChain;
        }

        public static Builder builder() {
            return new Builder();
        }

        public AwsCredentialsProvider sourceCredentialsProvider() {
            return this.sourceCredentialsProvider;
        }

        public Profile profile() {
            return this.profile;
        }

        public String sourceChain() {
            return this.sourceChain;
        }

        public static final class Builder {
            private AwsCredentialsProvider sourceCredentialsProvider;
            private Profile profile;
            private String sourceChain;

            public Builder sourceCredentialsProvider(AwsCredentialsProvider sourceCredentialsProvider) {
                this.sourceCredentialsProvider = sourceCredentialsProvider;
                return this;
            }

            public Builder profile(Profile profile) {
                this.profile = profile;
                return this;
            }

            public Builder sourceChain(String sourceChain) {
                this.sourceChain = sourceChain;
                return this;
            }

            public ChildProfileCredentialsRequest build() {
                return new ChildProfileCredentialsRequest(this);
            }
        }
    }
}

