/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfig {
    private static final Logger logger = LoggerFactory.getLogger(NacosConfig.class);
    private String serverAddr;
    private String dataId;
    private String group = "DEFAULT_GROUP";
    private Properties properties;
    private ConfigService configService;

    @PostConstruct
    public void init() {
        String nacosAddr = System.getenv("nacos_addr");
        if (StringUtils.isNotEmpty((CharSequence)nacosAddr)) {
            this.serverAddr = nacosAddr;
        }
        if (this.serverAddr == null || this.serverAddr.length() == 0) {
            return;
        }
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        if (null != this.properties) {
            this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.put(k, v)));
        }
        try {
            this.configService = NacosFactory.createConfigService((Properties)properties);
        }
        catch (Exception e) {
            logger.error("[NacosConfig.init] fail to init nacos config, serverAddr:{}, dataId: {}, group: {}, msg: {}", new Object[]{this.serverAddr, this.dataId, this.group, e.getCause()});
        }
    }

    public boolean close() {
        try {
            logger.info("nacos client close");
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public String getConfig(String key) {
        try {
            Map<String, String> configMap = this.getConfigMap();
            return configMap.get(key);
        }
        catch (Exception e) {
            logger.error("[NacosConfig.getConfig] fail to get config, serverAddr:{}, dataId: {}, group: {}, msg: {}", new Object[]{this.serverAddr, this.dataId, this.group, e.getMessage()});
            return "";
        }
    }

    public Map<String, String> getConfig() {
        try {
            return this.getConfigMap();
        }
        catch (Exception e) {
            logger.error("[NacosConfig.getConfig] fail to get config, serverAddr:{}, dataId: {}, group: {}, msg: {}", new Object[]{this.serverAddr, this.dataId, this.group, e.getMessage()});
            return new HashMap<String, String>();
        }
    }

    private Map<String, String> getConfigMap() throws NacosException {
        return this.getConfigMap(this.dataId, this.group);
    }

    public Map<String, String> getConfigMap(String dataId, String group) throws NacosException {
        String content = this.configService.getConfig(dataId, group, 5000L);
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (content != null && content.length() != 0) {
            String[] perConfig;
            for (String it : perConfig = content.split("\n|\r\n")) {
                int index;
                if (it == null || it.length() == 0 || it.startsWith("#") || (index = it.indexOf("=")) <= -1) continue;
                configMap.put(it.substring(0, index), it.substring(index + 1));
            }
        }
        return configMap;
    }

    public String getConfigStr(String dataId, String group, long timeout) throws NacosException {
        String content = this.configService.getConfig(dataId, group, timeout);
        return content;
    }

    public String getConfigStr(long timeout) throws NacosException {
        String content = this.configService.getConfig(this.dataId, this.group, timeout);
        return content;
    }

    public boolean publishConfig(String dataId, String group, String content) throws NacosException {
        return this.configService.publishConfig(dataId, group, content);
    }

    public boolean publishConfig(String content) throws NacosException {
        return this.configService.publishConfig(this.dataId, this.group, content);
    }

    public boolean deleteConfig(String dataId, String group) throws NacosException {
        return this.configService.removeConfig(dataId, group);
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }
}

