/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.util.List;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class IgnoredColumn {
    protected String columnName;
    private boolean isColumnNameDelimited;
    protected String configuredDelimitedColumnName;

    public IgnoredColumn(String columnName) {
        this.columnName = columnName;
        this.isColumnNameDelimited = StringUtility.stringContainsSpace(columnName);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isColumnNameDelimited() {
        return this.isColumnNameDelimited;
    }

    public void setColumnNameDelimited(boolean isColumnNameDelimited) {
        this.isColumnNameDelimited = isColumnNameDelimited;
        this.configuredDelimitedColumnName = isColumnNameDelimited ? "true" : "false";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IgnoredColumn)) {
            return false;
        }
        return this.columnName.equals(((IgnoredColumn)obj).getColumnName());
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    public XmlElement toXmlElement() {
        XmlElement xmlElement = new XmlElement("ignoreColumn");
        xmlElement.addAttribute(new Attribute("column", this.columnName));
        if (StringUtility.stringHasValue(this.configuredDelimitedColumnName)) {
            xmlElement.addAttribute(new Attribute("delimitedColumnName", this.configuredDelimitedColumnName));
        }
        return xmlElement;
    }

    public void validate(List<String> errors, String tableName) {
        if (!StringUtility.stringHasValue(this.columnName)) {
            errors.add(Messages.getString("ValidationError.21", tableName));
        }
    }

    public boolean matches(String columnName) {
        if (this.isColumnNameDelimited) {
            return this.columnName.equals(columnName);
        }
        return this.columnName.equalsIgnoreCase(columnName);
    }
}

