/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.Internal;
import org.apache.poi.util.StringUtil;

@Internal
public abstract class POILogger {
    public static final int DEBUG = 1;
    public static final int INFO = 3;
    public static final int WARN = 5;
    public static final int ERROR = 7;
    public static final int FATAL = 9;
    protected static final String[] LEVEL_STRINGS_SHORT = new String[]{"?", "D", "?", "I", "?", "W", "?", "E", "?", "F", "?"};
    protected static final String[] LEVEL_STRINGS = new String[]{"?0?", "DEBUG", "?2?", "INFO", "?4?", "WARN", "?6?", "ERROR", "?8?", "FATAL", "?10+?"};

    POILogger() {
    }

    public abstract void initialize(String var1);

    protected abstract void log(int var1, Object var2);

    protected abstract void log(int var1, Object var2, Throwable var3);

    public abstract boolean check(int var1);

    public void log(int level, Object ... objs) {
        if (!this.check(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder(32);
        Throwable lastEx = null;
        for (int i = 0; i < objs.length; ++i) {
            if (i == objs.length - 1 && objs[i] instanceof Throwable) {
                lastEx = (Throwable)objs[i];
                continue;
            }
            sb.append(objs[i]);
        }
        String msg = sb.toString();
        msg = msg.replaceAll("[\r\n]+", " ");
        if (lastEx == null) {
            this.log(level, (Object)msg);
        } else {
            this.log(level, (Object)msg, lastEx);
        }
    }

    public void logFormatted(int level, String message, Object ... unflatParams) {
        if (!this.check(level)) {
            return;
        }
        Object[] params = this.flattenArrays(unflatParams);
        String msg = StringUtil.format(message, params);
        msg = msg.replaceAll("[\r\n]+", " ");
        if (params.length > 0 && params[params.length - 1] instanceof Throwable) {
            this.log(level, (Object)msg, (Throwable)params[params.length - 1]);
        } else {
            this.log(level, (Object)msg);
        }
    }

    private Object[] flattenArrays(Object ... unflatParams) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object obj : unflatParams) {
            this.flattenObject(results, obj);
        }
        return results.toArray(new Object[results.size()]);
    }

    private void flattenObject(List<Object> results, Object object) {
        if (object instanceof byte[]) {
            for (byte b : (byte[])object) {
                results.add(b);
            }
        } else if (object instanceof char[]) {
            for (char c : (char[])object) {
                results.add(Character.valueOf(c));
            }
        } else if (object instanceof short[]) {
            for (short s : (short[])object) {
                results.add(s);
            }
        } else if (object instanceof int[]) {
            for (int i : (int[])object) {
                results.add(i);
            }
        } else if (object instanceof long[]) {
            for (long l : (long[])object) {
                results.add(l);
            }
        } else if (object instanceof float[]) {
            for (float f : (float[])object) {
                results.add(Float.valueOf(f));
            }
        } else if (object instanceof double[]) {
            for (double d : (double[])object) {
                results.add(d);
            }
        } else if (object instanceof Object[]) {
            for (Object o : (Object[])object) {
                results.add(o);
            }
        } else {
            results.add(object);
        }
    }
}

