/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.NPOIFSStream;
import org.apache.poi.poifs.property.NPropertyTable;
import org.apache.poi.poifs.storage.HeaderBlock;

public class POIFSDump {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Must specify at least one file to dump");
            System.exit(1);
        }
        boolean dumpProps = false;
        boolean dumpMini = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-dumprops") || args[i].equalsIgnoreCase("-dump-props") || args[i].equalsIgnoreCase("-dump-properties")) {
                dumpProps = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-dumpmini") || args[i].equalsIgnoreCase("-dump-mini") || args[i].equalsIgnoreCase("-dump-ministream") || args[i].equalsIgnoreCase("-dump-mini-stream")) {
                dumpMini = true;
                continue;
            }
            System.out.println("Dumping " + args[i]);
            FileInputStream is = new FileInputStream(args[i]);
            NPOIFSFileSystem fs = new NPOIFSFileSystem(is);
            is.close();
            DirectoryNode root = fs.getRoot();
            File file = new File(root.getName());
            file.mkdir();
            POIFSDump.dump(root, file);
            if (dumpProps) {
                HeaderBlock header = fs.getHeaderBlock();
                POIFSDump.dump(fs, header.getPropertyStart(), "properties", file);
            }
            if (!dumpMini) continue;
            NPropertyTable props = fs.getPropertyTable();
            int startBlock = props.getRoot().getStartBlock();
            if (startBlock == -2) {
                System.err.println("No Mini Stream in file");
                continue;
            }
            POIFSDump.dump(fs, startBlock, "mini-stream", file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(DirectoryEntry root, File parent) throws IOException {
        Iterator<Entry> it = root.getEntries();
        while (it.hasNext()) {
            Entry entry = it.next();
            if (entry instanceof DocumentNode) {
                DocumentNode node = (DocumentNode)entry;
                DocumentInputStream is = new DocumentInputStream(node);
                byte[] bytes = new byte[node.getSize()];
                is.read(bytes);
                is.close();
                FileOutputStream out = new FileOutputStream(new File(parent, node.getName().trim()));
                try {
                    ((OutputStream)out).write(bytes);
                    continue;
                }
                finally {
                    ((OutputStream)out).close();
                    continue;
                }
            }
            if (entry instanceof DirectoryEntry) {
                DirectoryEntry dir = (DirectoryEntry)entry;
                File file = new File(parent, entry.getName());
                file.mkdir();
                POIFSDump.dump(dir, file);
                continue;
            }
            System.err.println("Skipping unsupported POIFS entry: " + entry);
        }
    }

    public static void dump(NPOIFSFileSystem fs, int startBlock, String name, File parent) throws IOException {
        File file = new File(parent, name);
        FileOutputStream out = new FileOutputStream(file);
        NPOIFSStream stream = new NPOIFSStream(fs, startBlock);
        byte[] b = new byte[fs.getBigBlockSize()];
        for (ByteBuffer bb : stream) {
            int len = bb.remaining();
            bb.get(b);
            out.write(b, 0, len);
        }
        out.close();
    }
}

