/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect;

import com.github.pagehelper.Constant;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageRowBounds;
import com.github.pagehelper.dialect.AbstractDialect;
import com.github.pagehelper.parser.OrderByParser;
import com.github.pagehelper.util.ExecutorUtil;
import com.github.pagehelper.util.MetaObjectUtil;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.RowBounds;

public abstract class AbstractHelperDialect
extends AbstractDialect
implements Constant {
    public <T> Page<T> getLocalPage() {
        return PageHelper.getLocalPage();
    }

    @Override
    public final boolean skip(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return true;
    }

    @Override
    public boolean beforeCount(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        Page page = this.getLocalPage();
        return !page.isOrderByOnly() && page.isCount();
    }

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        Page page = this.getLocalPage();
        String countColumn = page.getCountColumn();
        if (StringUtil.isNotEmpty(countColumn)) {
            return this.countSqlParser.getSmartCountSql(boundSql.getSql(), countColumn);
        }
        return this.countSqlParser.getSmartCountSql(boundSql.getSql());
    }

    @Override
    public boolean afterCount(long count, Object parameterObject, RowBounds rowBounds) {
        Page page = this.getLocalPage();
        page.setTotal(count);
        if (rowBounds instanceof PageRowBounds) {
            ((PageRowBounds)rowBounds).setTotal(count);
        }
        if (page.getPageSizeZero() != null) {
            if (!page.getPageSizeZero().booleanValue() && page.getPageSize() <= 0) {
                return false;
            }
            if (page.getPageSizeZero().booleanValue() && page.getPageSize() < 0) {
                return false;
            }
        }
        return page.getPageNum() > 0 && count > page.getStartRow();
    }

    @Override
    public Object processParameterObject(MappedStatement ms, Object parameterObject, BoundSql boundSql, CacheKey pageKey) {
        Page page = this.getLocalPage();
        if (page.isOrderByOnly()) {
            return parameterObject;
        }
        HashMap<String, Object> paramMap = null;
        if (parameterObject == null) {
            paramMap = new HashMap<String, Object>();
        } else if (parameterObject instanceof Map) {
            paramMap = new HashMap();
            paramMap.putAll((Map)parameterObject);
        } else {
            String[] providerMethodArgumentNames;
            paramMap = new HashMap();
            if (ms.getSqlSource() instanceof ProviderSqlSource && (providerMethodArgumentNames = ExecutorUtil.getProviderMethodArgumentNames((ProviderSqlSource)ms.getSqlSource())) != null && providerMethodArgumentNames.length == 1) {
                paramMap.put(providerMethodArgumentNames[0], parameterObject);
                paramMap.put("param1", parameterObject);
            }
            boolean hasTypeHandler = ms.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass());
            MetaObject metaObject = MetaObjectUtil.forObject(parameterObject);
            if (!hasTypeHandler) {
                for (String name : metaObject.getGetterNames()) {
                    paramMap.put(name, metaObject.getValue(name));
                }
            }
            if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                    String name = parameterMapping.getProperty();
                    if (name.equals("First_PageHelper") || name.equals("Second_PageHelper") || paramMap.get(name) != null || !hasTypeHandler && !parameterMapping.getJavaType().equals(parameterObject.getClass())) continue;
                    paramMap.put(name, parameterObject);
                    break;
                }
            }
        }
        return this.processPageParameter(ms, paramMap, page, boundSql, pageKey);
    }

    public abstract Object processPageParameter(MappedStatement var1, Map<String, Object> var2, Page var3, BoundSql var4, CacheKey var5);

    @Override
    public boolean beforePage(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        Page page = this.getLocalPage();
        return page.isOrderByOnly() || page.getPageSize() > 0;
    }

    @Override
    public String getPageSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey pageKey) {
        String sql = boundSql.getSql();
        Page page = this.getLocalPage();
        String orderBy = page.getOrderBy();
        if (StringUtil.isNotEmpty(orderBy)) {
            pageKey.update((Object)orderBy);
            sql = OrderByParser.converToOrderBySql(sql, orderBy);
        }
        if (page.isOrderByOnly()) {
            return sql;
        }
        return this.getPageSql(sql, page, pageKey);
    }

    public abstract String getPageSql(String var1, Page var2, CacheKey var3);

    @Override
    public Object afterPage(List pageList, Object parameterObject, RowBounds rowBounds) {
        Page page = this.getLocalPage();
        if (page == null) {
            return pageList;
        }
        page.addAll(pageList);
        if (!page.isCount()) {
            page.setTotal(-1L);
        } else if (page.getPageSizeZero() != null && page.getPageSizeZero().booleanValue() && page.getPageSize() == 0) {
            page.setTotal(pageList.size());
        } else if (page.isOrderByOnly()) {
            page.setTotal(pageList.size());
        }
        return page;
    }

    @Override
    public void afterAll() {
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Deprecated
    protected void handleParameter(BoundSql boundSql, MappedStatement ms) {
        if (boundSql.getParameterMappings() != null) {
            this.handleParameter(boundSql, ms, Long.TYPE, Long.TYPE);
        }
    }

    protected void handleParameter(BoundSql boundSql, MappedStatement ms, Class<?> firstClass, Class<?> secondClass) {
        if (boundSql.getParameterMappings() != null) {
            ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>(boundSql.getParameterMappings());
            newParameterMappings.add(new ParameterMapping.Builder(ms.getConfiguration(), "First_PageHelper", firstClass).build());
            newParameterMappings.add(new ParameterMapping.Builder(ms.getConfiguration(), "Second_PageHelper", secondClass).build());
            MetaObject metaObject = MetaObjectUtil.forObject(boundSql);
            metaObject.setValue("parameterMappings", newParameterMappings);
        }
    }
}

